#define IWAPI_OK			0
#define MIDI_API_OK			0
#define WAV_API_OK			0
#define MOD_API_OKAY			0
#define IWAPI_ERROR			-100
#define WAV_API_HARDWARE_UNAVAIL	-100
#define WAV_API_FILE_NOT_FOUND		-101
#define WAV_API_NOT_WAVE		-102
#define WAV_API_INVALID_FORMAT		-103
#define WAV_API_INVALID_SAMPLE_SIZE	-104
#define WAV_API_NO_DATA			-105
#define WAV_API_NO_MEMORY		-106

#define MIDI_API_CORRUPT_FILE		-200
#define MIDI_API_FILE_NOT_FOUND		-201
#define MIDI_API_NO_MEMORY		-202
#define MIDI_API_DUMB_PROGRAMMER	-203

#define	MOD_API_ERROR_ALLOC_STRUCT	-300
#define	MOD_API_ERROR_LOADING_HEADER	-301
#define	MOD_API_ERROR_NOT_A_MODULE	-302
#define	MOD_API_ERROR_LOADING_TRACK	-303
#define	MOD_API_ERROR_LOADING_PATTERN	-304
#define	MOD_API_ERROR_LOADING_SAMPLEINFO	-305
#define	MOD_API_ERROR_LOADING_SAMPLE	-306
#define	MOD_API_ERROR_CANT_OPEN_FILE	-307
#define	MOD_API_ERROR_NO_MEMORY		-308

/* WAVE */
void PauseWave(void);
void UnPauseWave(void);
void StopWaveFile(void);
int PlayWaveFile(char *fname);
int PollWave(void);
int InitWave(void);
void DeInitWave(void);
void SetWaveBufferSizes(unsigned short dbs, unsigned short dmabs, int nb);

/* MIDI */
int InitMidi(void);
void DeInitMidi(void);
int PollMidi(void);
int PlayMidiFile(char *fname);
void StopMidiFile(void);
void PauseMidiFile(void);
void UnPauseMidiFile(void);

/* MOD */
void PauseMod(void);
void UnPauseMod(void);
void StopModFile(void);
int PlayModFile(char *fname);
int PollMod(void);
int InitMod(void);
void DeInitMod(void);

/* API */
void DeInitIW(void);
int InitIW(void);
char *iwapi_error_str(int err);
