API=api
MODEL = l
INCLUDE = -I$(INCLUDEPATH);$(API);$(KERNEL)
APILIBPATH = api
LIBS = iwapi.lib
CFLAGS = $(INCLUDE) -3 -Ox -Os -j7 -m$(MODEL)
PLAY_OBJS = play.obj
MLSCOMP = $(TOOLS)\mlscomp\mlscomp

.c.obj:
	bcc -c +bcc.cfg { $*.c}

all: bcc.cfg play.exe english\play.mls

dist: play.exe english\play.mls api\english\iwapi.mls
	cp play.exe $(IWPROJ)\dist\apps
	cp english\play.mls $(IWPROJ)\dist\language\english
	cp api\english\iwapi.mls $(IWPROJ)\dist\language\english

english\play.mls: english\play.txt
	$(MLSCOMP) english\play.txt

api\english\iwapi.mls: api\english\iwapi.txt
	$(MLSCOMP) api\english\iwapi.txt
	
bcc.cfg:
	copy &&|
$(CFLAGS)
| bcc.cfg

$(APILIBPATH)\$(LIBS):
	cd api
	maker -f borland.mak
	cd ..
	
play.exe: $(PLAY_OBJS) $(APILIBPATH)\$(LIBS)
	bcc -M -L$(LIBPATH) $(CFLAGS) $(PLAY_OBJS) $(APILIBPATH)\$(LIBS)
	
cleanall: clean

clean:
	rm -f bcc.cfg
	rm -f api/bcc.cfg
	rm -f *.obj
	rm -f *.exe
	rm -f api/*.obj
	rm -f api/*.lib
	rm -f api/mikmod/bin/*.obj
	rm -f api/mikmod/mikmod.cfg
	rm -f kernel/*.obj
	rm -f kernel/*.lib
