#include <conio.h>
#include <dos.h>
#include <direct.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <signal.h>

#include "iw.h"
#include "iwapi.h"

#define MAX_FILES 100
int file_list_index = 0;
char *file_list[MAX_FILES] =
{
	0L
};
int user_is_tired = 0;
int not_done_playing = 1;
int midi_file = 0;
int wav_file = 0;
int mod_file = 0;
int wav_use_codec = 1;

#define CANT_FIND_FILE	1
#define DO_HELP		2
#define COPYRIGHT	3
#define HELP		4

#define ERR_STR_BUFLEN 4096
static char err_str[ERR_STR_BUFLEN];

void multiple_load(char *files)
{
    struct find_t fileinfo;
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char file[_MAX_FNAME];
    char ext[_MAX_EXT];
    char path[_MAX_PATH];
    char fpath[_MAX_PATH];
    int ret;

    _splitpath(files,drive,dir,file,ext);
    _makepath(path,drive,dir,NULL,NULL);
    ret = _dos_findfirst(files, _A_NORMAL, &fileinfo);
    if (ret != 0) {
	iw_mls_getstring("play.mls", CANT_FIND_FILE, err_str, ERR_STR_BUFLEN);
	fprintf(stderr, err_str, files);
    }
    while (ret == 0) {
	strcpy(fpath, path);
	strcat(fpath, fileinfo.name);
	file_list[file_list_index] = malloc(strlen(fpath)+1);
	if (file_list[file_list_index]) {
	    strcpy(file_list[file_list_index], fpath);
	    file_list_index++;
	    file_list[file_list_index] = 0;
	}
	ret = _dos_findnext(&fileinfo);
    }
}

void do_help(void)
{
    iw_mls_getstring("play.mls", DO_HELP, err_str, ERR_STR_BUFLEN);
    printf("%s\n", err_str);
    exit(0);
}

int start_next_file(void)
{
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char file[_MAX_FNAME];
    char ext[_MAX_EXT];
    char path[_MAX_PATH];
    char fpath[_MAX_PATH];
    int ret;

    if (file_list[file_list_index] == 0L) {
	not_done_playing = 0;
	user_is_tired = 1;
	return(1);
    } else {
        midi_file = 0;
        wav_file = 0;
	mod_file = 0;
	printf("%s\n", file_list[file_list_index]);
	_splitpath(file_list[file_list_index],drive,dir,file,ext);
	if (stricmp(ext, ".mid") == 0) {
	    midi_file = 1;
	    ret = PlayMidiFile(file_list[file_list_index++]);
	} else if (stricmp(ext, ".wav") == 0) {
	    wav_file = 1;
	    ret = PlayWaveFile(file_list[file_list_index++]);
	} else {
	    mod_file = 1;
	    ret = PlayModFile(file_list[file_list_index++]);
	}
	if (ret) {
	    printf("%s\n", iwapi_error_str(ret));
	    return(1);
	}
    }
    return(0);
}

void check_keyboard(void)
{
    int c;

    if (midi_file) {
	not_done_playing = PollMidi();
    } else if (wav_file) {
	not_done_playing = PollWave();
    } else if (mod_file) {
	not_done_playing = PollMod();
    }
    if (kbhit()) {
	c = getch();
	if (c == 0) c = 256 + getch();
	if (c == 27) {
	    user_is_tired = 1;
	    return;
	}
	if (c == 'n' || c == 'N') {
	    if (wav_file) {
		wav_file = 0;
		StopWaveFile();
		not_done_playing = 0;
	    } else if (midi_file) {
		midi_file = 0;
		StopMidiFile();
		not_done_playing = 0;
	    } else if (mod_file) {
		mod_file = 0;
		StopModFile();
		not_done_playing = 0;
	    }
	    return;
	} else if (c == '?' || c == '/') {
	    iw_mls_getstring("play.mls", HELP, err_str, ERR_STR_BUFLEN);
	    printf("%s\n", err_str);
	}
    }
    return;
}

#if defined(__BORLANDC__)
void cbreak(void)
#elif defined(_MSC_VER) || defined(__WATCOMC__)
void cbreak(int not_used)
#endif
{
#if defined(_MSC_VER)
    not_used = not_used;
#endif
    not_done_playing = 0;
    user_is_tired = 1;
    signal(SIGINT, cbreak);
    signal(SIGTERM, cbreak);
}

extern struct load_kernel_cfg public_cfg;

int main(int argc, char *argv[])
{
    int ac=argc, rval;
    char buf[128];
    char *iw_env, *cp;
    int i;


    iwu_get_kernel_cfg(&public_cfg, 0);
    iw_mls_init(public_cfg.mls_path);
    iw_mls_getstring("play.mls", COPYRIGHT, err_str, ERR_STR_BUFLEN);
    printf("%s\n", err_str);

    for (ac=1; ac < argc; ac++) {
	if (argv[ac][0] == '-' || argv[ac][0] == '/') {
	    strupr(argv[ac]);
	    if (strcmp(&argv[ac][1], "?") == 0  ||
		   strcmp(&argv[ac][1], "H") == 0) {
		do_help();
	    } else if (strcmp(&argv[ac][1], "SYNTH") == 0) {
		wav_use_codec = 0;
	    } else if (strcmp(&argv[ac][1], "CODEC") == 0) {
		wav_use_codec = 1;
	    }
	    continue;
	}
	multiple_load(argv[ac]);
    }
    
    atexit(DeInitIW);
    if ((rval=InitIW()) != IWAPI_OK) {
	if (rval <= IWAPI_ERROR) {
	    printf("%s\n", iwapi_error_str(rval));
	}
	exit(1);
    }

    signal(SIGINT, cbreak);
    signal(SIGTERM, cbreak);

    user_is_tired = 0;
    file_list_index = 0;
    while (!user_is_tired) {
	not_done_playing = 1;
	if (start_next_file()) continue;
	while (!user_is_tired && not_done_playing) check_keyboard();
    }
    DeInitIW();
    for (i=0; i < file_list_index; i++) {
	free(file_list[i]);
    }
    return(0);
}
