#ifndef _GLOBALS_H
#define _GLOBALS_H

#ifdef GLOBALS
#define IWEXT
#define IWINIT(a,b) a = b;
#else
#define IWEXT extern
#define IWINIT(a,b) a;
#endif

extern unsigned short iwl_freq_divisor[19];
IWEXT volatile char	iwl_irq1;
IWEXT volatile char	iwl_irq2;
IWEXT volatile char	iwl_mpu_irq;
IWEXT volatile char	iwl_adlib_irq;
IWEXT unsigned int iwl_codec_play_chan; /* codec playback DMA channel */
IWEXT unsigned int iwl_codec_rec_chan;  /* codec record DMA channel */
IWEXT unsigned int iwl_codec_irq_num;   /* current codec IRQ number */
IWEXT unsigned char	iwl_channel_in, iwl_channel_out;
IWEXT short	iwl_status;
IWEXT volatile unsigned short iwl_voices;
IWEXT unsigned char iw_board_type;
IWEXT unsigned char iw_dma_latch[8];
IWINIT(IWEXT short iwl_digital_mute_atten,0);
IWINIT(IWEXT short iwl_digital_master_volume,0);
IWINIT(IWEXT volatile unsigned short iwl_flags,0);
IWINIT(IWEXT volatile short iwl_irq1_semaphore,0);
IWINIT(IWEXT volatile short iwl_irq2_semaphore,0);
IWINIT(IWEXT unsigned short iwl_base_port,0);   /* P2XR */
IWINIT(IWEXT unsigned short iwl_synth_base,0);  /* P3XR */
IWINIT(IWEXT unsigned short iwl_codec_base,0);  /* PCODAR */
IWINIT(IWEXT unsigned short iwl_adlib_base,0);  /* P388AR */
IWINIT(IWEXT unsigned short iwl_mpu_base, 0);   /* P401AR */
IWINIT(IWEXT unsigned short iwl_pnp_read,0);    /* PNPRDP */
IWINIT(IWEXT unsigned short iwl_pnp_csn,0);     /* card select number */
IWINIT(IWEXT unsigned short iwl_pnp_index, 0x279);
IWINIT(IWEXT unsigned short iwl_pnp_write, 0xA79);
IWINIT(IWEXT int record_voice, -1);
IWINIT(IWEXT char *iw_pstatus, 0L);
IWINIT(IWEXT unsigned short iwl_cur_page, (unsigned short)-1);
IWINIT(IWEXT char use_global_effects_offset, 0);
IWINIT(IWEXT short global_effects_offset, 0);
IWEXT unsigned short iwl_mix_control;     //0x220
IWEXT unsigned short iwl_status_register; //0x226
IWEXT unsigned short iwl_timer_control;   //0x228);
IWEXT unsigned short iwl_timer_data;      //0x229);
IWEXT unsigned short iwl_irqdma_control;  //0x22b);
IWEXT unsigned short iwl_reg_control;     //0x22f);
IWEXT unsigned short iwl_uart_control;    //0x320);
IWEXT unsigned short iwl_uart_data;       //0x321);
IWEXT unsigned short iwl_page_register;   //0x322);
IWEXT unsigned short iwl_register_select; //0x323);
IWEXT unsigned short iwl_data_low;        //0x324);
IWEXT unsigned short iwl_data_high;       //0x325);
IWEXT unsigned short iwl_dram_io;         //0x327);
IWEXT unsigned short iwl_mpu_data;
IWEXT unsigned short iwl_mpu_status;
IWEXT unsigned short iwl_mpu_command;
IWEXT unsigned short iwl_emulation;	 // EMUL_ADLIB | EMUL_MPU | EMUL_SB
IWEXT unsigned short iwl_oldlmcfi;
IWEXT unsigned short iwl_lmcfi;
IWEXT unsigned char  iwl_umcr;
IWEXT unsigned char  iwl_urcr;
IWEXT unsigned char  iwl_icmpti;
IWEXT unsigned char  iwl_iveri;
IWEXT unsigned char  iwl_ieirqi;
IWEXT unsigned char  iwl_oldideci;
IWEXT unsigned char  iwl_ideci;
IWEXT unsigned char  iwl_ursti;
IWEXT unsigned char  iwl_uasbci;
IWEXT unsigned char  iwl_uasbci;
IWEXT unsigned char  iwl_uici;
IWEXT unsigned char  iwl_udci;
IWEXT unsigned char  iwl_sgmi;
IWEXT unsigned short iwl_codec_data;
IWEXT unsigned short iwl_codec_status;
IWEXT unsigned short iwl_codec_pio;
IWEXT unsigned short iwl_revision;
IWEXT unsigned short iwl_gpusage;
#endif
