/***************************************************************************
*	NAME:  IRQ16.C $Revision: 1.3 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: irq16.c $
* Revision 1.3  1995/11/17 08:14:34  sdsmith
* Fixed clear of interrupt status bits.
* Revision 1.2  1995/09/28 15:52:28  wconway
* Changed reference to "iwlmacros.h" to "iwlmacro.h"
* Revision 1.1  1995/02/23 11:07:00  unknown
* Initial revision
***************************************************************************/
/***************************************************************************

OVERVIEW:
irq16.c - provides interrupt handling services for the codec
*/

#include <stdio.h>
#include <dos.h>

#include "iw.h"
#include "iwl.h"
#include "globals.h"
#include "digital.h"
#include "codec.h"
#include "iwlmacro.h"

/***************************************************************************

FUNCTION DEFINITION:
iwl_process_codec_interrupt - main codec interrupt handler

DESCRIPTION:
iwl_process_codec_interrupt checks the codec status registers to see what
caused the interrupt.  Based on the cause control is transferred to
the appropraite sub-handler.  The causes of codec interrupt are:
playback count, record count and timer.

RETURNS: void
*/
#ifdef __BORLANDC__
#pragma warn -pro
#endif
void iwl_process_codec_interrupt(void)
{
  unsigned char status;

  OS_PUSH_DISABLE() ;
  OS_OUTPORTB(iwl_codec_base,STATUS_3);
  status = OS_INPORTB(iwl_codec_data);
  status &= CODEC_PFDI|CODEC_RFDI|CODEC_TIR;

  if (status) {
    if (status & CODEC_PFDI) {
      if (iwl_codec_playback_func) iwl_codec_playback_func();
      OS_OUTPORTB(iwl_codec_data, ~CODEC_PFDI);
    }

    if (status & CODEC_RFDI) {
      if (iwl_codec_capture_func) iwl_codec_capture_func();
      OS_OUTPORTB(iwl_codec_data, ~CODEC_RFDI);
    }

    if (status & CODEC_TIR) {
      if (iwl_codec_timer_func) iwl_codec_timer_func();
      OS_OUTPORTB(iwl_codec_data, ~CODEC_TIR);
    }
    //OS_OUTPORTB(iwl_codec_status, 0x00);
  }
  OS_POP_FLAGS() ;
}
#ifdef __BORLANDC__
#pragma warn .pro
#endif

/***************************************************************************

FUNCTION DEFINITION:
iwl_codec_enable_irqs - enables the codec's ability to generate irq's

RETURNS: void

NOTE: currently only the Global IRQ enable bit is used to control
      interrupt generation.  In the next kernel revision these should
      be modified to used the separate IRQ enable bits for playback
      and record in CFIG3I.
*/
void iwl_codec_enable_irqs()
{
  OS_PUSH_DISABLE();

  /* clear any pending irq's */
  OS_OUTPORTB(iwl_codec_status,0);
  OS_INPORTB(iwl_codec_status);

  iwl_cexti = CODEC_IRQ_ENABLE;
  IWL_CODEC_OUT(EXTERNAL_CONTROL, iwl_cexti);
  OS_POP_FLAGS();
}

/***************************************************************************

FUNCTION DEFINITION:
iwl_codec_disable_irqs - disables the codec's ability to generate irq's

RETURNS: void

NOTE: currently only the Global IRQ enable bit is used to control
      interrupt generation.  In the next kernel revision these should
      be modified to used the separate IRQ enable bits for playback
      and record in CFIG3I.
*/
void iwl_codec_disable_irqs()
{
  OS_PUSH_DISABLE();

  iwl_cexti &= ~CODEC_IRQ_ENABLE;
  IWL_CODEC_OUT(EXTERNAL_CONTROL, iwl_cexti);

  /* clear any pending irq's */
  OS_OUTPORTB(iwl_codec_status,0);
  OS_INPORTB(iwl_codec_status);

  OS_POP_FLAGS();
}
