/***************************************************************************
*	NAME:  IWERROR.C $Revision: 1.6 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Lab"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwerror.c $
* Revision 1.6  1995/05/30 16:19:27  mleibow
* Fixed default message.
* Revision 1.5  1995/05/25 15:13:18  mleibow
* Added multiple language support.
* Revision 1.4  1995/04/27 18:56:11  mleibow
* Update error table for BETA release
* Revision 1.3  1995/04/26 16:23:24  sdsmith
* Removed references to setgus
* Revision 1.2  1995/04/14 09:19:56  sdsmith
* Added support for B0 silicon
* Revision 1.1  1995/02/23 11:07:05  unknown
* Initial revision
***************************************************************************/

#include "iw.h"
#include "iwl.h"

/***************************************************************************

FUNCTION DEFINTION:
iw_error - convert IW error code to a text string

RETURNS: char * - pointer to text representation of error
*/
/* all kernel errors are less than 128 chars */
#define ERROR_STR_BUFLEN 128
static char error_string[ERROR_STR_BUFLEN];
char *iw_error_str(int code)
{
    int rval;

#ifdef IW_MODULE_MLS
    rval = iw_mls_getstring("kernel.mls", -code, error_string, ERROR_STR_BUFLEN);
    if (rval == IW_OK) return(error_string);
    if (rval == IW_MESSAGE_NOT_FOUND) return("Unknown error.");
    return(error_string);
#else
    return("Multiple Language Support not linked.  Can't print error.");
#endif
}
