;***************************************************************************
;	NAME: IWISR1.ASM
;	COPYRIGHT:
;	"Copyright (c) 1994,1995 by e-Tek Labs"
;
;       "This software is furnished under a license and may be used,
;        copied, or disclosed only in accordance with the terms of such
;        license and with the inclusion of the above copyright notice.
;        This software or any other copies thereof may not be provided or
;        otherwise made available to any other person. No title to and
;        ownership of the software is hereby transfered."
;****************************************************************************
; $Log: iwisr1.asm $
; Revision 1.4  1995/08/14 15:43:22  sdsmith
; Modified to store esp in user_sp
; Revision 1.3  1995/08/02 13:36:13  mleibow
; bumped stack to 8k for non-debug
; Revision 1.2  1995/05/29 17:33:48  sdsmith
; Increased stack size esp. for debug
; Revision 1.1  1995/02/23 11:07:08  unknown
; Initial revision
;***************************************************************************/
include model.inc
segdefs IWISR1

IFDEF MASM
	OPTION SCOPED
ELSE
	LOCALS @@
ENDIF

MODULE_IWISR equ 1
IFDEF _WINDOWS
MODULE_OS equ 1
ENDIF
include iwasm.inc
include iwl.inc
include globals.inc

IF (NEARDATA EQ 0)
.CONST
_SEG_iwl_flags dw SEG _iwl_flags
_SEG_iwl_irq1_semaphore dw SEG _iwl_irq1_semaphore
_SEG_iwl_irq2_semaphore dw SEG _iwl_irq2_semaphore
_SEG_iwl_irq1 dw SEG _iwl_irq1
_SEG_iwl_irq2 dw SEG _iwl_irq2
ENDIF

	.DATA
IFDEF _WINDOWS
IFDEF DEBUG
USER_STACK_SIZE equ 32768
ELSE
USER_STACK_SIZE equ 8192
ENDIF
ELSE
USER_STACK_SIZE equ 512
ENDIF
	db USER_STACK_SIZE dup (?)
	user_stack label byte
	user_stack_off	dw	OFFSET DGROUP:user_stack
	public user_stack_off
IFNDEF __t__
	user_stack_seg	dw	DGROUP
	public user_stack_seg
ENDIF
	user_ss	dw	?
	user_sp	dd	?

	.CODE
CPROC iwl_irq1_service
IFDEF PROC386
	.386
	pushad
ELSE
	pusha
ENDIF
	push	ds
	push	es
IFDEF __t__
	mov	ax, cs
ELSE
	mov	ax, DGROUP
ENDIF
	mov	ds, ax

	xor	ah, ah
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_irq1
	mov	al, es:[_iwl_irq1]
ELSE
	mov	al, _iwl_irq1
ENDIF
	push	ax
	call	_os_eoi
	pop	ax
;	cmp	word ptr _visr, 0
;	jz	short @@novdd
;	call	dword ptr _visr
;	jmp	@@ret
@@novdd:
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_irq1_semaphore
	cmp	word ptr es:[_iwl_irq1_semaphore], 0
ELSE
	cmp	word ptr [_iwl_irq1_semaphore], 0
ENDIF
	jz	short @@process_int
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_flags
	or	es:[_iwl_flags], F_REDO_INT
ELSE
	or	_iwl_flags, F_REDO_INT
ENDIF
	jmp	@@ret
@@process_int:
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_irq1_semaphore
	inc	word ptr es:[_iwl_irq1_semaphore]
ELSE
	inc	word ptr [_iwl_irq1_semaphore]
ENDIF
IFNDEF OS2
	mov	user_ss, ss
	mov	user_sp, esp
IFDEF __t__
	mov	ax, cs
ELSE
	mov	ax, user_stack_seg
ENDIF
	mov	ss, ax
	mov	sp, user_stack_off
ENDIF
@@loop:
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_flags
	and	es:[_iwl_flags], (NOT F_REDO_INT)
ELSE
	and	_iwl_flags, (NOT F_REDO_INT)
ENDIF
	push	ds
	call	_iwl_process_irq1_interrupt
	pop	ds
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_flags
	test	es:[_iwl_flags], F_REDO_INT
ELSE
	test	_iwl_flags, F_REDO_INT
ENDIF
	jnz	@@loop
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_irq1_semaphore
	dec	word ptr es:[_iwl_irq1_semaphore]
ELSE
	dec	word ptr [_iwl_irq1_semaphore]
ENDIF
IFNDEF OS2
	mov	ss, user_ss
	mov	esp, user_sp
ENDIF
@@ret:
	pop	es
	pop	ds
IFDEF PROC386
	popad
ELSE
	popa
ENDIF
IFDEF OS2
	clc
	retf
ELSE
	iret
ENDIF
_iwl_irq1_service endp

CPROC iwl_irq2_service
IFDEF PROC386
	pushad
ELSE
	pusha
ENDIF
	push	ds
	push	es
IFDEF __t__
	mov	ax, cs
ELSE
	mov	ax, DGROUP
ENDIF
	mov	ds, ax

	xor	ah, ah
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_irq2
	mov	al, es:[_iwl_irq2]
ELSE
	mov	al, _iwl_irq2
ENDIF
	push	ax
	call	_os_eoi
	pop	ax
	cmp	word ptr [_iwl_irq2_semaphore], 0
	jz	short @@process_int
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_flags
	or	es:[_iwl_flags], F_REDO_MIDI_INT
ELSE
	or	_iwl_flags, F_REDO_MIDI_INT
ENDIF
	jmp	@@ret
@@process_int:
	inc	word ptr [_iwl_irq2_semaphore]
@@loop:
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_flags
	and	es:[_iwl_flags], (NOT F_REDO_MIDI_INT)
ELSE
	and	_iwl_flags, (NOT F_REDO_MIDI_INT)
ENDIF
	push	ds
	call	_iwl_process_irq2_interrupt
	pop	ds
IF (NEARDATA EQ 0)
	mov	es, _SEG_iwl_flags
	test	es:[_iwl_flags], F_REDO_MIDI_INT
ELSE
	test	_iwl_flags, F_REDO_MIDI_INT
ENDIF
	jnz	@@loop
	dec	word ptr [_iwl_irq2_semaphore]
@@ret:
	pop	es
	pop	ds
IFDEF PROC386
	popad
ELSE
	popa
ENDIF
IFDEF OS2
	clc
	retf
ELSE
	iret
ENDIF
_iwl_irq2_service endp

	end
