/***************************************************************************
*       NAME:  IWLLIST.C $Revision: 1.3 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwllist.c $
* Revision 1.3  1995/05/25 15:14:05  mleibow
* Added far ptr list handling
* Revision 1.2  1995/05/15 22:46:21  sdsmith
* Added far versions of the calls and data
* Revision 1.1  1995/02/23 11:07:11  unknown
* Initial revision
***************************************************************************/
#include "iw.h"
#include "iwllist.h"

void iwl_InitList(struct iwl_list RFAR *list)
{
    list->head = 0L;
    list->tail = 0L;
}

void iwl_AddNode(struct iwl_list RFAR *list, struct iwl_node RFAR *node, struct iwl_node RFAR *where, int pa)
{
    if (where != 0L) {
	if (pa == IWL_PREPEND) {
	    node->next = where;
	    node->prev = where->prev;
	    if (node->prev) {
		node->prev->next = node;
	    } else {
		list->head = node;
	    }
	    where->prev = node;
	} else {
	    node->next = where->next;
	    where->next = node;
	    if (node->next) {
		node->next->prev = node;
	    } else {
		list->tail = node;
	    }
	    where->next = node;
	}
    } else {
	if (pa == IWL_PREPEND) {
	    node->next = list->head;
	    if (list->head) {
		list->head->prev = node;
	    } else {
		list->tail = node;
	    }
	    node->prev = 0L;
	    list->head = node;
	} else {
	    node->prev = list->tail;
	    if (list->tail) {
		list->tail->next = node;
	    } else {
		list->head = node;
	    }
	    node->next = 0L;
	    list->tail = node;
	}
    }
}

void iwl_DeleteNode(struct iwl_list RFAR *list, struct iwl_node RFAR *node)
{
    if (node->prev) {
	node->prev->next = node->next;
    } else {
	list->head = node->next;
	if (list->head) list->head->prev = 0;
    }
    if (node->next) {
	node->next->prev = node->prev;
    } else {
	list->tail = node->prev;
	if (list->tail) list->tail->next = 0;
    }
    node->next = 0;
    node->prev = 0;
}
