#ifndef __IWLMACRO_H
#define __IWLMACRO_H

#define IWL_SET_PAGE(page) \
    { OS_OUTPORTB(iwl_page_register, page); }
//    { if (iwl_cur_page != page) { iwl_cur_page = page; OS_OUTPORTB(iwl_page_register, page); } }

#define IWL_OUT_B(reg, val) \
    { OS_OUTPORTB(iwl_register_select, reg); OS_OUTPORTB(iwl_data_high, val); }

#define IWL_OUT_W(reg, val) \
    { OS_OUTPORTB(iwl_register_select, reg); OS_OUTPORTW(iwl_data_low, val); }

#define IWL_INP_B(reg, val) \
    { OS_OUTPORTB(iwl_register_select, reg); val = OS_INPORTB(iwl_data_high); }

#define IWL_INP_W(reg, val) \
    { OS_OUTPORTB(iwl_register_select, reg); val = OS_INPORTW(iwl_data_low); }

#define IWL_OUT_CONTROL(reg, val) \
    { IWL_OUT_B(reg, val); }
//    { IWL_OUT_B(reg, val); iw_delay(); OS_OUTPORTB(iwl_data_high, val); }

#define IWL_CODEC_OUT(reg, val) \
    { OS_OUTPORTB(iwl_codec_base, reg); OS_OUTPORTB(iwl_codec_data, val); }
#define IWL_CODEC_IN(reg, val) \
    { OS_OUTPORTB(iwl_codec_base, reg); val = OS_INPORTB(iwl_codec_data); }
#endif
