/***************************************************************************
*	NAME:  IWMIXER.C $Revision: 1.1 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwmixer.c $
* Revision 1.1  1995/02/23 11:07:14  unknown
* Initial revision
***************************************************************************/

#include <dos.h>
#include "iw.h"
#include "iwl.h"
#include "globals.h"
#include "iwatten.h"

/***************************************************************************

FUNCITON DEFINITION:
iw_enable_line_in - enables the line level input on the synthesizer

RETURNS: void
*/
void iw_enable_line_in(void)
{
  iwl_umcr &= ~IWL_DISABLE_LINE;
  OS_OUTPORTB(iwl_mix_control, iwl_umcr);
}

/***************************************************************************

FUNCITON DEFINITION:
iw_disable_line_in - disables line level input on the synthesizer

RETURNS: void
*/
void iw_disable_line_in(void)
{
  iwl_umcr |= IWL_DISABLE_LINE;
  OS_OUTPORTB(iwl_mix_control, iwl_umcr);
}

/***************************************************************************

FUNCITON DEFINITION:
iw_enable_mic_in - enable microphone input on synthesizer

RETURNS: void
*/
void iw_enable_mic_in(void)
{
  iwl_umcr |= IWL_ENABLE_MIC;
  OS_OUTPORTB(iwl_mix_control, iwl_umcr);
}

/***************************************************************************

FUNCITON DEFINITION:
iw_disable_mic_in - disable microphone input on synthesizer

RETURNS: void
*/
void iw_disable_mic_in(void)
{
  iwl_umcr &= ~IWL_ENABLE_MIC;
  OS_OUTPORTB(iwl_mix_control, iwl_umcr);
}

/***************************************************************************

FUNCITON DEFINITION:
iw_enable_output - enable master output on synthesizer

RETURNS: void
*/
void iw_enable_output(void)
{
  iwl_umcr &= ~IWL_DISABLE_OUT;
  OS_OUTPORTB(iwl_mix_control, iwl_umcr);
}

/***************************************************************************

FUNCITON DEFINITION:
iw_disable_output - disable master output on synthesizer

RETURNS: void
*/
void iw_disable_output(void)
{
  iwl_umcr |= IWL_DISABLE_OUT;
  OS_OUTPORTB(iwl_mix_control, iwl_umcr);
}
