/***************************************************************************
*       NAME:  IWNOTE2.C $Revision: 1.2 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwnote2.c $
* Revision 1.2  1995/05/25 18:17:14  mleibow
* Revision 1.1  1995/04/18 22:57:39  mleibow
* Initial revision
***************************************************************************/

#include <dos.h>

#include "iw.h"
#include "iwl.h"
#include "globals.h"
#include "iwscale.h"
#include "iwatten.h"
#include "iwllist.h"
#include "iwnote.h"

int iw_midi_get_channel_volume(int channel)
{
    struct channel_status *cs = &iwl_channel_status[channel];
    struct voice_status RFAR *vs;
    int i;
    int volume=0;
    short vvolume, slfovolume;
    unsigned char lfovolume;

    ENTER;
    for (vs = VS_START; vs != 0; vs = VS_NEXT(vs)) {
	if (vs->channel != channel) continue;
	IWL_SET_PAGE(vs->voice);
	IWL_INP_W(GET_VOLUME, vvolume);
	IWL_INP_B(GET_VOLUME_LFO, lfovolume);
	if (lfovolume <= 127) {
	    slfovolume = lfovolume;
	} else {
	    slfovolume = lfovolume-256; /* too many compilers do sign extension wrong for characters */
	}
	vvolume = (short)((unsigned short)vvolume>>4) + (slfovolume<<2);
	vvolume -= cs->volume + cs->expression + iwl_m_volume[vs->synth] + iwl_midi_master_volume + vs->layer_atten + vs->wave_atten;
	if (vvolume > 4095) vvolume = 4095;
	if (vvolume < 0) vvolume = 0;
	vvolume = 4095 - vvolume;
	for (i=0; i <= IW_ATTENTABSIZE; i++) {
	    if (vvolume >= iw_atten_tab[i]) break;
	}
	if (i > volume) volume = i;
    }
    LEAVE;
    return(volume);
}
