/***************************************************************************
*       NAME:  IWSEM.C $Revision: 1.5 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwsem.c $
* Revision 1.5  1995/07/13 18:35:47  mleibow
* added os_disbable to fix semaphore leave code.
* Revision 1.4  1995/07/12 21:58:33  sdsmith
* Fixed the 1.3 fix. (I think).
* Revision 1.3  1995/07/12 17:28:55  mleibow
* redo_int flag was being ignored in iwl_leave
* Revision 1.2  1995/03/22 14:57:44  mleibow
* moved #include "codec.h" to iwl.h
* Revision 1.1  1995/02/23 11:07:18  unknown
* Initial revision
***************************************************************************/
#include "iw.h"
#include "iwl.h"
#include "globals.h"

void iwl_enter(void)
{
#ifndef IWL_SYNTH_IRQ2
    iwl_irq1_semaphore++;
#else
    iwl_irq2_semaphore++;
#endif
}

void iwl_leave(void)
{
    OS_DISABLE_INTERRUPTS();
#ifndef IWL_SYNTH_IRQ2
    iwl_irq1_semaphore--;
    while ((iwl_flags & (F_GEN_TC|F_REDO_INT)) && !iwl_irq1_semaphore) {
	iwl_irq1_semaphore++;
	iwl_flags &= ~F_REDO_INT;
	iwl_process_irq1_interrupt();
	iwl_irq1_semaphore--;
    }
#else
    iwl_irq2_semaphore--;
    while ((iwl_flags & (F_GEN_TC|F_REDO_INT)) && !iwl_irq2_semaphore) {
	iwl_irq2_semaphore++;
	iwl_flags &= ~F_REDO_INT;
	iwl_process_irq2_interrupt();
	iwl_irq2_semaphore--;
    }
#endif
}
