//#define FLASH

/***************************************************************************
*	NAME:  IWWISR.C $Revision: 1.2 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: lucidisr.c $
* Revision 1.2  1995/03/22 13:13:43  mleibow
* Revision 1.1  1995/02/23 11:07:41  unknown
* Initial revision
***************************************************************************/
#include <dos.h>
#include <conio.h>
#include "globals.h"
#include "iw.h"
#include "iwl.h"

#include "dx.h"

/***************************************************************************

FUNCTION DEFINITION:
iwl_irq1_service - interrupt service routine for syntheziser interrupt

DESCRIPTION:
iwl_irq1_service is the function whose address is placed in the interrupt
vector table for the IRQ assigned to the synthesizer.  When the synthesizer
generates an interrupt, this routine receives control first.

This routine sends the EOI signal to the PIC.

RETURNS: void

SEE ALSO:
iwl_process_interrupt

NOTE: This routine is only used with the Watcom compiler
*/
void iwl_irq1_service(void)
{
#ifdef FLASH
OS_INPORTB(0x3da);
OS_OUTPORTB(0x3c0, 0x31);
OS_OUTPORTB(0x3c0, 0x31);
#endif
	os_eoi(iwl_irq1);
	if (iwl_irq1_semaphore != 0) {
	    iwl_flags |= F_REDO_INT;
#ifdef FLASH
OS_INPORTB(0x3da);
OS_OUTPORTB(0x3c0, 0x31);
OS_OUTPORTB(0x3c0, 0x0);
#endif
	    return;
	}
	iwl_irq1_semaphore++;
	do {
	    iwl_flags &= ~F_REDO_INT;
	    iwl_process_irq1_interrupt();
	} while (iwl_flags & F_REDO_INT);
	iwl_irq1_semaphore--;
#ifdef FLASH
OS_INPORTB(0x3da);
OS_OUTPORTB(0x3c0, 0x31);
OS_OUTPORTB(0x3c0, 0x0);
#endif
	dx_dont_chain_intr();
	return;
}

/***************************************************************************

FUNCTION DEFINITION:
iwl_irq2_service - interrupt service routine for MIDI port interrupt

DESCRIPTION:
iwl_irq2_service is the function whose address is placed in the interrupt
vector table for the IRQ assigned to the MIDI port.  When the MIDI port
generates an interrupt, this routine receives control first.

This routine sends the EOI signal to the PIC. 

RETURNS: void

SEE ALSO:
process_midi_interrupt

NOTE: This routine is only used with the Watcom compiler
*/
void iwl_irq2_service(void)
{
    os_eoi(iwl_irq2);
//    if (iwl_semaphore != 0) {
//	iwl_flags |= F_REDO_INT;
//	return;
//    }
//    midi_semaphore++;
//    do {
//	iwl_flags &= ~F_REDO_INT;
	iwl_process_irq2_interrupt();
//    } while (iwl_flags & F_REDO_INT);
//    midi_semaphore--;
	dx_dont_chain_intr();
}
