# InterWave Kernel Makefile for Microsoft C/C++ v/8.0
# $Revision: 1.3 $

PROCESSOR = -DPROC386
EXTRA =
# DIR = m$(MODEL)
LIBNAME = iw_os$(MODEL).lib
!IF "$(MODEL)"=="T"
EXTRA = $(EXTRA) -D__t__
!endif
!if "$(MODEL)"=="T" || "$(MODEL)"=="S" || "$(MODEL)"=="C"
CODESIZE = -DNEARCODE=1
!else
CODESIZE = -DNEARCODE=0
!endif
!if "$(MODEL)"=="T" || "$(MODEL)"=="S" || "$(MODEL)"=="M"
DATASIZE = -DNEARDATA=1
!else
DATASIZE = -DNEARDATA=0
!endif
!if "$(MODEL)"=="T"
MODELlc = t
!endif
!if "$(MODEL)"=="S"
MODELlc = s
!endif
!if "$(MODEL)"=="M"
MODELlc = m
!endif
!if "$(MODEL)"=="C"
MODELlc = c
!endif
!if "$(MODEL)"=="L"
MODELlc = l
!endif
!if "$(MODEL)"=="H"
MODELlc = h
!endif
!if "$(PROCESSOR)"=="-DPROC386"
EXTRA = $(EXTRA) $(PROCESSOR)
CPROC = -G3
!else
CPROC = -G2
!endif
!if "$(DEBUG)"=="-Zi"
CPROC = -G2
COPT = -W3 -Od
!else
COPT = -w -Ox -Os
!endif
OSINC = os\dos\micro
# CFG = configs\borland
# CFLAGS = -nologo $(DEBUG) -Zp1 -I$(INCLUDE) $(DATASIZE) $(CODESIZE) $(CPROC) $(COPT) -A$(MODEL) -Aw $(PROCESSOR) -Gs
CFLAGS = -nologo $(DEBUG) -Zp1 $(DATASIZE) $(CODESIZE) $(CPROC) $(COPT) -A$(MODEL) -Aw $(PROCESSOR) -Gs
ASMFLAGS = -c -nologo -DMASM $(PROCESSOR) $(DEBUG) -D__$(MODELlc)__ $(CODESIZE) $(DATASIZE) -VM -Sa -Fl -Fo$*.obj

.c.obj:
	cl -c -nologo $(CFLAGS) -Fo$(TARGETDIR)\$*.obj $*.c

OBJS= 	$(TARGETDIR)\iwinit2.obj \
	$(TARGETDIR)\iwisr1.obj \
	$(TARGETDIR)\iwisr.obj \
	$(TARGETDIR)\iwsem.obj \
	$(TARGETDIR)\iwinit.obj \
	$(TARGETDIR)\iwpnp.obj \
	$(TARGETDIR)\iwsynth.obj \
	$(TARGETDIR)\iwload.obj \
	$(TARGETDIR)\iwdetct.obj \
	$(TARGETDIR)\globals.obj \
	$(TARGETDIR)\iwmem.obj \
	$(TARGETDIR)\iwdram.obj \
	$(TARGETDIR)\iwutils.obj \
	$(TARGETDIR)\iwvoice.obj \
	$(TARGETDIR)\iwdma.obj \
	$(TARGETDIR)\iwaddr.obj \
	$(TARGETDIR)\iwatten.obj \
	$(TARGETDIR)\iwllist.obj \
	$(TARGETDIR)\iwnote.obj \
	$(TARGETDIR)\iwnote1.obj \
	$(TARGETDIR)\iwlfo.obj \
	$(TARGETDIR)\iwscale.obj \
	$(TARGETDIR)\timer.obj \
	$(TARGETDIR)\iwerror.obj \
	$(TARGETDIR)\iwmidi.obj \
	$(TARGETDIR)\iwuart.obj \
	$(TARGETDIR)\iwmixer.obj \
	$(TARGETDIR)\iwsound.obj \
	$(TARGETDIR)\iwdig.obj \
	$(TARGETDIR)\play.obj \
	$(TARGETDIR)\record.obj \
	$(TARGETDIR)\codec.obj \
	$(TARGETDIR)\play16.obj \
	$(TARGETDIR)\irq16.obj \
	$(TARGETDIR)\vars16.obj \
	$(TARGETDIR)\util16.obj \
	$(TARGETDIR)\mixer.obj \
	$(TARGETDIR)\profile.obj \
	$(TARGETDIR)\profile1.obj \
	$(TARGETDIR)\mixctl.obj \
	$(TARGETDIR)\mixbld.obj \
	$(TARGETDIR)\iwmls.obj \
	$(TARGETDIR)\os.obj

LANGUAGES = english\kernel.mls

all: $(TARGETDIR)\iw_os$(MODELlc).lib $(LANGUAGES)

english\kernel.mls: english\kernel.txt
	$(TOOLS)\mlscomp\mlscomp english\kernel.txt

$(TARGETDIR)\iwainit.obj: iwainit.asm iwasm.inc globals.inc iwl.inc
	ml -c $(ASMFLAGS) iwainit.asm
$(TARGETDIR)\iwwmem.obj: iwwmem.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwmem.asm
$(TARGETDIR)\iwwvoic.obj: iwwvoic.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwvoic.asm
$(TARGETDIR)\iwwdma.obj: iwwdma.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwdma.asm
$(TARGETDIR)\wdigital.obj: wdigital.asm iwinit.inc
	ml -c $(ASMFLAGS) wdigital.asm
$(TARGETDIR)\wrecord.obj: wrecord.asm iwinit.inc
	ml -c $(ASMFLAGS) wrecord.asm
$(TARGETDIR)\iwwnote.obj: iwwnote.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwnote.asm
$(TARGETDIR)\wtimer.obj: wtimer.asm iwinit.inc
	ml -c $(ASMFLAGS) wtimer.asm
$(TARGETDIR)\iwwuart.obj: iwwuart.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwuart.asm
$(TARGETDIR)\iwwsnd.obj: iwwsnd.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwsnd.asm
$(TARGETDIR)\iwinit2.obj: iwinit2.asm iwinit.inc
	mlx -c $(ASMFLAGS) iwinit2.asm
$(TARGETDIR)\iwisr1.obj: iwisr1.asm iwasm.inc globals.inc iwl.inc
	mlx -c $(ASMFLAGS) iwisr1.asm
$(TARGETDIR)\iwisr.obj: iwisr.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwisr.obj iwisr.c
$(TARGETDIR)\iwinit.obj: iwinit.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwinit.obj iwinit.c
$(TARGETDIR)\iwsem.obj: iwsem.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwsem.obj iwsem.c
$(TARGETDIR)\iwdetct.obj: iwdetct.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwdetct.obj iwdetct.c
$(TARGETDIR)\globals.obj: globals.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\globals.obj globals.c
$(TARGETDIR)\iwmem.obj: iwmem.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwmem.obj iwmem.c
$(TARGETDIR)\iwmem1.obj: iwmem1.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwmem1.obj iwmem1.c
$(TARGETDIR)\iwdram.obj: iwdram.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwdram.obj iwdram.c
$(TARGETDIR)\iwutils.obj: iwutils.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwutils.obj iwutils.c
$(TARGETDIR)\iwvoice.obj: iwvoice.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwvoice.obj iwvoice.c
$(TARGETDIR)\iwdma.obj: iwdma.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwdma.obj iwdma.c
$(TARGETDIR)\iwdma1.obj: iwdma1.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwdma1.obj iwdma1.c
$(TARGETDIR)\iwaddr.obj: iwaddr.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwaddr.obj iwaddr.c
$(TARGETDIR)\divisor.obj: divisor.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\divisor.obj divisor.c
$(TARGETDIR)\digital.obj: digital.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\digital.obj digital.c
$(TARGETDIR)\digpause.obj: digpause.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\digpause.obj digpause.c
$(TARGETDIR)\digpos.obj: digpos.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\digpos.obj digpos.c
$(TARGETDIR)\iwatten.obj: iwatten.c iw.h iwl.h globals.h iwatten.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwatten.obj iwatten.c
$(TARGETDIR)\iwllist.obj: iwllist.c iw.h iwl.h globals.h iwllist.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwllist.obj iwllist.c
$(TARGETDIR)\iwnote.obj: iwnote.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwnote.obj iwnote.c
$(TARGETDIR)\iwnote1.obj: iwnote1.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwnote1.obj iwnote1.c
$(TARGETDIR)\iwscale.obj: iwscale.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwscale.obj iwscale.c
$(TARGETDIR)\timer.obj: timer.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\timer.obj timer.c
$(TARGETDIR)\iwerror.obj: iwerror.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwerror.obj iwerror.c
$(TARGETDIR)\iwmidi.obj: iwmidi.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwmidi.obj iwmidi.c
$(TARGETDIR)\iwuart.obj: iwuart.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwuart.obj iwuart.c
$(TARGETDIR)\iwrec.obj: iwrec.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwrec.obj iwrec.c
$(TARGETDIR)\iwmixer.obj: iwmixer.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwmixer.obj iwmixer.c
$(TARGETDIR)\cdcclose.obj: cdcclose.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\cdcclose.obj cdcclose.c
$(TARGETDIR)\voltab.obj: voltab.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\voltab.obj voltab.c
$(TARGETDIR)\iwsound.obj: iwsound.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwsound.obj iwsound.c
$(TARGETDIR)\iwlfo.obj: iwlfo.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwlfo.obj iwlfo.c
$(TARGETDIR)\iwpnp.obj: iwpnp.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwpnp.obj iwpnp.c
$(TARGETDIR)\iwdig.obj: iwdig.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwdig.obj iwdig.c
$(TARGETDIR)\iwload.obj: iwload.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwload.obj iwload.c
$(TARGETDIR)\iwsynth.obj: iwsynth.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwsynth.obj iwsynth.c
$(TARGETDIR)\play.obj: play.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\play.obj play.c
$(TARGETDIR)\record.obj: record.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\record.obj record.c
$(TARGETDIR)\play16.obj: play16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\play16.obj play16.c
$(TARGETDIR)\vars16.obj: vars16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\vars16.obj vars16.c
$(TARGETDIR)\util16.obj: util16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\util16.obj util16.c
$(TARGETDIR)\codec.obj: codec.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\codec.obj codec.c
$(TARGETDIR)\irq16.obj: irq16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\irq16.obj irq16.c
$(TARGETDIR)\mixer.obj: mixer.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\mixer.obj mixer.c
$(TARGETDIR)\mixctl.obj: mixctl.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\mixctl.obj mixctl.c
$(TARGETDIR)\mixbld.obj: mixbld.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\mixbld.obj mixbld.c
$(TARGETDIR)\profile.obj: profile.c iw.h profile.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\profile.obj profile.c
$(TARGETDIR)\profile1.obj: profile1.c iw.h profile.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\profile1.obj profile1.c
$(TARGETDIR)\iwmls.obj: iwmls.c iw.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwmls.obj iwmls.c
$(TARGETDIR)\os.obj: $(OSINC)\os.c
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\os.obj $(OSINC)\os.c

$(TARGETDIR)\$(LIBNAME): $(OBJS) makeos
        if exist $(TARGETDIR)\$(LIBNAME) del $(TARGETDIR)\$(LIBNAME)
	lib $(TARGETDIR)\$(LIBNAME) @<<makems.lnk
+$(OBJS:  = &^
+)
;
<<KEEP

clean:
	if exist $(TARGETDIR)\*.obj del $(TARGETDIR)\*.obj
	if exist $(TARGETDIR)\*.lib del $(TARGETDIR)\*.lib
	if exist $(TARGETDIR)\*.bak del $(TARGETDIR)\*.bak
