# InterWave Kernel Makefile for Microsoft C/C++ v6.0
# $Revision: 1.3 $

PROCESSOR = -DPROC386
# DIR = m6$(MODEL)
LIBNAME = iw_os$(MODEL).lib
!if "$(MODEL)"=="T" || "$(MODEL)"=="S" || "$(MODEL)"=="C"
CODESIZE = -DNEARCODE=1
!else
CODESIZE = -DNEARCODE=0
!endif
!if "$(MODEL)"=="T" || "$(MODEL)"=="S" || "$(MODEL)"=="M"
DATASIZE = -DNEARDATA=1
!else
DATASIZE = -DNEARDATA=0
!endif
!if "$(MODEL)"=="T"
MODELlc = t
!endif
!if "$(MODEL)"=="S"
MODELlc = s
!endif
!if "$(MODEL)"=="M"
MODELlc = m
!endif
!if "$(MODEL)"=="C"
MODELlc = c
!endif
!if "$(MODEL)"=="L"
MODELlc = l
!endif
!if "$(MODEL)"=="H"
MODELlc = h
!endif
!if "$(PROCESSOR)"=="-DPROC386"
CPROC = -G2
!else
CPROC = -G2
!endif
OSINCDIR = os\dos\micro
CFLAGS = $(DEBUG) -Zp1 -I$(CONFIGINCDIR) -I. -I$(OSINCDIR) $(DATASIZE) $(CODESIZE) $(CPROC) -Ox -A$(MODEL) -Gs -W3 -nologo
#EXTRA = -Fa$*.asm
ASMFLAGS = -c -DMASM $(PROCESSOR) $(DEBUG) -D__$(MODELlc)__ $(CODESIZE) $(DATASIZE) /Sa /Fl /Fo$*.obj -nologo

OBJS= 	$(TARGETDIR)\iwinit2.obj \
	$(TARGETDIR)\iwisr1.obj \
	$(TARGETDIR)\iwisr.obj \
	$(TARGETDIR)\iwsem.obj \
	$(TARGETDIR)\iwinit.obj \
	$(TARGETDIR)\iwpnp.obj \
	$(TARGETDIR)\iwsynth.obj \
	$(TARGETDIR)\iwload.obj \
	$(TARGETDIR)\iwdetct.obj \
	$(TARGETDIR)\globals.obj \
	$(TARGETDIR)\iwmem.obj \
	$(TARGETDIR)\iwdram.obj \
	$(TARGETDIR)\iwutils.obj \
	$(TARGETDIR)\iwvoice.obj \
	$(TARGETDIR)\iwdma.obj \
	$(TARGETDIR)\iwaddr.obj \
	$(TARGETDIR)\iwatten.obj \
	$(TARGETDIR)\iwllist.obj \
	$(TARGETDIR)\iwnote.obj \
	$(TARGETDIR)\iwnote1.obj \
	$(TARGETDIR)\iwlfo.obj \
	$(TARGETDIR)\iwscale.obj \
	$(TARGETDIR)\timer.obj \
	$(TARGETDIR)\iwerror.obj \
	$(TARGETDIR)\iwmidi.obj \
	$(TARGETDIR)\iwuart.obj \
	$(TARGETDIR)\iwmixer.obj \
	$(TARGETDIR)\iwsound.obj \
	$(TARGETDIR)\iwdig.obj \
	$(TARGETDIR)\play.obj \
	$(TARGETDIR)\record.obj \
	$(TARGETDIR)\codec.obj \
	$(TARGETDIR)\play16.obj \
	$(TARGETDIR)\irq16.obj \
	$(TARGETDIR)\vars16.obj \
	$(TARGETDIR)\util16.obj \
	$(TARGETDIR)\mixer.obj \
	$(TARGETDIR)\profile.obj \
	$(TARGETDIR)\profile1.obj \
	$(TARGETDIR)\mixctl.obj \
	$(TARGETDIR)\mixbld.obj \
	$(TARGETDIR)\iwmls.obj \
	$(TARGETDIR)\os.obj

LANGUAGES = english\kernel.mls

all: BEGIN $(TARGETDIR)\iw_os$(MODELlc).lib $(LANGUAGES)

english\kernel.mls: english\kernel.txt
	$(TOOLS)\mlscomp\mlscomp english\kernel.txt


BEGIN:
	set CL=$(CFLAGS)
	set INCLUDE=c:\mc6\include

$(TARGETDIR)\iwainit.obj: iwainit.asm iwasm.inc globals.inc iwpriv.inc
	ml -c $(ASMFLAGS) iwainit.asm
$(TARGETDIR)\iwwmem.obj: iwwmem.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwmem.asm
$(TARGETDIR)\iwwvoic.obj: iwwvoic.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwvoic.asm
$(TARGETDIR)\iwwdma.obj: iwwdma.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwdma.asm
$(TARGETDIR)\wrecord.obj: wrecord.asm iwinit.inc
	ml -c $(ASMFLAGS) wrecord.asm
$(TARGETDIR)\wdigital.obj: wdigital.asm iwinit.inc
	ml -c $(ASMFLAGS) wdigital.asm
$(TARGETDIR)\iwwnote.obj: iwwnote.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwnote.asm
$(TARGETDIR)\wtimer.obj: wtimer.asm iwinit.inc
	ml -c $(ASMFLAGS) wtimer.asm
$(TARGETDIR)\iwwuart.obj: iwwuart.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwuart.asm
$(TARGETDIR)\iwinit2.obj: iwinit2.asm iwinit.inc
	ml -c $(ASMFLAGS) iwinit2.asm
$(TARGETDIR)\iwsem.obj: iwsem.asm iwasm.inc globals.inc iwpriv.inc
	ml -c $(ASMFLAGS) iwsem.asm
$(TARGETDIR)\iwisr1.obj: iwisr1.asm iwasm.inc globals.inc iwpriv.inc
	ml -c $(ASMFLAGS) iwisr1.asm
$(TARGETDIR)\iwisr.obj: iwisr.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwisr.obj iwisr.c
$(TARGETDIR)\iwinit.obj: iwinit.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwinit.obj iwinit.c
$(TARGETDIR)\iwdetct.obj: iwdetct.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwdetct.obj iwdetct.c
$(TARGETDIR)\globals.obj: globals.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\globals.obj globals.c
$(TARGETDIR)\iwmem.obj: iwmem.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwmem.obj iwmem.c
$(TARGETDIR)\iwmem1.obj: iwmem1.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwmem1.obj iwmem1.c
$(TARGETDIR)\iwdram.obj: iwdram.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwdram.obj iwdram.c
$(TARGETDIR)\iwutils.obj: iwutils.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwutils.obj iwutils.c
$(TARGETDIR)\iwvoice.obj: iwvoice.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwvoice.obj iwvoice.c
$(TARGETDIR)\iwdma.obj: iwdma.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwdma.obj iwdma.c
$(TARGETDIR)\iwdma1.obj: iwdma1.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwdma1.obj iwdma1.c
$(TARGETDIR)\iwaddr.obj: iwaddr.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwaddr.obj iwaddr.c
$(TARGETDIR)\divisor.obj: divisor.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\divisor.obj divisor.c
$(TARGETDIR)\digital.obj: digital.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\digital.obj digital.c
$(TARGETDIR)\digpause.obj: digpause.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\digpause.obj digpause.c
$(TARGETDIR)\digpos.obj: digpos.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\digpos.obj digpos.c
$(TARGETDIR)\iwatten.obj: iwatten.c iw.h iwl.h globals.h iwatten.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwatten.obj iwatten.c
$(TARGETDIR)\iwllist.obj: iwllist.c iw.h iwl.h globals.h iwllist.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwllist.obj iwllist.c
$(TARGETDIR)\iwnote.obj: iwnote.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwnote.obj iwnote.c
$(TARGETDIR)\timer.obj: timer.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\timer.obj timer.c
$(TARGETDIR)\iwerror.obj: iwerror.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwerror.obj iwerror.c
$(TARGETDIR)\iwscale.obj: iwscale.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwscale.obj iwscale.c
$(TARGETDIR)\iwmidi.obj: iwmidi.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwmidi.obj iwmidi.c
$(TARGETDIR)\iwuart.obj: iwuart.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwuart.obj iwuart.c
$(TARGETDIR)\iwrec.obj: iwrec.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwrec.obj iwrec.c
$(TARGETDIR)\iwmixer.obj: iwmixer.c iw.h iwl.h globals.h
	cl -c $(EXTRA) -Fo$(TARGETDIR)\iwmixer.obj iwmixer.c
$(TARGETDIR)\voltab.obj: voltab.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\voltab.obj voltab.c
$(TARGETDIR)\iwsound.obj: iwsound.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwsound.obj iwsound.c
$(TARGETDIR)\play.obj: play.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\play.obj play.c
$(TARGETDIR)\record.obj: record.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\record.obj record.c
$(TARGETDIR)\play16.obj: play16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\play16.obj play16.c
$(TARGETDIR)\vars16.obj: vars16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\vars16.obj vars16.c
$(TARGETDIR)\util16.obj: util16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\util16.obj util16.c
$(TARGETDIR)\codec.obj: codec.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\codec.obj codec.c
$(TARGETDIR)\irq16.obj: irq16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\irq16.obj irq16.c
$(TARGETDIR)\mixer16.obj: mixer16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\mixer16.obj mixer16.c
$(TARGETDIR)\mixctl.obj: mixctl.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\mixctl.obj mixctl.c
$(TARGETDIR)\mixbld.obj: mixbld.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\mixbld.obj mixbld.c
$(TARGETDIR)\profile.obj: profile.c iw.h profile.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\profile.obj profile.c
$(TARGETDIR)\profile1.obj: profile1.c iw.h profile.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\profile1.obj profile1.c
$(TARGETDIR)\iwmls.obj: iwmls.c iw.h
	cl -c $(CFLAGS) -Fo$(TARGETDIR)\iwmls.obj iwmls.c
$(TARGETDIR)\os.obj: $(OSINCTARGETDIR)\os.c
	cl -c $(EXTRA) -Fo$(TARGETDIR)\os.obj $(OSINCTARGETDIR)\os.c

$(TARGETDIR)\$(LIBNAME): $(OBJS) makeos
        if exist $(TARGETDIR)\$(LIBNAME) del $(TARGETDIR)\$(LIBNAME)
	lib $(TARGETDIR)\$(LIBNAME) @<<makems.lnk
+$(OBJS:  = &^
+)
;
<<KEEP

clean:
	if exist $(TARGETDIR)\*.obj del $(TARGETDIR)\*.obj
	if exist $(TARGETDIR)\*.lib del $(TARGETDIR)\*.lib
	if exist $(TARGETDIR)\*.bak del $(TARGETDIR)\*.bak
