/***************************************************************************
*	NAME:  VARS16.C $Revision: 1.1 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: vars16.c $
* Revision 1.1  1995/02/23 11:07:56  unknown
* Initial revision
***************************************************************************/
/***************************************************************************

OVERVIEW:
vars16.c - declaration of main codec data structures
*/

#include <stdio.h>
#include <dos.h>

#include "iw.h"
#include "iwl.h"
#include "digital.h"
#include "codec.h"

/***************************************************************************

GLOBAL DEFINITION:
codec_freq - maps supported codec frequencies to bit mask

DESCRIPTION:
The frequencies supported by the codec are truncated to the nearest
kHz value and mapped to the bit mask for the codec playback data
format register.

*/
CODEC_FREQ codec_freq[NUM_CODEC_FREQS] = {
	{5, 0x00|CODEC_XTAL2},
	{6, 0x0E|CODEC_XTAL2},
	{8, 0x00|CODEC_XTAL1},
	{9, 0x0E|CODEC_XTAL1},
	{11,0x02|CODEC_XTAL2},
	{16,0x02|CODEC_XTAL1},
	{18,0x04|CODEC_XTAL2},
	{22,0x06|CODEC_XTAL2},
	{27,0x04|CODEC_XTAL1},
	{32,0x06|CODEC_XTAL1},
	{33,0x0C|CODEC_XTAL2},
	{37,0x08|CODEC_XTAL2},
	{44,0x0A|CODEC_XTAL2},
	{48,0x0C|CODEC_XTAL1}
};

/***************************************************************************

GLOBAL DEFINITION:
codec_playback_voice - structure to track status of codec playback

SEE ALSO:
dig_voice_status in digital.h
*/
struct dig_voice_status codec_playback_voice;

/***************************************************************************

GLOBAL DEFINITION:
codec_record_voice - structure to track status of codec sampling

SEE ALSO:
dig_voice_status in digital.h
*/
struct dig_voice_status codec_record_voice;

/***************************************************************************

GLOBAL DEFINITION:
The following global variables form an image of the current values of the 
CODEC registers.
*/

unsigned int iwl_codec_setup;   /* CODEC/SCSI register on the UltraMAX */
unsigned char iwl_codec_shared_irq = 0;
OS_PINTERRUPT	iwl_old_codec_vec;
void (*iwl_codec_playback_func)();
void (*iwl_codec_capture_func)();
void (*iwl_codec_timer_func)();
unsigned int iwl_codec_playfreq;   /* playback freqency in hertz ... */
unsigned int iwl_codec_recfreq;    /* record freqency in hertz ... */

unsigned char iwl_clici  = 0x00; /* left ADC input control register */
unsigned char iwl_crici  = 0x00; /* right ADC input control register */
unsigned char iwl_clax1i = 0x08; /* left AUX1 input control register */
unsigned char iwl_crax1i = 0x08; /* left AUX1 input control register */
unsigned char iwl_clax2i = 0x88; /* left AUX2 input control register */
unsigned char iwl_crax2i = 0x88; /* left AUX2 input control register */
unsigned char iwl_cldaci = 0x00; /* left DAC output control register */
unsigned char iwl_crdaci = 0x00; /* right DAC output control register */
unsigned char iwl_cpdfi  = 0xFF; /* playback data format */
unsigned char iwl_crdfi  = 0x00; /* record data format */
unsigned char iwl_cfig1i = 0x00; /* configuration register 1 */
unsigned char iwl_cfig2i = 0x81; /* configuration register 2 */
unsigned char iwl_cfig3i = 0x42; /* configuration register 3 */
unsigned char iwl_cexti;         /* external control */
unsigned char iwl_csr2i;         /* status register 2 */
unsigned char iwl_csr3i;         /* status register 3 */
unsigned char iwl_cmodei;        /* mode and ID register */
unsigned char iwl_clci   = 0xFC; /* loopback control register */
unsigned char iwl_cupcti;        /* playback upper base register */
unsigned char iwl_clpcti;        /* playback lower base register */
unsigned char iwl_curcti;        /* record upper base register */
unsigned char iwl_clrcti;        /* record lower base register */
unsigned char iwl_cllici = 0x88; /* left line input control register */
unsigned char iwl_crlici = 0x88; /* right line input control register */
unsigned char iwl_cltimi;        /* timer low byte */
unsigned char iwl_cutimi;        /* timer high byte */
unsigned char iwl_clmici = 0x88; /* left mic input */
unsigned char iwl_crmici = 0x88; /* right mic input */
unsigned char iwl_cloai  = 0x00; /* left output attenuation */
unsigned char iwl_croai  = 0x00; /* right output attentuation */
unsigned char iwl_cmonoi = 0xC0; /* mono I/O control */
unsigned char iwl_cpvfi;         /* playback variable frequency */

