
;/***************************************************************************
;*    NAME:  DAC.INC
;**    COPYRIGHT:
;**    "Copyright (c) 1994, by FORTE
;**
;**       "This software is furnished under a license and may be used,
;**       copied, or disclosed only in accordance with the terms of such
;**       license and with the inclusion of the above copyright notice.
;**       This software or any other copies thereof may not be provided or
;**       otherwise made available to any other person. No title to and
;**       ownership of the software is hereby transfered."
;****************************************************************************
;*  CREATION DATE: 10/01/94
;*--------------------------------------------------------------------------*
;*     VERSION    DATE       NAME        DESCRIPTION
;*>    1.0    10/01/94        Original
;***************************************************************************/

;/************************************************************************/
;/* Definitions for CODEC_ADDR register */
;/* Bits 0-3. Select an internal register to read/write */

;/* Definitions for CODEC_ADDR register */
CODEC_INIT       equ 80H        ;/* CODEC is initializing */
CODEC_MCE        equ 40H        ;/* Mode change enable */
CODEC_TRD        equ 20H        ;/* Transfer Request Disable */
;/* bits 3-0 are indirect register address (0-15) */

USE_TRD            equ 0 ; lets try this now .... (This is what we SHOULD use )
;USE_TRD           equ CODEC_TRD ; lets try this now ....

LEFT_INPUT         equ USE_TRD+00H        ;/* Left input control register */
RIGHT_INPUT        equ USE_TRD+01H        ;/* RIght input control register */
SYN_LEFT_INPUT     equ USE_TRD+02H        ;/* Left Aux #1 input control */
SYN_RIGHT_INPUT    equ USE_TRD+03H        ;/* Right Aux #1 input control */
CD_LEFT_INPUT      equ USE_TRD+04H        ;/* Left Aux #2 input control */
CD_RIGHT_INPUT     equ USE_TRD+05H        ;/* Right Aux #2 input control */
LEFT_OUTPUT        equ USE_TRD+06H        ;/* Left output control */
RIGHT_OUTPUT       equ USE_TRD+07H        ;/* Right output control */
PLAYBK_FORMAT      equ USE_TRD+08H        ;/* Clock and data format */
IFACE_CTRL         equ USE_TRD+09H        ;/* Interface control */
PIN_CTRL           equ USE_TRD+0aH        ;/* Pin control */
TEST_INIT          equ USE_TRD+0bH        ;/* Test and initialization */
MISC_INFO          equ USE_TRD+0cH        ;/* Miscellaneaous information */
LOOPBACK           equ USE_TRD+0dH        ;/* Digital Mix */
PLY_UPR_CNT        equ USE_TRD+0eH        ;/* Playback Upper Base Count */
PLY_LWR_CNT        equ USE_TRD+0fH        ;/* Playback Lower Base Count */
ALT_FEATURE_1      equ USE_TRD+10H        ;/* alternate #1 feature enable */
ALT_FEATURE_2      equ USE_TRD+11H        ;/* alternate #2 feature enable */
LEFT_LINE_IN       equ USE_TRD+12H        ;/* left line input control */
RIGHT_LINE_IN      equ USE_TRD+13H        ;/* right line input control */
TIMER_LOW          equ USE_TRD+14H        ;/* timer low byte */
TIMER_HIGH         equ USE_TRD+15H        ;/* timer high byte */
IRQ_STATUS         equ USE_TRD+18H        ;/* irq status register */
MONO_IO_CTRL       equ USE_TRD+1aH        ;/* mono input/output control */
REC_FORMAT         equ USE_TRD+1cH        ;/* record format */
CPVFI              equ USE_TRD+1dh        ;/* var PCM */
REC_UPR_CNT        equ USE_TRD+1eH        ;/* record upper count */
REC_LWR_CNT        equ USE_TRD+1fH        ;/* record lower count */

;/* Definitions for CODEC_STATUS register */
CODEC_CUL       equ 80H        ;/* Capture data upper/lower byte */
CODEC_CLR       equ 40H        ;/* Capture left/right sample */
CODDEC_CRDY     equ 20H        ;/* Capture data read */
CODEC_SOUR      equ 10H        ;/* Playback over/under run error */
CODEC_PUL       equ 08H        ;/* Playback upper/lower byte */
CODEC_PLR       equ 04H        ;/* Playback left/right sample */
CODEC_PRDY      equ 02H        ;/* Playback data register read */
CODEC_INT       equ 01H        ;/* interrupt status */

;/* Definitions for Both Left and Right input level register */
LINE_SOURCE         equ 00H        ;/* Line source selected */
SYN_SOURCE          equ 40H        ;/* Auxiliary 1 source selected */
MIC_SOURCE          equ 80H        ;/* Microphone source selected */
MUX_OUTPUT_SOURCE   equ C0H        ;/* Post-mixed DAC output selected */
MIC_GAIN            equ 20H        ;/* microphone gain enable */
;/* bits 3-0 are left input gain select (0-15) */
;/* bits 3-0 are right input gain select (0-15) */

;/* Definitions for Left AUX #1 input level register */
MUTE_INPUT            equ 80H        ;/* Mute this input's source */

;/* bits 3-0 are left AUX #1 (SYN) input atten select (0-15) */
;/* bits 3-0 are right AUX #1 (SYN) input atten select (0-15) */
;/* bits 3-0 are left AUX #2 (CD) input atten select (0-15) */
;/* bits 3-0 are right AUX #2 (CD) input atten select (0-15) */

;/* Definitions for Left output level register */
MUTE_OUTPUT        equ 80H        ;/* Mute this output source */
;/* bits 5-0 are left output attenuation select (0-63) */
;/* bits 5-0 are right output attenuation select (0-63) */

;/* Definitions for clock and data format register */
BIT_8_ALAW           equ 60H    ;/* 8 bit A-law companded */
BIT_16_LINEAR        equ 40H    ;/* 16 bit twos complement data */
BIT_8_ULAW           equ 20H    ;/* 8 bit U-law companded */
BIT_8_LINEAR         equ 00H    ;/* 8 bit unsigned data */
TYPE_STEREO          equ 10H    ;/* stero mode */
;/* Bits 3-1 define frequency divisor */
XTAL1                equ 00H    ;/* 24.576 crystal */
XTAL2                equ 01H    ;/* 16.9344 crystal */

;/* Definitions for interface control register */
CAPTURE_PIO          equ 80H    ;/* Capture PIO enable */
PLAYBACK_PIO         equ 40H    ;/* Playback PIO enable */
AUTOCALIB            equ 08H    ;/* auto calibrate */
SINGLE_DMA           equ 04H    ;/* Use single DMA channel */
CAPTURE_ENABLE       equ 02H    ;/* Capture enable */
PLAYBACK_ENABLE      equ 01H    ;/* playback enable */

;/* Definitions for Pin control register */
IRQ_ENABLE               equ 02H    ;/* interrupt enable */
XCTL1                    equ 40H    ;/* external control #1 */
XCTL0                    equ 80H    ;/* external control #0 */

;/* Definitions for MISC control register */
CODEC_MODE2              equ 40H    ;/* MODE 2 */

;/* Definitions for Alternate feature 1 register */
CODEC_DACZ              equ 01H    ;/* zero DAC when under run */
TIMER_ENABLE            equ 40H    ;/* Codec timer enable */
CODEC_OLB               equ 80H    ;/* output level bit */
                                ;;        /* 0=2.0 (-3db), 1=2.8 (0db) */

;/* Definitions for irq status (alternate feature status bits) */
PLAYBACK_IRQ            equ 10H
CAPTURE_IRQ             equ 20H
TIMER_IRQ               equ 40H

;/* Definitions for Test and init register */
CALIB_IN_PROGRESS        equ 20H    ;/* auto calibrate in progress */

;/* Definitions for Digital mix control register */
;/* bits 7-2 are for the digital mix attenuation */
DIGITAL_MIX_ENABLE        equ 01H    ;/* enable digital mix (monitor) */

