/*****************************************************************************
    debug.h  - Debug defines
*****************************************************************************/

typedef struct
    {
    int bank;
    int instrument;
    FM_OPERATOR car;
    FM_OPERATOR mod;
    FM_CHANNEL chan;
    } SNAPSHOT;

#define PICK_LIST_ELEMENTS 5
#define PICK_LIST_SIZE PICK_LIST_ELEMENTS*2

/** Offsets into the debug pointer array **/

#define DEBUG_ARRAY_SIZE     28
#define OFF_NMI_COUNT         0
#define OFF_TABLE_COUNT       1
#define OFF_NMI_TABLE         2
#define OFF_FM_CHANNEL        3
#define OFF_FM_OPERATOR       4
#define OFF_CUR_INSTRUMENT    5
#define OFF_CUR_BANK          6
#define OFF_SNAP              7
#define OFF_FORCE_INSTRUMENT  8
#define OFF_FMREGS            9
#define OFF_CHAN_DISABLE      10
#define OFF_PICK_LIST         11
#define OFF_NOTES_PLAYING     12
#define OFF_CHAN_INSTRUMENT   13

#define GPR1W_CODE    0
#define GPR2W_CODE    1
#define GPR1R_CODE    2
#define GPR2R_CODE    3
#define R2xER_CODE    4
#define R2x6W_CODE    5
#define R388W_CODE    6
#define R389W_CODE    7
#define R2xCW_CODE    8
#define DMA_DEBUG     9
#define DMA_MARKER    10
#define TIMER_MARKER  11
#define MARKER4_CODE  252
#define MARKER3_CODE  253
#define MARKER2_CODE  254
#define MARKER_CODE   255

// MARKER CODES (for debug ONLY ....)
#define DMA_HALT_MARK           0x57
#define DMA_INIT_MARK           0x58
#define DMA_PROG_BLOCK_MARK     0x59
#define DMA_SET_BLOCK_MARK      0x5a
#define DMA_IRQ_MARK            0x5b
#define DMA_ADC_BLOCK_MARK      0x5c
#define DMA_ADPCM_MARK          0x5d
#define DMA_ADPCM_REF_MARK      0x5e
#define DMA_IRQ_ADPCM_MARK      0x5f

