/***************************************************************************
*       NAME:  DEBUGC.C $Revision: 1.3 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************/
#ifdef DEBUG

#include "fm.h"
#include "debug.h"

extern int cur_instrument[];
extern int cur_bank[];
extern unsigned int nmi_count;
extern unsigned int nmi_table_cnt;
extern unsigned int nmi_table;
extern FM_CHANNEL fm_channel[];
extern int fm_chan;
extern FM_OPERATOR fm_operator[];
extern unsigned long notes_playing;
extern unsigned char chan_instrument[];

int cur_instrument[9]   = {0};  /** copy of current channel instrument **/
int cur_bank[9]         = {0};  /** copy of current channel inst bank  **/
int force_instrument[9] = {0};  /** 1 to bypass picking algorithm      **/
unsigned char pick_list[9][PICK_LIST_SIZE]; /** chosen instruments **/

SNAPSHOT snap[9];          /** one for each fm channel              **/
unsigned char fmregs[256]; /** copy of current fm registers         **/
int chan_disable[9] = {0}; /** 1 if channel is disabled **/

    /** A pointer to this is given through int7e func(02) subf(00) **/
    /** These BEST match the defines in debug.h **/
unsigned int debug_ptrs[DEBUG_ARRAY_SIZE] = 
    {
    (unsigned int)&nmi_count,
    (unsigned int)&nmi_table_cnt,
    (unsigned int)&nmi_table,
    (unsigned int)&fm_channel,
    (unsigned int)&fm_operator,
    (unsigned int)&cur_instrument,
    (unsigned int)&cur_bank,
    (unsigned int)&snap,
    (unsigned int)&force_instrument,
    (unsigned int)&fmregs,
    (unsigned int)&chan_disable,
    (unsigned int)&pick_list,
    (unsigned int)&notes_playing,
    (unsigned int)&chan_instrument,
    };

/****************************************************************************

FUNCTION DEFINITION:
snapshot -

DESCRIPTION:
  Copies the current contents of fm_channel, carrier fm_operator, and
  modulator fm_operator structures to debug buffer.
  Pointer to this buffer can be gotten from debug_ptrs.

EXPECTS:

MODIFIES:

SEE ALSO:

RETURNS:

*/
void snapshot(void)
{
    int i;
    
    for(i=0; i<9; i++)
        {
        snap[i].bank = cur_bank[i];
        snap[i].instrument = cur_instrument[i];
        snap[i].chan = fm_channel[i];
        snap[i].mod  = fm_operator[i*2];
        snap[i].car  = fm_operator[i*2+1];
        }
}

/****************************************************************************

FUNCTION DEFINITION:
add_to_pick_list - Adds inst and val to the pick_list[][] array for debugging

DESCRIPTION:

EXPECTS:

MODIFIES:

SEE ALSO:

RETURNS:

*/
void add_to_pick_list(unsigned char inst, unsigned char val)
{
    int i;

    for(i=PICK_LIST_SIZE-2; i>=0; i-=2)
        {
        if((unsigned)pick_list[fm_chan][i+1] > (unsigned)val) /** this one shifts **/
            {
            if(i<PICK_LIST_SIZE-2)
                {
                pick_list[fm_chan][i+2] = pick_list[fm_chan][i];
                pick_list[fm_chan][i+3] = pick_list[fm_chan][i+1];
                }
            pick_list[fm_chan][i] = inst;
            pick_list[fm_chan][i+1] = val;
            }
        }
}
#endif
