
; Defines for SoundBlaster DSP command parsing (dsp_status)
BUSY            equ     0001h ; Next byte is data if BUSY
COMMAND_10      equ     0002h ; Last command was 10h, next byte is data
DONE_ADPCM      equ     0004H ; this is last ADPCM buffer
ADPCM_MODE      equ     0008h ; Doing ADPCM playback ....
PULSE_SBIRQ     equ     0010h ; pulse timer once and force sb irq
GOT_FIRST_CRYPT equ     0020h ; got first encryption byte ...
SILENCE_DELAY   equ     0040h ; doing a silence delay
DEBUG_TIMER_BIT equ     0080h ; letting timer run for a pulse ...
ADPCM_BUFF2     equ     0100h ; 0 = first buffer, 1 = second half buffer
NEXT_2_LAST     equ     0200h ; show this is the next to last ADPCM buffer
HIGH_SPEED      equ     0400h ; We are in 'high-speed' DMA mode ...
AUTOINIT_MODE   equ     0800h ; We are in loop-ed DMA mode

IFDEF D_SB
SIZE_ADPCM         EQU        1024
ELSE
SIZE_ADPCM         EQU        256
ENDIF
