; mpu401.inc     translated include file
; mpu-401 command and message summary

;/* mpu marks */

MPU_NOP        equ       f8h ;   /* no operation */
MES_END        equ       f9h ;   /*  measure end */
DATA_END       equ       fch ;   /*  end data */

;/* mpu messages */

REQ_T1         equ       f0h ;   /* track data request track 1 */
REQ_T2         equ       f1h ;  
REQ_T3         equ       f2h ;
REQ_T4         equ       f3h ;
REQ_T5         equ       f4h ;
REQ_T6         equ       f5h ;
REQ_T7         equ       f6h ;
REQ_T8         equ       f7h ;   /* track data request track 8 */
TIME_OUT       equ       f8h ;   /* timing overflow */
CONDUCT        equ       f9h ;   /* conductor data request */
ALL_END        equ       fch ;   /* all end */
CLOCK_OUT      equ       fdh ;   /* clock to host */
ACK            equ       feh ;   /* acknowledge */
SYS_MES        equ       ffh ;   /* system message */

;/* mpu commands */

STOP_PLAY      equ       05h
START_PLAY     equ       0ah
STOP_REC       equ       11h
START_REC      equ       22h
STOP_OVDUB     equ       15h
START_OVDUB    equ       2Ah

N0_ALL_OFF     equ       30h ;   /* all notes off */
NO_RTIME       equ       32h ;   /* no real time */
THRU_OFF_CHAN  equ       33h ;   /* thru : off on channels */
WITH_TIME      equ       34h ;   /* with timing byte : on */
MODE_THRU      equ       35h ;   /* mode mes : on */
EXCL_THRU      equ       36h ;   /* exclusive thru : on */
COM_THRU       equ       38h ;   /* common to host : on */
REAL_THRU      equ       39h ;   /* real time to host : on */
UART           equ       3fh ;   /* uart mode */

;/* channel reference table numbers are normally computed */

;  40 - 4f sets channel reference table a
;  50 - 5f b
;  60 - 6f c
;  70 - 7f d

INT_CLOCK      equ       80h ;   /* internal clock */
FSK_CLOCK      equ       81h ;   /* fsk clock */
MIDI_CLOCK     equ       82h ;   /* midi clock */
MET_ON_WOUT    equ       83h ;   /* metronome : on - w/o accents */
MET_OFF        equ       84h ;   /* metronome : off */
MET_ON_WITH    equ       85h ;   /* metronome : on - with accents */
BEND_OFF       equ       86h ;   /* bender : off */
BEND_ON        equ       87h ;   /* bender : on */
THRU_OFF       equ       88h ;   /* midi thru : off */
THRU_ON        equ       89h ;   /* midi thru : on */
DSTOP_OFF      equ       8ah ;   /* data in stop mode : off */
DSTOP_ON       equ       8bh ;   /* data in stop mode : on */
MEAS_OFF       equ       8ch ;   /* send measure end : off */
MEAS_ON        equ       8dh ;   /* send measure end : on */
COND_OFF       equ       8eh ;   /* conductor : off */
COND_ON        equ       8fh ;   /* conductor : on */
REAL_OFF       equ       90h ;   /* real time affecton : off */
REAL_ON        equ       91h ;   /* real time affection : on */
FSK_INT        equ       92h ;   /* fsk to internal */
FSK_MIDI       equ       93h ;   /* fsk to midi */
CLOCK_OFF      equ       94h ;   /* clock to host : off */
CLOCK_ON       equ       95h ;   /* clock to host : on */
EXCL_OFF       equ       96h ;   /* exclusive to host : off */
EXCL_ON        equ       97h ;   /* exclusive to host : on */

CHANA_OFF      equ       98h ;   /* reference table a : off */
CHANA_ON       equ       99h ;   /* a : on */
CHANB_OFF      equ       9ah ;   /* b : off */
CHANB_ON       equ       9bh ;   /* b : on */
CHANC_OFF      equ       9ch ;   /* c : off */
CHANC_ON       equ       9dh ;   /* c : on */
CHAND_OFF      equ       9eh ;   /* d : off */
CHAND_ON       equ       9fh ;   /* d : on */

;/* reading data */

REQ_CNT0       equ       a0h ;   /* request play counter of track 1 */
REQ_CNT1       equ       a1h
REQ_CNT2       equ       a2h
REQ_CNT3       equ       a3h
REQ_CNT4       equ       a4h
REQ_CNT5       equ       a5h
REQ_CNT6       equ       a6h
REQ_CNT7       equ       a7h

REQ_REC_CNT    equ       abh ;   /* request record counter */
REQ_VER        equ       ach ;   /* request version */
REQ_REV        equ       adh ;   /* request revision */
REQ_TEMPO      equ       afh ;   /* request tempo */

RES_RTEMPO     equ       b1h ;   /* resets relative tempo */
CLEAR_PCOUNT   equ       b8h ;   /* clear play counters */
CLEAR_PMAP     equ       b9h ;   /* clear play map - all notes off */
CLEAR_REC      equ       bah ;   /* clear record counter */

TB_48          equ       c2h ;   /* 48 timebase */
TB_72          equ       c3h
TB_96          equ       c4h
TB_120         equ       c5h
TB_144         equ       c6h
TB_168         equ       c7h
TB_192         equ       c8h

WSD0           equ       d0h ;   /* want to send data on track 1 */
WSD1           equ       d1h
WSD2           equ       d2h
WSD3           equ       d3h
WSD4           equ       d4h
WSD5           equ       d5h
WSD6           equ       d6h
WSD7           equ       d7h

WS_SYS         equ       dfh ;   /* want to send system message */

;/* set conditions and values (follow by 1 byte data) */

SET_TEMPO      equ       e0h ;   /* set tempo */
SET_RTEMPO     equ       e1h ;   /* relative tempo */
SET_GRAD       equ       e2h ;   /* graduation */
MIDI_METRO     equ       e4h ;   /* midi clocks per metronome beep */
METRO_MEAS     equ       e6h ;   /* metro/meas */
INT_HOST       equ       e7h ;   /* int * 4 / clock to host */
ACT_TRACK      equ       ech ;   /* active tracks on/off */
SEND_PCOUNT    equ       edh ;   /* send play counter on/off */
CHAN_ON1       equ       eeh ;   /* acceptable channels 1 - 8 on/off */
CHAN_ON2       equ       efh ;   /* acceptable channels 9 - 16 on/off */

RESET          equ       ffh
