/* bits */
#define BIT0  0x01
#define BIT1  0x02
#define BIT2  0x04
#define BIT3  0x08
#define BIT4  0x10
#define BIT5  0x20
#define BIT6  0x40
#define BIT7  0x80
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

#define IW_WAVE_FORMAT_8BIT	BIT0
#define IW_WAVE_FORMAT_SIGNED	BIT1
#define IW_WAVE_FORMAT_FORWARD	BIT2
#define IW_WAVE_FORMAT_LOOP	BIT3
#define IW_WAVE_FORMAT_BIDIR	BIT4
#define IW_WAVE_FORMAT_ULAW	BIT5
#define IW_WAVE_FORMAT_ROM	BIT7
#define CARRY_FLAG        1

#define IW_ENVELOPE_ONE_SHOT	1
#define IW_ENVELOPE_SUSTAIN	2
#define IW_ENVELOPE_NO_SUSTAIN	3

#define IW_ENVELOPE_IDX_NONE	0
#define IW_ENVELOPE_IDX_VELOCITY	1
#define IW_ENVELOPE_IDX_FREQUENCY	2

#define RFAR far
#define ULONG unsigned long
#define USHORT unsigned short
#define UINT unsigned int

#define NO_ERROR        0
#define END_OF_FILE     1
#define BUFFER_FULL     2
#define INVALID_PROFILE 3
#define NO_SUCH_FILE    4
#define FOUND_ENTRY     5

/* error codes */
#define IW_OK                  0
#define IW_NO_MORE_VOICES      -1
#define IW_BASE_NOT_FOUND      -2
#define IW_BAD_IRQ             -3
#define IW_BAD_DMA             -4
#define IW_OS_LOADED           -5
#define IW_NOT_LOADED          -6
#define IW_NO_MEMORY           -7
#define IW_DMA_BUSY            -8
#define IW_NO_MORE_HANDLERS    -9
#define IW_DMA_HUNG            -10
#define IW_CARD_NOT_FOUND      -11
#define IW_CARD_BEING_USED     -12
#define IW_NO_MORE_INTERRUPTS  -13
#define IW_BAD_TIMER           -14
#define IW_DOS_ERROR           -17
#define IW_FILE_NOT_FOUND      -18
#define IW_CODEC_NOT_FOUND     -19
#define IW_ICS_MIXER_NOT_FOUND -20
#define IW_ILLEGAL             -21

/* DOS functions */
#define DOS_TRAP        0x21
#define SETVECTOR       0x2500
#define GETVECTOR       0x3500
#define DOS_READ        0x3F00
#define DOS_CLOSE       0x3E00
#define DOS_OPEN_RW     0x3D02
#define DOS_OPEN_R      0x3D00
#define DOS_SEEK        0x4200

/* Seek from the current file position */
#define DOS_SEEK_START     0
#define DOS_SEEK_END       2
#define DOS_SEEK_CURRENT   1

unsigned short file_read(int handle, void far *io_buffer, unsigned short size);
char far *file_gets(int handle, char far *io_buffer, unsigned short size);
unsigned short file_close(int handle);
unsigned short file_seek(int handle, unsigned long offset, int method);
int file_open(char far *name);
//char RFAR *getenv(const char *);


/* FUNCTION PROTOTYPES */
/* Initializeation routines */
int     iwu_get_profile_string(char RFAR *, char RFAR *, char RFAR *,
                               char RFAR *, int, char RFAR *);
int iw_atoi(void);
/* Substitutes for standard C-library functions */
/* (to avoid linking in the C-runtime in TSRs)  */

/* ctype.h */
int iwu_isalnum(int c);
int iwu_isalpha(int c);
int iwu_isspace(int c);

/* stdlib.h */
char RFAR *iwu_itoa(int integer, char RFAR *buffer, int radix);

/* string.h */
void RFAR *iwu_memcpy(void RFAR *dest, const void RFAR *src, unsigned int n);
void RFAR *iwu_memset(void RFAR *dest, int c, unsigned int n);
char RFAR *iwu_strcat(char RFAR *dest, const char RFAR *src);
int iwu_strcmp(const char RFAR *s1, const char RFAR *s2);
char RFAR *iwu_strcpy(char RFAR *dest, const char RFAR *src);
int iwu_strncmp(const char RFAR *s1, const char RFAR *s2, unsigned int maxlen);
int iwu_stricmp(const char RFAR *s1, const char RFAR *s2);
int iwu_strnicmp(const char RFAR *s1, const char RFAR *s2, unsigned int maxlen);
int iwu_strlen(const char RFAR *s1);
void iwu_swab(char RFAR *, char RFAR *, int);
char RFAR *iwu_strtok(char RFAR *, const char RFAR *);
char RFAR *iwu_strncpy(char RFAR *dest, const char RFAR *src, 
                       unsigned int maxlen);
long iwu_strtol(const char RFAR *str, char RFAR * RFAR *endptr, int rad);

void iw_mls_init(char RFAR *path);
long iw_mls_strlen(char RFAR *langfile, unsigned short id);
int iw_mls_getstring(char RFAR *langfile, unsigned short index, char RFAR *buf, unsigned short buflen);
