;*********************************************************************
;
; TIMER Module --  
;
; The only entry points include:
;	start_timer
;	stop_timer
;
;*********************************************************************
.386

INCLUDE sbosdefs.inc
INCLUDE dac.inc

_DATA     segment word public use16 'DATA'
_DATA     ends
_BSS      segment word public use16 'BSS'
_BSS      ends
_TEXT     segment byte public use16 'CODE'
_TEXT     ends
DGROUP    group    _DATA,_BSS,_TEXT

extrn _reg_codec_addr:word
extrn _reg_codec_data:word
extrn _SetPic:near

public start_timer
public stop_timer

_DATA     segment word public use16 'DATA'

_DATA     ends

_TEXT           segment byte public use16 'CODE'
assume          cs:DGROUP, ds:DGROUP, ss:DGROUP


start_timer proc near
; CODEC timer is a 10 microsec timer. 
; Enter: BX = # of 10 usec tics before IRQ
	mov dx,_reg_codec_addr
	mov al,TIMER_LOW
	out dx,al
	inc dx
	mov al,bl
	out dx,al

	dec dx
	mov al,TIMER_HIGH
	out dx,al
	inc dx
	mov al,bh
	out dx,al

	call near ptr _SetPic

	mov dx,_reg_codec_addr
	mov al,ALT_FEATURE_1
	out dx,al
	inc dx
	in al,dx
	or al,40H			; enable timer
	out dx,al

	ret
start_timer endp

stop_timer proc near
	mov dx,_reg_codec_addr
	mov al,ALT_FEATURE_1
	out dx,al
	inc dx
	in al,dx
	and al,0BFH			; disable timer
	out dx,al
	ret
stop_timer endp

_TEXT ends
	end
