#ifndef __LIST_H
#define __LIST_H

#define PREPEND 1
#define APPEND  2

struct node {
    struct node *next;
    struct node *prev;
    void *data;
};

struct list {
    struct node *head;
    struct node *tail;
};

void InitList(struct list *list);
struct list *CreateList(void);
struct node *CreateNode(void *data);
void DestroyNode(struct node *node);
void AddNode(struct list *list, struct node *node, struct node *where, int pa);
void DeleteNode(struct list *list, struct node *node);
#endif
