#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <mem.h>
#include <direct.h>
#include <dos.h>

#include "iw.h"
#include "patch.h"
#include "rommaker.h"

unsigned _stklen = 16000;
unsigned long check_sum = 0L;

unsigned rom_size = 2;		/* size of rom chips in megabytes */
unsigned saveas8 = 0;		/* convert .FFF to 8 bit */
unsigned saveasulaw = 0;	/* convert .FFF to ULAW */
#define MAX_ROM_FILES 100
int rom_list_index = 0;		/* current index into file list */
char *rom_list[MAX_ROM_FILES] = { 0L };

void do_help(void)
{
    fprintf(stderr, "USAGE: rommaker rom_file_cfg [rom_file_cfg list...]\n");
    exit(-2);
}

void multiple_load(char *files)
{
    struct find_t fileinfo;
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char file[_MAX_FNAME];
    char ext[_MAX_EXT];
    char path[_MAX_PATH];
    char fpath[_MAX_PATH];
    int ret;

    _splitpath(files,drive,dir,file,ext);
    _makepath(path,drive,dir,NULL,NULL);
    ret = _dos_findfirst(files, _A_NORMAL, &fileinfo);
    if (ret != 0) {
	fprintf(stderr, "Can't find file %s\n", files);
    }
    while (ret == 0) {
	strcpy(fpath, path);
	strcat(fpath, fileinfo.name);
	rom_list[rom_list_index] = malloc(strlen(fpath)+1);
	if (rom_list[rom_list_index]) {
	    strcpy(rom_list[rom_list_index], fpath);
	    rom_list_index++;
	    rom_list[rom_list_index] = 0;
	}
	ret = _dos_findnext(&fileinfo);
    }
}

int main(int argc, char *argv[])
{
    int i, retval;
    struct patch_lib RFAR*pl, RFAR*npl;

    /* This program will search through the .INI file for a list of .FFF */
    /* files, and rewrite the .FFF files. */
    
    /* a second pass will create files called ROM0.BIN, ROM1.BIN, etc. */
    for (i=1; i < argc; i++) {
	if (argv[i][0] == '-' || argv[i][0] == '/' || argv[i][0] == '+') {
	    strupr(argv[i]);
	    switch (argv[i][1]) {
		case 'S':
		    if (strcmp(&argv[i][1], "SIZE") == 0) {
			rom_size = atoi(argv[++i]);
			if (rom_size == 0) do_help();
		    }
		    break;
		case '8':
		    saveas8 = 1;
		    break;
		case 'U':
		    if (strcmp(&argv[i][1], "ULAW") == 0) saveasulaw = 1;
		    break;
		default:
		    fprintf(stderr, "unknown option %s\n", argv[i]);
		    do_help();
		    break;
	    }
	} else {
	    multiple_load(argv[i]);
	}
    }
    rom_list_index = 0;
    if (rom_list[rom_list_index] == 0) {
	fprintf(stderr, "which rom files should I create?\n");
	do_help();
    }
    while (rom_list[rom_list_index] != 0) {
	printf("Working on %s\n", rom_list[rom_list_index]);
	/* load .FFF files into PC memory */
	if ((retval = rom_get_patch_config(rom_list[rom_list_index])) != IWU_PATCH_OK) {
	    fprintf(stderr, "ERROR: %s\n", iwu_error_str(retval));
	    exit(-3);
	}

	/* now condense sound data into single file and .FFFs into single file */
	retval = SaveFFF(saveas8, saveasulaw,rom_list[rom_list_index]);
	if (retval != 0) {
	    fprintf(stderr, "Error creating intermediate files.\n");
	    exit(-4);
	}
	/* free patch lib */
	for (pl=plib; pl; pl=npl) {
	    npl = pl->next;
	    iwu_fff_unload(pl);
	    free(pl);
	}
	plib = 0;

	/* now combine .FFF and .DAT into ROMx.BIN files */
	retval = SaveBin(rom_list[rom_list_index]);
	if (retval != 0) {
	    fprintf(stderr, "Error creating ROM files.\n");
	    exit(-5);
	}
	rom_list_index++;
    }
    return(0);
}
