/***************************************************************************
*   NAME:  MIDI.H $Revision: 1.10 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: midi.h $
* Revision 1.10  1995/09/29 13:47:17  teckert
* Added BlockMidiClients and UnBlockMidiClients to facilitate iwReloadPatchMap
* Revision 1.9  1995/07/11 10:27:16  teckert
* Added function to clear user flags when synth client closes
* Revision 1.8  1995/06/28 11:37:36  teckert
* Rewrote patch caching strategy to handle low memory conditions.
* Revision 1.7  1995/04/28 16:05:29  teckert
* Added MAXDEFEREDNOTES to header file
* Revision 1.6  1995/04/19 18:38:02  teckert
* Updated with new patch.c functions, removed obsolete references
* Revision 1.5  1995/04/04 15:40:16  teckert
* Bug fix for MCI pause-unpause bug
* Revision 1.4  1995/03/17 17:41:11  teckert
* Added hardware acquisition request handle to midi client structure
* Revision 1.3  1995/03/01 17:46:44  teckert
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/
#ifndef MIDI_H
#define MIDI_H

		  
#define MAXMIDICLIENTS  2   // This value must be synchronized with the
							// MAXCHANNELS define in the Kernel
							// MAXCHANNELS = MAXMIDICLIENTS * 16
#define MAXSYSEXDATA 20

// Sysex Message Commands
#define SXM_PATCHLOAD       0x00
#define SXM_EDITPATCH       0x01
#define SXM_EDITLAYER       0x02
#define SXM_EDITENVELOPE    0x03
#define SXM_EDITWAVE        0x04
#define SXM_MAXCOMMAND      0x04

// Sub commands for SXM_PATCHLOAD
#define SXMP_LOAD           0x00
#define SXMP_UNLOAD         0x01

// Sub commands for SXM_EDITPATCH
#define SXMP_LAYERMODE      0x01
#define SXMP_EXCLUSIONMODE  0x02
#define SXMP_EXCLUSIONGROUP 0x03
#define SXMP_EFFECTONE      0x04
#define SXMP_EFFECTONEDEPTH 0x05
#define SXMP_EFFECTTWO      0x06
#define SXMP_EFFECTTWODEPTH 0x07

// Sub commands for SXM_EDITLAYER
#define SXML_HIGHRANGE      0x01
#define SXML_LOWRANGE       0x02
#define SXML_PANOFFSET      0x03
#define SXML_PANFREQ        0x04
#define SXML_TREMDEPTH      0x05
#define SXML_TREMRATE       0x06
#define SXML_TREMSWEEP      0x07
#define SXML_TREMDELAY      0x08
#define SXML_TREMSHAPE      0x09
#define SXML_VIBDEPTH       0x0A
#define SXML_VIBRATE        0x0B
#define SXML_VIBSWEEP       0x0C
#define SXML_VIBDELAY       0x0D
#define SXML_VIBSHAPE       0x0E
#define SXML_VELMODE        0x0F
#define SXML_ATTEN          0x10
#define SXML_FREQSCALE      0x11
#define SXML_FREQCENTER     0x12
#define SXML_LAYEREVENT     0x13
#define SXML_FLAGS              0x14

// Sub commands for SXM_EDITENVELOPE
#define SXME_MODE            0x01
#define SXME_INDEX           0x02
#define SXME_NUMENV          0x03
#define SXME_FLAGS               0x04
#define SXME_GLOBAL_COMMANDS 0x10

#define SXME_HIRANGE            0x10
#define SXME_SOFFSET            0x11
#define SXME_SRATE              0x12
#define SXME_RRATE              0x13
#define SXME_NATTACK            0x14
#define SXME_NRELEASE           0x15
#define SXME_INDEXED_COMMANDS   0x20

// Sub commands for SXM_EDITWAVE
#define SXMW_WAVESIZE       0x01
#define SXMW_LOOPSTART      0x02
#define SXMW_LOOPEND        0x03
#define SXMW_SAMPLERATIO    0x04
#define SXMW_LOWNOTE        0x05
#define SXMW_HIGHNOTE       0x06
#define SXMW_FORMAT         0x07


// Values for nLoadStatus
#define LS_LOADONCACHE	0
#define LS_LOADONASSIGN 1
#define LS_LOADONPLAY	2
extern int nLoadStatus; 

struct SysexMessage {
	unsigned char type;
	unsigned char program;
	unsigned char bank;
	unsigned char command;
	unsigned char subcmnd;
	int           numdatabytes;
	int           nextdatabyte;
	unsigned char checksum;
	unsigned char data[MAXSYSEXDATA];       
};
	
// Load patch return codes
#define LP_OK           0
#define LP_CDNTOPENFILE 1
#define LP_CDNTSEEK     2
#define LP_BADFILE      3
#define LP_NOMEM        4

// Message Callback Codes
#define MC_LOADPATCHES  	1
#define MC_LOADMELODICPATCHES   2
#define MC_NOTEON		3
#define MC_NOTEOFF		4
#define MC_DOSYSEX		5

// MIDI Client Status codes
#define MCS_CLOSED      0
#define MCS_OPEN        1
#define MCS_STARTED     2
#define MCS_FIRSTCACHE  4       // Set after first patch cache message since note on

typedef struct MIDICLIENT_tag {
	BYTE bClientStatus;
	WORD wVolume;
	DWORD dwCallback;                                                       
	DWORD dwInstance;
	DWORD dwFlags;
	WORD hMidi;
	WORD wHWAH;				    // hardware acquisition request handle
	int nMidiParserStatus;                      // Synth and Midi-out parsers
	unsigned char bStatus;                      //      "
	unsigned char bByteOne;                     //      "
	unsigned char bByteTwo;                     //      "
	unsigned char bRunningStatus;               //      "
	int nSysexParserStatus;                     // Midi synth only
	struct SysexMessage SysMsg;                 //      "
	int CurBank[16];                            //      "
	struct iwu_fast_patch RFAR*CurPatch[16];    //      "
	LPMIDIHDR lpBufferQueue;                    // Midi-in only
	LPBYTE lpCurPos;                            //      "
	DWORD dwBytesRecorded;                      //      "
	DWORD dwTimeZero;                           //      "
	DWORD dwTime;                               //      "
} MIDICLIENT;
typedef MIDICLIENT;
extern MIDICLIENT MidiClients[MAXMIDICLIENTS+2];
#define OUTPORTCLIENT   MAXMIDICLIENTS
#define INPORTCLIENT    MAXMIDICLIENTS + 1  
#define PLE_WAVE_MEM(pPLE) (((unsigned char far *)(pPLE)) + sizeof(struct PatchListEntry))
		    
int ReadPatchDatabase(void);
DWORD CachePatches(int nClient, LPPATCHARRAY lpPatchArray, WORD wBank, WORD wFlags, int nMelodic);
void ProgramAssign(int nClient, int nChan, int nProgram);
void NoteOn(int nClient, int nChan, int nNote, int nVel);
void NoteOff(int nClient, int nChan, int nNote);
void iwu_clear_patch_uds(void);


/* MIDI Port Support Functions
*/
void MidiPortOutByte(BYTE bByte);
int ModMessageLength(DWORD dwMessage);
		
#define MAXDEFEREDNOTES 64

/* Buffer for midi patch loading
*/
#define PLOAD_BSIZE	4096

/* Blocking functions to support reloading the patch map
 */
extern int nBlockMidiSynth; 
int BlockMidiClients(void);
void UnBlockMidiClients(void);

#endif // MIDI_H
