/***************************************************************************
*   NAME:  VIWD.H $Revision: 1.16 $
**  COPYRIGHT:
**  "Copyright (c) 1994, by ETEK Labs
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: viwd.h $
* Revision 1.16  1995/12/14 14:56:46  unknown
* Put an ifdef _MSC_VER block around the pragma's and structure definition.
* Revision 1.15  1995/12/14 14:08:13  unknown
* Added pragma pack to get correct alignment of structure
* Revision 1.14  1995/11/24 12:44:32  teckert
* Added DriverDS field to the global data structure
* Revision 1.13  1995/11/22 14:51:19  teckert
* Added pending driver operation field to the global data structure
* Revision 1.12  1995/11/21 17:24:54  sdsmith
* Changes for new InitCallback function
* Revision 1.11  1995/11/20 16:28:47  teckert
* Added IW_KERNEL_SLEEP and IW_KERNEL_WAKE constants
* Revision 1.10  1995/10/13 08:29:09  teckert
* Added direct sound flags
* Revision 1.9  1995/09/21 16:40:39  sdsmith
* Added IWAPI_READDMACOUNT for getting DMA count via the VxD
* Revision 1.8  1995/09/21 14:07:23  teckert
* Added the Read_DMA_Count api call
* Revision 1.7  1995/09/08 11:04:25  teckert
* Added Windows 95 changes
* Revision 1.6  1995/09/06 13:31:23  teckert
* Added GetResourceConfig API function and IWAR_RECONFIG code
* Revision 1.5  1995/04/18 14:51:14  teckert
* Updated the VIWD device ID to our official one 33F0
* Revision 1.4  1995/04/10 13:46:22  teckert
* added sbos defines
* Revision 1.3  1995/03/20 16:25:28  teckert
* Updated resource list
* Revision 1.2  1995/03/20 15:01:11  teckert
* Updated resource codes and added file header
***************************************************************************/

#define INTERWAV_DEV_ID         0x33F0

// The following Adlib ports are always at the same location
#define IW_PORT_UAACWR  0x388
#define IW_PORT_UAADR   0x389
		   
// The following group of ports will need to have P2XR added to them before
// the I/O handlers can be installed                   
#define IW_PORT_UMCR    0x00
#define IW_PORT_U2X6R   0x06
#define IW_PORT_UACWR   0x08
#define IW_PORT_UADR    0x09
#define IW_PORT_UACRR   0x0A
#define IW_PORT_UHRDP   0x0B
#define IW_PORT_UI2XCR  0x0C
#define IW_PORT_U2XCR   0x0D
#define IW_PORT_U2XER   0x0E
#define IW_PORT_URCR    0x0F

// The following group of ports will need to have P3XR added to them before
// the I/O handlers can be installed                   
#define IW_PORT_SVSR    0x02
#define IW_PORT_IGIDXR  0x03
#define IW_PORT_I16DP   0x04
#define IW_PORT_I8DP    0x05

// The following PNP ports are fixed in these locations
#define IW_PORT_PCSNBR  0x0201
#define IW_PORT_PIDXR   0x0279
#define IW_PORT_PNPWRP  0x0A79
// The PNP read port is configured by a write to an indexed regiser
// #define IW_PORT_PNPRDP   003h - 03FFh
								 
// The following group of ports will need to have PCODAR added to them before
// the I/O handlers can be installed                   
#define IW_PORT_CIDXR   0
#define IW_PORT_CDATAP  1
#define IW_PORT_CSR1R   2
#define IW_PORT_CPDR    3

// The following are the indexes for the VxD API Services
#define IWAPI_GETVERSION               0
#define IWAPI_GETBUFFER                1
#define IWAPI_ACQUIREINTERWAVE         2
#define IWAPI_RELEASEINTERWAVE         3
#define IWAPI_REGISTERSBOSSUPPORT      4
#define IWAPI_SBOSFUNCTIONS            5
#define IWAPI_REGISTERDRIVERCALLBACK   6

// The following services are available only in versions after 3.0 of the VxD
#define IWAPI_GETRESOURCECONFIG        7    
#define IWAPI_READPORTBYTE	       8
#define IWAPI_WRITEPORTBYTE	       9

// The following service is available only in versions after 3.1 of the VxD
#define IWAPI_READDMACOUNT   10

// The InterWave_API_Register_SBOS_Support service registers with the VxD the functions
// to allocate a voice, free a voice, allocate memory and free memory.
// The InterWave_API_SBOS_Functions service is the entry point to the VxD that is called
// when the driver gets an interrupt generated by one of the voices owned by a VxD
// process.
 
// The following codes are used with the VxD API Services
// The acquire/release codes
#define IWAR_IRQ1	0x0001
#define IWAR_IRQ2	0x0002
#define IWAR_DMA1	0x0004
#define IWAR_DMA2	0x0008
#define IWAR_SOMEVOICES	0x0010	// voices, cooperatively
#define IWAR_ALLVOICES	0x0020	// voices, exclusively
#define IWAR_SOMEMEMORY	0x0040	// on-board memory, cooperatively
#define IWAR_ALLMEMORY	0x0080	// on-board memory, exclusively
#define IWAR_CODECPLAY	0x0100	// the CODEC's playback channel
#define IWAR_CODECREC	0x0200	// the CODEC's record channel
#define IWAR_CODECMIX	0x0400	// the CODEC mixer
#define IWAR_PORTIN	0x0800	// MIDI Input Port
#define IWAR_PORTOUT	0x1000	// MIDI Output Port
#define IWAR_VADLIB	0x2000  // Adlib emulation ports
#define IWAR_VSNDBLST	0x4000	// sound blaster emulation ports
#define IWAR_VMPU401	0x8000	// MPU-401 emulation ports

#define IWAR_SYNTH	0x00F0	// entire synth (voices and memory)
#define IWAR_IWSBOS     0x6150 	// synth (cooperatively) and codec playback
#define IWAR_CODEC	0x0700	// entire codec
#define IWAR_PORT	0x1800	// Input and output port
#define IWAR_ALL	0xFFFF	// All defined flags

#define IWAR_INTERWAV   0xFFFF  // all resources
#define IWAR_RECONFIG   0x00010000  // indicates dynamic reconfiguration 
#define IWAR_DIRECT	0x00020000  // requestor is a Direct Sound driver

#define IW_KERNEL_UNLOAD      0
#define IW_KERNEL_LOAD        1
#define IW_KERNEL_SLEEP       2
#define IW_KERNEL_WAKE        3
#define IW_KERNEL_CODEC_SLEEP 4
#define IW_KERNEL_CODEC_WAKE  5

#ifdef _MSC_VER
#pragma pack(1)

typedef struct INTERWAVEINFO_tag{
	unsigned long	iwi_dwSize;			// size of structure
	unsigned short	iwi_wVersion;    	// version of the VxD
	unsigned short	iwi_wFlags;      	// flags defined below
	unsigned char	iwi_bIRQ1;
	unsigned char	iwi_bIRQ2;
	unsigned char	iwi_bDMA1;
	unsigned char	iwi_bDMA2;
	unsigned short	iwi_wSynthBase2X;
	unsigned short	iwi_wSynthBase3X;
	unsigned short	iwi_wCodecBase;
	unsigned short	iwi_wCodecType;
	unsigned short	iwi_wMPUBase;
	unsigned char   iwi_bMPUIRQ;
	unsigned short	iwi_wAdlibBase;
	unsigned char	iwi_bSBIRQ;
	unsigned short	iwi_wGameBase;
	unsigned short	iwi_wCDBase;
	unsigned short	iwi_wATAPIBase;
	unsigned char	iwi_bCDIRQ;
	unsigned char	iwi_bCDDMA;
	unsigned short	iwi_wDMASelector;
	unsigned long	iwi_dwDMAPhysical;
	unsigned long	iwi_dwDMALinear;
	unsigned long	iwi_dwDMABufferSize;// buffer size in bytes
	unsigned long	iwi_dwSBOSOwner;
	unsigned char	iwi_bCodecIndex;
	unsigned char	iwi_bDeviceInit;	
	unsigned char	iwi_bPendingDriverOp;
        unsigned short  iwi_wDriverDS;
}INTERWAVEINFO;

#pragma pack()
#endif

#define IWI_FLAG_ONE_IRQ        0x01
#define IWI_FLAG_ONE_DMA        0x02
#define IWI_SBOS_ACTIVE		0x04

#define IWINFO_DEV0_INIT	1
#define IWINFO_DEV1_INIT	2
#define IWINFO_DEV2_INIT	4
#define IWINFO_DEV3_INIT	8
#define IWINFO_DEV4_INIT	16
#define IWINFO_DEVICE_ID_INIT	32
#define IWINFO_DEV_RECONFIG     64

                                                        
typedef struct IWRESOURCEINFO_tag{
	unsigned short	iwri_wStatus;            
	unsigned short	iwri_wAcqLevel;         // for DOS level tracking
	unsigned long	iwri_dwCurOwner;         
	unsigned long	iwri_dwPrevOwner;        
	unsigned long	iwri_dwResourceHandle;  // DMA handle, IRQ handle or Port 
						// table offset
	unsigned long	iwri_dwResourceID;      // DMA #, IRQ #, or lowport | hiport<<16
}IWRESOURCEINFO;


#define IWRIS_IRQ       0x0000
#define IWRIS_DMA       0x0001
#define IWRIS_PORTS     0x0002
#define IWRIS_OTHER     0x0003
#define IWRIS_TYPE      0x0003   // type mask
#define IWRIS_ACQUIRED  0x0004
#define IWRIS_2XR       0x0008   // must be adjusted by 2XR
#define IWRIS_3XR       0x0010   // must be adjusted by 3XR
#define IWRIS_CODAR     0x0020   // must be adjusted by CODAR
#define IWRIS_MPUR      0x0040   // must be adjusted by MPUR
#define IWRIS_DISABLED  0x0080   // indicates that resource install failed
#define IWRIS_DMA_DTRAN 0x0100   // indicates for a DMA resource that translation
				 // is disabled
#define IWRIS_MIX_ONLY  0x0100   // system VM owns mixer only
#define IWRIS_SBOS      0x0200   // this port range is owned by the owner of SBOS
                                                        
/* Codes to use with the InterWave_API_Get_Resource_Config call
*/

#define IWGRC_SYNTH_BASE_2X     1
#define IWGRC_SYNTH_BASE_3X     2
#define IWGRC_IRQ_1     3
#define IWGRC_IRQ_2     4
#define IWGRC_DMA_1     5
#define IWGRC_DMA_2     6
#define IWGRC_CODEC_BASE     7

#define IWGRC_CD_BASE     8
#define IWGRC_ATAPI_BASE     9
#define IWGRC_CD_IRQ     10
#define IWGRC_CD_DMA     11

#define IWGRC_GAME_BASE     12

#define IWGRC_ADLIB_BASE     13
#define IWGRC_SB_IRQ         14

#define IWGRC_MPU_BASE     15
#define IWGRC_MPU_IRQ     16


