/***************************************************************************
*   NAME:  WAVE.H $Revision: 1.8 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: wave.h $
* Revision 1.8  1995/11/10 15:00:36  sdsmith
* Changes for Win95 compatability
* Revision 1.7  1995/06/05 15:02:15  teckert
* Added Low-Priority input mode support
* Revision 1.6  1995/05/10 08:07:37  teckert
* New buffering support
* Revision 1.5  1995/03/30 16:40:50  teckert
* Updated arbitration support
* Revision 1.4  1995/03/17 13:22:55  teckert
* Removed GetDMA and FreeDMA
* Revision 1.3  1995/03/16 15:59:38  teckert
* Added hardware aquisition request handles to wave client structures
* Revision 1.2  1995/03/01 17:50:17  teckert
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/
#ifndef __WAVE_H
#define __WAVE_H

#define MAXCLIENTS      1
#define MAXPSEUDOHEADERS MAXCLIENTS*3                                  
#define WHDR_PSEUDOHEADER       0x80000000l
#define GF1BSIZE 16384          /* size of buffer per wav on GUS */
#define DMABUFFSIZE 16384       /* should be at least size of GF1BSIZE */

			
/**************************************************************************************
*                                                                                     *
*                               Wave Out Status Codes                                 *
*                                                                                    */
			 
#define WOS_WRAPPERPAUSED   0x0001
#define WOS_KERNELPAUSED    0x0002
#define WOS_KERNELPLAYING   0x0004  
#define WOS_UNDERRUN        0x0008  // next buffer needs to be sent directly to the Kernel
#define WOS_WFEOZIL         0x0010  // Waiting For End Of Zero-Iteration Loop
#define WOS_BREAKLOOP       0x0020
#define WOS_UNGOTBUFAVAIL   0x0040


/*************************************************************************************/                   

typedef struct WAVECLIENT_tag
	{    
	int                 nIndex;             // Index into ClientList array
	unsigned int        nStatus;
	int                 nLocks;             // Number of locks on playing queue
	int                 nDoneHeaders;       // Number of finished headers
	DWORD               dwCallback;         // client's callback
	DWORD               dwInstance;         // client's instance data
	DWORD               dwFlags;            // client's flags
	HANDLE              hWave;              // handle for stream
	WORD                wHWAH;              // hardware aquisition request handle
	DWORD               dwByteCount;        // byte count of full buffers sent since last DIG_DONE
	DWORD               dwBytesBeforeDone;  // byte count before last DIG_DONE
	LPWAVEHDR           lpQueue;            // the queue of buffers from client
	LPWAVEHDR           lpPlayNext;
	LPWAVEHDR           lpPlayLoopTop;
	DWORD               dwPlayLoopCount;
	LPWAVEHDR           lpDoneNext;
	LPWAVEHDR           lpUnGotBuf;
	DWORD               dwDoneLoopCount;
	DWORD		    dwBytesFromClient;
	DWORD               dwLastPosition;
	int                 nVoice;
	unsigned long       gfpBuffer;          // iw_buffer address
	DWORD               dwVolume;           // volume in LOWORD/HIWORD form
	WORD                wVolume;            // volume in Volume/Pan form
	int                 nPan;               //            "
	int                 nFrequency;         // frequency in hertz
	int                 nType;              // type for play_digital call
	int                 nUseCodec;
	}WAVECLIENT,FAR *LPWAVECLIENT;

extern LPWAVECLIENT ClientList[MAXCLIENTS + 1];
extern struct iw_dma_buff dma_buf_one;
extern struct iw_dma_buff dma_buf_two;
extern int nCodecVersion;
									  
/**************************************************************************************
*                                                                                     *
*                               Wave In Status Codes                                  *
*                                                                                    */

#define WIS_OPEN            0x0001
#define WIS_STOPPING        0x0002
#define WIS_OVERFLOW        0x0004
#define WIS_STARTED         0x0008
#define WIS_LOWPRIORITY     0x0010
#define WIS_LPSUSPENDED     0x0020
#define WIS_LPBYWAVEIN      0x0040
#define WIS_LPBYWAVEOUT     0x0080
#define WIS_LPSUSPENDING    0x0100

typedef struct WAVEINCLIENT_tag
	{    
	unsigned int        nStatus;
	DWORD               dwCallback;         // client's callback
	DWORD               dwInstance;         // client's instance data
	DWORD               dwFlags;            // client's flags
	HANDLE              hWave;              // handle for stream
	WORD                wHWAH;              // hardware aquisition request handle
	LPWAVEHDR           lpBufferQueue;      // the queue of buffers from client
	LPWAVEHDR           lpRecording;        // buffer waiting for the DIG_BUFFER_DONE msg
	LPWAVEHDR           lpHoldBuf;          // buffer waiting for the DIG_DONE msg
	DWORD               dwByteCount;        // byte count of full buffers sent since last DIG_DONE
	DWORD               dwBytesFromBefore;  // byte count before last DIG_DONE
	DWORD		    dwBytesFromClient;
	DWORD               dwLastPosition;
	int                 nVoice;
	int                 nFrequency;         // frequency in hertz
	int                 nType;              // type for play_digital call
	}WAVEINCLIENT,FAR *LPWAVEINCLIENT;

extern WAVEINCLIENT RecordClientOne,RecordClientTwo;

/*  Note on use of nLocks and nDoneHeaders semaphores
 *
 *  nLocks is a count of locks on the playing queue it is initialized to zero and is
 *  incremented for each entry into the ReturnBuffers function and in the AddToPlayingQueue
 *  function nDoneHeaders keeps track of how many buffers were returned from the kernel
 *  while nLocks was greater than zero
 */
 
/**************************************************************************************
*                                                                                     *
*                               Function Prototypes                                   *
*                                                                                    */
		
/*                              Play Functions                                       */        
void FAR PASCAL waveCallback(LPWAVECLIENT pClient, WORD msg, DWORD dw1);
DWORD FAR PASCAL wodOpen(LPWAVEOPENDESC lpDesc, DWORD dwFlags, int far *pnClient, int nCodec);
DWORD FAR PASCAL wodClose(LPWAVECLIENT pClient);
DWORD FAR PASCAL wodWrite(LPWAVECLIENT pClient, LPWAVEHDR lpHdr);
DWORD FAR PASCAL wodPause(LPWAVECLIENT pClient);
DWORD FAR PASCAL wodRestart(LPWAVECLIENT pClient);
DWORD FAR PASCAL wodReset(LPWAVECLIENT pClient);
DWORD FAR PASCAL wodGetPos(LPWAVECLIENT pClient, LPMMTIME lpMMT, WORD wSize);
void FAR PASCAL wodSetVolume(LPWAVECLIENT pClient);
void FAR PASCAL SendBuffers(LPWAVECLIENT pClient);
void FAR PASCAL AddToQueue(LPWAVECLIENT pClient, LPWAVEHDR lpHdr);
#define NextPlayPointer(a) (((a)->nStatus&WOS_UNGOTBUFAVAIL)?(a)->lpUnGotBuf:(a)->lpPlayNext)
void FAR PASCAL AdvancePlayPointer(LPWAVECLIENT pClient);
void FAR PASCAL CheckPlayLoop(LPWAVECLIENT pClient);
#define NextDonePointer(a) (((a)->dwDoneLoopCount > 1)?((a)->lpDoneNext):((a)->lpQueue))
int FAR PASCAL AdvanceDonePointer(LPWAVECLIENT pClient);
void FAR PASCAL CheckDoneLoop(LPWAVECLIENT pClient);
void FAR PASCAL ReturnHeader(LPWAVEHDR lpHdr);
void FAR PASCAL ReturnBuffers(LPWAVECLIENT pClient, int nCount);
LPWAVECLIENT GetClient(int nVoice);

/*                              Record Functions                                     */
void FAR PASCAL waveInCallback(LPWAVEINCLIENT pClient, WORD msg, DWORD dw1);
DWORD FAR PASCAL widOpen(LPWAVEOPENDESC lpDesc, DWORD dwFlags, LPDWORD lpUser);
DWORD FAR PASCAL widClose(LPWAVEINCLIENT pClient);
DWORD FAR PASCAL widAddBuffer(LPWAVEINCLIENT pClient, LPWAVEHDR lpHdr);
DWORD FAR PASCAL widStart(LPWAVEINCLIENT pClient);
DWORD FAR PASCAL widStop(LPWAVEINCLIENT pClient);
DWORD FAR PASCAL widReset(LPWAVEINCLIENT pClient);
DWORD FAR PASCAL widGetPos(LPWAVEINCLIENT pClient, LPMMTIME lpMMT, WORD wSize);
LPWAVEHDR FAR PASCAL GetNextRecordBuffer(LPWAVEINCLIENT pClient);
void FAR PASCAL ReturnRecordBuffer(LPWAVEINCLIENT pClient, LPWAVEHDR lpHdr);

#endif // __WAVE_H
