//*****************************************************************************
//* Name:
//*      1212AppyTime.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains private declarations for the implementation of the
//*      Korg1212 VxD to Wave Device Driver interface using AppyTime events and
//*      callbacks.
//*
//* Modification Log:
//*
//*      1.5   08/04/97 Bill
//*      (v 1.0B5) Added K1212_ISRDMA_ERROR to K1212BufReturnRequests.
//*
//*      1.4   06/26/97 Bill
//*      (v 1.0B3) Added waveType member to the buffers.  Used so we can
//*      have a single VM event handler function for both wave types.
//*
//*      1.3   06/18/97 Bill
//*      (v 1.11) Added delayCount member to the buffers.  Used to delay the
//*      return of buffers due to prefill/getPosition conflicts.
//*
//*      1.2   06/16/97 Bill
//*      (v 1.09) These buffers are now used for priority VM events instead of
//*      appytime events.
//*
//*      1.1   03/19/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212APPYTIME_H
#define K1212APPYTIME_H

#define NUM_WAVE_RETURN_ELEMENTS 200

   // ------------------------------------------------------------------------
   // The following struct is used by the VxD to make calls to the wave device
   // driver in ring 3.  (reverse order for pascal calling convention)
   // v1.09 of VxD - no longer needed but kept here for future need
   // ------------------------------------------------------------------------
typedef struct k1212BufReturnParams {
   LPVOID       lpRequestParams;       // points to a wave header for returning wave buffers,
                                       //    or to an allocated buffer for other requests
                                       //    requiring more than one parameter.
   LPVOID       lpClient;              // points to the client handle - may also be used
                                       //    for other purposes for requests that do not
                                       //    require a client handle.
   DWORD        request;               // indicates what we want of the wave
                                       //    device driver.  See K1212BufReturnRequests.
} k1212BufReturnParams;


   // ------------------------------------------------------------------------
   // The following enum defines the requests the VxD makes to the wave driver
   // ------------------------------------------------------------------------
typedef enum {
   K1212_RETURN_WAVEINBUF = 0,
   K1212_RETURN_WAVEOUTBUF,
   K1212_ISRDMA_ERROR
} K1212BufReturnRequests;


   // ------------------------------------------------------------------------
   // The following struct is used to pass information required to call the
   // wave device driver's callback function to return a wave input buffer 
   // to it.
   // ------------------------------------------------------------------------
typedef struct WaveInBufReturnInfo {
   DWORD       ring3CallbackAddress;
   LPWAVEHDR   waveHeaderPtr;
   LPVOID      lpClient;
   BOOL        inUse;
} WaveInBufReturnInfo;

WaveInBufReturnInfo* AllocWaveInRetInfo(void); 
void                 FreeWaveInRetInfo (WaveInBufReturnInfo* bufPtr);


   // ------------------------------------------------------------------------
   // The following struct is used to pass information required to call the
   // wave device driver's callback function to return a wave input buffer 
   // to it.
   // ------------------------------------------------------------------------
typedef struct WaveOutBufReturnInfo {
   DWORD       ring3CallbackAddress;
   LPWAVEHDR   waveHeaderPtr;
   LPVOID      lpClient;
   BOOL        inUse;
   DWORD       delayCount;
} WaveOutBufReturnInfo;

WaveOutBufReturnInfo* AllocWaveOutRetInfo(void); 
void                  FreeWaveOutRetInfo (WaveOutBufReturnInfo* bufPtr);


   // ------------------------------------------------------------------------
   // (v1.11) these structures moved to the header file, so that the next
   // pointer can double in use for the linked list of buffers to be returned.
   // ------------------------------------------------------------------------
typedef struct K1212MemWaveInRet {
   struct K1212MemWaveInRet*  next;
   WaveInBufReturnInfo        buffer;
} K1212MemWaveInRet;

typedef struct K1212MemWaveOutRet {
   struct K1212MemWaveOutRet* next;
   WaveOutBufReturnInfo       buffer;
} K1212MemWaveOutRet;




#endif // K1212APPYTIME_H
