//*****************************************************************************
//* Name:
//*      1212WaveApi.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains private declarations for the implementation of the
//*      Win16 application to Korg1212 VxD interface.
//*
//* Modification Log:
//*
//*      1.4   06/09/97 Bill
//*      (v1.08) Added K1212PM_BREAKLOOP.  
//*
//*      1.3   06/04/97 Bill
//*      (v1.06) Changed k1212WaveOutVol structure to now contain left and
//*      right volume levels instead of channel and one volume.  
//*
//*      1.2   06/03/97 Bill
//*      (v1.05) Added K1212PM_POSTMSG_TO_FILE for debugging.  
//*
//*      1.1   03/13/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212WAVEAPI_H
#define K1212WAVEAPI_H

#ifndef  K1212API_H
#include "1212api.h"
#endif
#ifndef  K1212APIP_H
#include "1212apip.h"
#endif
#ifndef  K1212WAVDEFS_H
#include "1212WavDefs.h"
#endif


// ----------------------------------------------------------------------------
// For 16 bit applications, communication with the Korg1212 driver occurs via
// a function whose address is determined by the int 2Fh, function 1684h
// interface.  
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Services exported by the Korg1212 VxD to Win16 applications.  The following
// constants represent the function codes to be passed in the functionCode of
// the k1212PmReq structure.  Each function code is individually commented.
// Input and output parameter specifications refer to structures defined later 
// in this file.
// ----------------------------------------------------------------------------
typedef enum {
   K1212_PM_BASE = 4200,             // 42 is the answer

      // ----------------------------------------------------------------------
      // K1212PM_GET_VERSION - This function returns the version of the VxD in  
      // the version field.  The MSB contains the major version, the LSB 
      // contains the minor version.
      // ----------------------------------------------------------------------
   K1212PM_GET_VERSION,

      // ----------------------------------------------------------------------
      // K1212PM_REGISTER_API - This function registers the API with the driver.
      // ----------------------------------------------------------------------
   K1212PM_REGISTER_API,  

      // ----------------------------------------------------------------------
      // K1212PM_GET_CARD_INFO - This function fills the output buffer with the 
      // k1212CardInfo structure.
      // ----------------------------------------------------------------------
   K1212PM_GET_CARD_INFO,  

      // ----------------------------------------------------------------------
      // K1212PM_ENABLE_WAVEOUTDEVS - This function gives the calling application 
      // exclusive rights to use the specified wave output device.
      // ----------------------------------------------------------------------
   K1212PM_ENABLE_WAVEOUTDEVS,

      // ----------------------------------------------------------------------
      // K1212PM_ENABLE_WAVEINDEVS - This function gives the calling application 
      // exclusive rights to use the specified wave input device.
      // ----------------------------------------------------------------------
   K1212PM_ENABLE_WAVEINDEVS,

      // ----------------------------------------------------------------------
      // K1212PM_DISABLE_WAVEOUTDEVS - This function notifies the driver that 
      // the application is relinquishing control of the wave output device.  
      // ----------------------------------------------------------------------
   K1212PM_DISABLE_WAVEOUTDEVS,

      // ----------------------------------------------------------------------
      // K1212PM_DISABLE_WAVEINDEVS - This function notifies the driver that 
      // the application is relinquishing control of the wave input device.  
      // ----------------------------------------------------------------------
   K1212PM_DISABLE_WAVEINDEVS,

      // ----------------------------------------------------------------------
      // K1212PM_OPEN_WAVEOUTDEV - This function gives the calling application 
      // exclusive rights to use the specified wave output device.
      // ----------------------------------------------------------------------
   K1212PM_OPEN_WAVEOUTDEV,

      // ----------------------------------------------------------------------
      // K1212PM_OPEN_WAVEINDEV - This function gives the calling application 
      // exclusive rights to use the specified wave input device.
      // ----------------------------------------------------------------------
   K1212PM_OPEN_WAVEINDEV,

      // ----------------------------------------------------------------------
      // K1212PM_CLOSE_WAVEOUTDEV - This function notifies the driver that the 
      // application is relinquishing control of the wave output device.  
      // ----------------------------------------------------------------------
   K1212PM_CLOSE_WAVEOUTDEV,

      // ----------------------------------------------------------------------
      // K1212PM_CLOSE_WAVEINDEV - This function notifies the driver that the 
      // application is relinquishing control of the wave input device.  
      // ----------------------------------------------------------------------
   K1212PM_CLOSE_WAVEINDEV,

      // ----------------------------------------------------------------------
      // K1212PM_CLOSE_API - This function notifies the driver that the 
      // application is closing communications with the driver.  The card is
      // forced closed if it has been opened by this API object.
      // ----------------------------------------------------------------------
   K1212PM_CLOSE_API,

      // ----------------------------------------------------------------------
      // K1212PM_SET_CLOCK_SOURCE_RATE - This function sets the sample rate and
      // source clock on the card.  See ClockSourceSelector enum for the list
      // of possible values.
      // ----------------------------------------------------------------------
   K1212PM_SET_CLOCK_SOURCE_RATE,

      // ----------------------------------------------------------------------
      // K1212PM_GET_CLOCK_SOURCE_RATE - This function returns the current values
      // for the sample rate and source clock on the card.  The same enum -
      // ClockSourceSelector is used to specify the values.
      // ----------------------------------------------------------------------
   K1212PM_GET_CLOCK_SOURCE_RATE,

      // ----------------------------------------------------------------------
      // K1212PM_SET_INPUT_SENSITIVITY - Sets the input sensitivity to the ADC
      // channels (there are two - L/R).  The sensitivity for both channels
      // is specified and sent to the card.  A low value reduces the amount
      // of signal to the ADC.  The highest value corresponds to unity gain?
      // ----------------------------------------------------------------------
   K1212PM_SET_INPUT_SENSITIVITY,

      // ----------------------------------------------------------------------
      // K1212PM_GET_INPUT_SENSITIVITY - This returns the current sensitivity
      // values for the L/R inputs to the ADC on the card.
      // ----------------------------------------------------------------------
   K1212PM_GET_INPUT_SENSITIVITY,

      // ----------------------------------------------------------------------
      // K1212PM_GET_RECORD_PLAY_LATENCY - Returns a value that indicates the
      // number of frames of record to playback latency.  This is a fixed
      // value based on buffer size.
      // ----------------------------------------------------------------------
   K1212PM_GET_RECORD_PLAY_LATENCY,

      // ----------------------------------------------------------------------
      // K1212PM_CHECK_INPUT_FORMAT - This checks whether the specified format
      // is supported by the recording device.
      // ----------------------------------------------------------------------
   K1212PM_CHECK_INPUT_FORMAT,

      // ----------------------------------------------------------------------
      // K1212PM_CHECK_OUTPUT_FORMAT - This checks whether the specified format
      // is supported by the playback device.
      // ----------------------------------------------------------------------
   K1212PM_CHECK_OUTPUT_FORMAT,

      // ----------------------------------------------------------------------
      // K1212PM_ADD_RECORD_BUFFER - This adds the passed in wave buffer into
      // the record buffer queue.
      // ----------------------------------------------------------------------
   K1212PM_ADD_RECORD_BUFFER,

      // ----------------------------------------------------------------------
      // K1212PM_ADD_PLAY_BUFFER - This adds the passed in wave buffer into
      // the playback buffer queue.
      // ----------------------------------------------------------------------
   K1212PM_ADD_PLAY_BUFFER,

      // ----------------------------------------------------------------------
      // K1212PM_START_WAVEIN_DEV - This starts the card in play mode if it 
      // isn't already -> only applies to input devices
      // ----------------------------------------------------------------------
   K1212PM_START_WAVEIN_DEV,

      // ----------------------------------------------------------------------
      // K1212PM_STOP_WAVEIN_DEV - This stops the card from play mode if it 
      // isn't already stopped -> only applies to input devices
      // ----------------------------------------------------------------------
   K1212PM_STOP_WAVEIN_DEV,

      // ----------------------------------------------------------------------
      // K1212PM_PAUSE_WAVE_DEV - This pauses playback for the specified wave
      // output device.
      // ----------------------------------------------------------------------
   K1212PM_PAUSE_WAVEOUT_DEV,

      // ----------------------------------------------------------------------
      // K1212PM_RESUME_WAVE_DEV - This resumes playback for the specified wave
      // output device if it has been paused.
      // ----------------------------------------------------------------------
   K1212PM_RESUME_WAVEOUT_DEV,

      // ----------------------------------------------------------------------
      // K1212PM_RESET_WAVE_DEV - This stops playback/record for the specified
      // wave device and returns all queued buffers to their application.
      // ----------------------------------------------------------------------
   K1212PM_RESET_WAVE_DEV,

      // ----------------------------------------------------------------------
      // K1212PM_SET_MASTER_VOLUME - This sets the master volume level for all 
      // of the wave output devices on a card.
      // ----------------------------------------------------------------------
   K1212PM_SET_MASTER_VOLUME,

      // ----------------------------------------------------------------------
      // K1212PM_SET_WAVEDEV_VOLUME - This sets the volume levels for the 
      // specified wave output device.  Each device has one volume level, and
      // a pan control.
      // ----------------------------------------------------------------------
   K1212PM_SET_WAVEOUT_VOLUME,

      // ----------------------------------------------------------------------
      // K1212PM_MUTE_WAVEOUT_DEVICE - This sets the volume levels for the 
      // specified wave output device to zero.
      // ----------------------------------------------------------------------
   K1212PM_MUTE_WAVEOUT_DEVICE,

      // ----------------------------------------------------------------------
      // K1212PM_QUERY_WAVEOUT_DEVICE_MUTE - This indicates whether the 
      // specified wave output device has been muted.
      // ----------------------------------------------------------------------
   K1212PM_QUERY_WAVEOUT_DEVICE_MUTE,

      // ----------------------------------------------------------------------
      // K1212PM_MUTE_WAVEOUT_DEVICE - This restores the volume levels for the 
      // specified wave output device.
      // ----------------------------------------------------------------------
   K1212PM_UNMUTE_WAVEOUT_DEVICE,

      // ----------------------------------------------------------------------
      // K1212PM_GET_MASTER_VOLUME - This retrieves the master volume level for 
      // all of the wave output devices on a card.
      // ----------------------------------------------------------------------
   K1212PM_GET_MASTER_VOLUME,

      // ----------------------------------------------------------------------
      // K1212PM_GET_WAVEDEV_VOLUME - This retrieves the volume level for the 
      // specified wave output device.
      // ----------------------------------------------------------------------
   K1212PM_GET_WAVEOUT_VOLUME,

      // ----------------------------------------------------------------------
      // K1212PM_GET_WAVE_POSITION - This retrieves the current position in the
      // record or playback stream.  (The units of position reported are as
      // specified in the MMTIME structure.)
      // ----------------------------------------------------------------------
   K1212PM_GET_WAVE_POSITION,

      // ----------------------------------------------------------------------
      // K1212PM_GET_WAVEIN_STATE - This retrieves the current state of the 
      // wave input device.
      // ----------------------------------------------------------------------
   K1212PM_GET_WAVEIN_STATE,

      // ----------------------------------------------------------------------
      // K1212PM_GET_WAVEOUT_STATE - This retrieves the current state of the 
      // wave output device.
      // ----------------------------------------------------------------------
   K1212PM_GET_WAVEOUT_STATE,

      // ----------------------------------------------------------------------
      // K1212PM_POSTMSG_TO_FILE - This function posts a message to a file. (v1.05)
      // ----------------------------------------------------------------------
   K1212PM_POSTMSG_TO_FILE,

      // ----------------------------------------------------------------------
      // K1212PM_BREAKLOOP - This function requests the wave output device to
      // break out of the loop it is currently in (if it is in a loop). (v1.08)
      // ----------------------------------------------------------------------
   K1212PM_BREAKLOOP

} k1212PMFunctionCodes;

typedef enum {
   K1212_WAVE_LEFT = 0,
   K1212_WAVE_RIGHT
} waveDeviceChannelIds;


// ------------------------------------------------------------------------
// Protected Mode interface specific structures
// ------------------------------------------------------------------------

   // ------------------------------------------------------------------------
   // The following struct is used for returning information when a 16 bit 
   // application registers with the API.
   // ------------------------------------------------------------------------
typedef struct k1212APIInfoPM { 
   WORD   apiHandle;
   WORD   sharedBufferCount;
} k1212APIInfoPM;


   // ---------------------------------------------------------------------------
   // The following struct is used for setting and retrieving wave device
   // volumes.  The channel specifies whether it's right or left for the device.
   // ---------------------------------------------------------------------------
typedef struct k1212WaveOutVol { 
   WORD   leftVolume;         // v1.06 channel is now left volume
   WORD   rightVolume;        // v1.06 volume is now right volume
} k1212WaveOutVol;


   // ------------------------------------------------------------------------
   // The following struct is used for assigning specific fields in the input
   // buffer of the protected mode call to the driver.
   // ------------------------------------------------------------------------
typedef struct k1212PMIn {
   WORD         apiHandle;                // which API object is making the call.  This is
                                          //    only used for open card and close driver calls. 
   WORD         cardIndex;                // index of the card - used for calls specific
                                          //    to a particular card
   WORD         deviceID;                 // indicates which wave device.
   WORD         deviceType;               // indicates whether the device is wave input or output
                                          //    (see K1212WaveDeviceType)
   DWORD        devHandle;                // this must be filled in for calls that require
                                          //    the caller to have exclusive access to the device
                                          //    This field will contain the dwUser field from the
                                          //    wave device driver, which it uses to identify its
                                          //    clients.
   union {
      k1212DeviceOpenData    devOpenData;   // used by OpenWaveDevice
      k1212WaveFormatData    waveFormatData;// used by VerifyWaveFormat
      k1212WaveBufferInfo    waveBufferInfo;// used by AddWaveInBuffer, AddWaveOutBuffer
      DWORD                  mmTimeFormat;  // used by GetWavePosition
      WORD                   clkSrcIdx;     // used by SetClockSourceRate
      k1212LeftRight         lrVals;        // used by SetInputSensitivity
      k1212ChanVolume        chanVol;       // used by SetChannelVolume
      k1212ChanRoute         chanRte;       // used by SetChannelRoute
      WORD                   channel;       // used by GetChannelVolume, GetWaveVolume,
                                            //  and GetChannelRoute
      WORD                   wValue;        // generic word value
      k1212WaveOutVol        waveVol;       // used by SetWaveVolume(x)
      char                   string[40];    // used by post message to file (v1.05)
   };
} k1212PMIn;

   // ------------------------------------------------------------------------
   // The following struct is used for obtaining specific fields in the output
   // buffer of the DeviceIoControl call to the driver.
   // ------------------------------------------------------------------------
typedef struct k1212PMOut {
   WORD returnValue;
   union {
      k1212APIInfoPM       apiInfo;                   // used by RegisterApi
      WORD                 version;                   // used by GetVersion
      DWORD                cardHandle;                // used by OpenCard
      DWORD                deviceState;               // used by GetDeviceState
      WORD                 wValue;                    // used by GetDeviceVolume(x)
      k1212CardInfoPM      cardInfo;                  // used by GetCardInfo
      WORD                 curClkSrc;                 // used by GetClockSourceRate
      WORD                 bufferCount;               // used by GetBufferCount,
      k1212LeftRight       lrVals;                    // used by GetInputSensitivity, GetWaveOutVolume
      WORD                 recPlyLatency;             // used by GetRecordPlayLatency
      k1212ChanVolume      chanVol;                   // used by GetChannelVolume 
      k1212ChanRoute       chanRte;                   // used by GetChannelRoute
      k1212MMTimeData      mmTimeData;                // used by GetWavePosition
   };
} k1212PMOut;


   // ------------------------------------------------------------------------
   // The following struct is used by 16 bit applications going through the
   // PM interface to the driver.
   // ------------------------------------------------------------------------
typedef struct k1212PmReq {
   WORD         functionCode;
   WORD         inBufSize;
   WORD         outBufSize;
   WORD         bytesReturned;
   k1212PMIn    inBuf;
   k1212PMOut   outBuf;
} k1212PmReq;



#endif // K1212WAVEAPI_H
