//*****************************************************************************
//* Name:
//*      1212apip.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains private declarations for the implementation of the
//*      Win32 application to Korg1212 Vxd interface.
//*
//* Modification Log:
//*
//*      1.6   08/28/97 Bill
//*      (v1.0B7) Added K1212_GET_CARD_DEBUG_INFO and K1212_CLEAR_API.  
//*
//*      1.5   08/20/97 Bill
//*      (v1.0B6) Added K1212_GET_AUTO_WAVE_SYNC and related enum values for
//*      auto wave device sync mode support.  
//*
//*      1.4   07/15/97 Bill
//*      (v1.0B4) Added K1212_GET_ADAT_TIMECODE.  
//*
//*      1.3   06/04/97 Bill
//*      (v1.06) Added K1212_REGISTER_FOR_WAVE_VOLUPDATES so that the wave control
//*      application can receive updates that occur via the wave device driver 
//*      interface.  This functionality is intended only for the wave control
//*      application, and should not be made accessible to other applications.
//*
//*      1.2   12/27/96 Bill
//*      Modified to support multiple cards.  
//*
//*      1.1   12/04/96 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212APIP_H
#define K1212APIP_H

#ifndef  K1212API_H
#include "1212api.h"
#endif


// ----------------------------------------------------------------------------
// For 32 bit applications, communication with the Korg1212 driver occurs via
// the DeviceIoControl() procedure.  Use CreateFile() to get a handle for the
// driver (named \\.\Korg1212) and then use DeviceIoControl() to request 
// services from the driver.
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Services exported by the Korg1212 VxD to Win32 applications.  The following
// constants represent the function codes to be passed in the dwIoControlCode
// parameter of the DeviceIoControl() call.  Each function code is individually
// commented.  Input and output parameter specifications refer to structures
// defined later in this file.
// ----------------------------------------------------------------------------
typedef enum {
   K1212_DIOC_BASE = 4200,             // 42 is the answer

      // ----------------------------------------------------------------------
      // K1212_GET_VERSION - This function returns the version of the VxD in  
      // the version field.  The MSB contains the major version, the LSB 
      // contains the minor version.
      // ----------------------------------------------------------------------
   K1212_GET_VERSION,

      // ----------------------------------------------------------------------
      // K1212_REGISTER_API - This function registers the API with the driver.
      // ----------------------------------------------------------------------
   K1212_REGISTER_API,  

      // ----------------------------------------------------------------------
      // K1212_GET_CARD_INFO - This function fills the output buffer with the 
      // k1212CardInfo structure.
      // ----------------------------------------------------------------------
   K1212_GET_CARD_INFO,  

      // ----------------------------------------------------------------------
      // K1212_WRITE_CARD - This function is provided for debugging purposes.
      // ----------------------------------------------------------------------
   K1212_WRITE_CARD,

      // ----------------------------------------------------------------------
      // K1212_READ_CARD - This function is provided for debugging purposes.
      // ----------------------------------------------------------------------
   K1212_READ_CARD,

      // ----------------------------------------------------------------------
      // K1212_PRINT_DEBUG_INFO - This function is provided for debugging.
      // ----------------------------------------------------------------------
   K1212_PRINT_DEBUG_INFO,

      // ----------------------------------------------------------------------
      // K1212_OPEN_CARD - This function gives the calling application 
      // exclusive rights to use the card.  A handle is returned in the output 
      // buffer.  This handle must be used in all calls that use the card.
      // ----------------------------------------------------------------------
   K1212_OPEN_CARD,

      // ----------------------------------------------------------------------
      // K1212_SET_FILL_ROUTINE - This function registers the fill routine
      // with the driver.  The routine is called via an APC when the card
      // interrupts the driver with a request for more data.
      // ----------------------------------------------------------------------
   K1212_SET_FILL_ROUTINE,

      // ----------------------------------------------------------------------
      // K1212_CLEAR_FILL_ROUTINE - This function de-registers the fill routine
      // with the driver.  
      // ----------------------------------------------------------------------
   K1212_CLEAR_FILL_ROUTINE,

      // ----------------------------------------------------------------------
      // K1212_CLOSE_CARD - This function notifies the driver that the 
      // application is relinquishing control of the card.  The card handle
      // must be provided in the input buffer.
      // ----------------------------------------------------------------------
   K1212_CLOSE_CARD,

      // ----------------------------------------------------------------------
      // K1212_CLOSE_DRIVER - This function notifies the driver that the 
      // application is closing communications with the driver.  The card is
      // forced closed.
      // ----------------------------------------------------------------------
   K1212_CLOSE_API,

      // ----------------------------------------------------------------------
      // K1212_GET_PACKET_SIZE - This function returns the number of samples
      // in a packet.
      // ----------------------------------------------------------------------
   K1212_GET_PACKET_SIZE,

      // ----------------------------------------------------------------------
      // K1212_GET_NUMBER_OF_BUFFERS - This function returns the number of
      // k1212AudioBuffers the card is using.
      // ----------------------------------------------------------------------
   K1212_GET_NUMBER_OF_BUFFERS,

      // ----------------------------------------------------------------------
      // K1212_GET_SAMPLE_SIZE - This function returns the number of bits in
      // a sample.
      // ----------------------------------------------------------------------
   K1212_GET_SAMPLE_SIZE,

      // ----------------------------------------------------------------------
      // K1212_SET_CLOCK_SOURCE_RATE - This function sets the sample rate and
      // source clock on the card.  See ClockSourceSelector enum for the list
      // of possible values.
      // ----------------------------------------------------------------------
   K1212_SET_CLOCK_SOURCE_RATE,

      // ----------------------------------------------------------------------
      // K1212_GET_CLOCK_SOURCE_RATE - This function returns the current values
      // for the sample rate and source clock on the card.  The same enum -
      // ClockSourceSelector is used to specify the values.
      // ----------------------------------------------------------------------
   K1212_GET_CLOCK_SOURCE_RATE,

      // ----------------------------------------------------------------------
      // K1212_GET_PLAY_CHANNEL_COUNT - Returns the number of playback channels
      // on the card.
      // ----------------------------------------------------------------------
   K1212_GET_PLAY_CHANNEL_COUNT,

      // ----------------------------------------------------------------------
      // K1212_GET_RECORD_CHANNEL_COUNT - Returns the number of record channels
      // on the card.
      // ----------------------------------------------------------------------
   K1212_GET_RECORD_CHANNEL_COUNT,

      // ----------------------------------------------------------------------
      // K1212_SET_INPUT_SENSITIVITY - Sets the input sensitivity to the ADC
      // channels (there are two - L/R).  The sensitivity for both channels
      // is specified and sent to the card.  A low value reduces the amount
      // of signal to the ADC.  The highest value corresponds to unity gain?
      // ----------------------------------------------------------------------
   K1212_SET_INPUT_SENSITIVITY,

      // ----------------------------------------------------------------------
      // K1212_GET_CHANNEL_VOLUME - Gets the volume level for the specified
      // channel.  This function can be used in place of direct reads from the
      // shared buffer.
      // ----------------------------------------------------------------------
   K1212_GET_CHANNEL_VOLUME,

      // ----------------------------------------------------------------------
      // K1212_SET_CHANNEL_VOLUME - Sets the volume level for the specified
      // channel.  This function can be used in place of direct writes to the
      // shared buffer.
      // ----------------------------------------------------------------------
   K1212_SET_CHANNEL_VOLUME,

      // ----------------------------------------------------------------------
      // K1212_GET_CHANNEL_ROUTE - Gets the routing for the specified
      // channel.  This function can be used in place of direct reads from the
      // shared buffer.
      // ----------------------------------------------------------------------
   K1212_GET_CHANNEL_ROUTE,

      // ----------------------------------------------------------------------
      // K1212_SET_CHANNEL_ROUTE - Sets the routing for the specified
      // channel.  This function can be used in place of direct writes to the
      // shared buffer.
      // ----------------------------------------------------------------------
   K1212_SET_CHANNEL_ROUTE,

      // ----------------------------------------------------------------------
      // K1212_GET_INPUT_SENSITIVITY - This returns the current sensitivity
      // values for the L/R inputs to the ADC on the card.
      // ----------------------------------------------------------------------
   K1212_GET_INPUT_SENSITIVITY,

      // ----------------------------------------------------------------------
      // K1212_GET_PLAY_BUFFER_ADDRESSES - Returns the addresses of the A and
      // B playback buffers.  These buffers are structured as KorgAudioBuffer's.
      // ----------------------------------------------------------------------
   K1212_GET_PLAY_BUFFER_ADDRESSES,

      // ----------------------------------------------------------------------
      // K1212_GET_RECORD_BUFFER_ADDRESSES - Returns the addresses of the A and
      // B record buffers.  These buffers are structured identically to the
      // playback buffers.
      // ----------------------------------------------------------------------
   K1212_GET_RECORD_BUFFER_ADDRESSES,

      // ----------------------------------------------------------------------
      // K1212_GET_CHANNEL_VOLUME_BUFFER_ADDRESS - Returns the address of the
      // channel volume buffers.  This buffer controls the volume of each
      // channel on the card.  The buffer is structured as an array of WORDs.
      // ----------------------------------------------------------------------
   K1212_GET_CHANNEL_VOLUME_BUFFER_ADDRESS,

      // ----------------------------------------------------------------------
      // K1212_GET_CHANNEL_ROUTING_BUFFER_ADDRESS - Returns the address of the
      // channel routing buffer.  This buffer contains the routing information
      // (sources) for all playback channels on the card.
      // ----------------------------------------------------------------------
   K1212_GET_CHANNEL_ROUTING_BUFFER_ADDRESS,

      // ----------------------------------------------------------------------
      // K1212_GET_ADAT_TIMECODE_ADDRESS - Returns the address of the ADAT
      // timecode register.  This register contains the current timecode value.
      // ----------------------------------------------------------------------
   K1212_GET_ADAT_TIMECODE_ADDRESS,

      // ----------------------------------------------------------------------
      // K1212_SETUP_FOR_PLAY - This call notifies the driver to do any
      // preparation required prior to triggering playback.  This call should
      // be made *AFTER* the playback buffers have been initialized with data.
      // ----------------------------------------------------------------------
   K1212_SETUP_FOR_PLAY,

      // ----------------------------------------------------------------------
      // K1212_TRIGGER_PLAY - This call immediately triggers playback on the
      // card.  This call should be made after the setup for play call.
      // ----------------------------------------------------------------------
   K1212_TRIGGER_PLAY,

      // ----------------------------------------------------------------------
      // K1212_TRIGGER_PLAY_FROM_ADAT - same as trigger play except that the
      // card waits for a specific ADAT timecode value.  The ADAT stop mode is
      // specified in this call as well.
      // ----------------------------------------------------------------------
   K1212_TRIGGER_PLAY_FROM_ADAT,

      // ----------------------------------------------------------------------
      // K1212_STOP_PLAY - This function stops playback or monitor-only mode.
      // ----------------------------------------------------------------------
   K1212_STOP_PLAY,

      // ----------------------------------------------------------------------
      // K1212_SET_MONITOR_MODE - This function sets the monitor mode to either
      // on or off.
      // ----------------------------------------------------------------------
   K1212_SET_MONITOR_MODE,

      // ----------------------------------------------------------------------
      // K1212_GET_RECORD_PLAY_LATENCY - Returns a value that indicates the
      // number of frames of record to playback latency.  This is a fixed
      // value based on buffer size.
      // ----------------------------------------------------------------------
   K1212_GET_RECORD_PLAY_LATENCY,

      // ----------------------------------------------------------------------
      // K1212_REBOOT_CARD - This function requests that the driver reboot the
      // card.  This is an abrupt reboot that is not friendly to others that
      // may be using the card at the time it is issued.
      // ----------------------------------------------------------------------
   K1212_REBOOT_CARD,
   
      // ----------------------------------------------------------------------
      // K1212_SET_WAVE_VOLUME - This function sets the current wave volume 
      // level.  values range from 0 (min) to 0xffff (max)
      // ----------------------------------------------------------------------
   K1212_SET_WAVE_VOLUME,

      // ----------------------------------------------------------------------
      // K1212_GET_WAVE_VOLUME - This function requests the current
      // setting of the wave volume control.  values range from 0 to 0xffff
      // ----------------------------------------------------------------------
   K1212_GET_WAVE_VOLUME,

      // ----------------------------------------------------------------------
      // K1212_GET_WAVE_VOL_CTRL_FLAG - This function requests the current
      // setting of the wave volume control enable flag.
      // ----------------------------------------------------------------------
   K1212_GET_WAVE_VOL_CTRL_FLAG,

      // ----------------------------------------------------------------------
      // K1212_DISABLE_WAVE_VOL_CTRL - This function requests that the driver
      // disable the use of volume control for the specified wave device.  
      // The channel field specifies which device.  If this field is set to
      // the maximum number of wave devices, then this action will apply to 
      // all wave devices.
      // ----------------------------------------------------------------------
   K1212_DISABLE_WAVE_VOL_CTRL,

      // ----------------------------------------------------------------------
      // K1212_ENABLE_WAVE_VOL_CTRL - This function requests that the driver
      // enable the use of volume control for the specified wave device.
      // The channel field specifies which device.  If this field is set to
      // the maximum number of wave devices, then this action will apply to 
      // all wave devices.
      // ----------------------------------------------------------------------
   K1212_ENABLE_WAVE_VOL_CTRL,

      // ----------------------------------------------------------------------
      // K1212_GET_WAVEDEV_SYNC_START_FLAG - This function requests the current
      // setting of the wave device synchronous start flag.  (The caller must
      // specify input or output device)
      // ----------------------------------------------------------------------
   K1212_GET_WAVEDEV_SYNC_START_FLAG,

      // ----------------------------------------------------------------------
      // K1212_SET_WAVEDEV_SYNC_START_FLAG - This function requests that the 
      // driver set the sync start flag for the specified input or output
      // wave device.
      // ----------------------------------------------------------------------
   K1212_SET_WAVEDEV_SYNC_START_FLAG,

      // ----------------------------------------------------------------------
      // K1212_SAVE_CARD_SETTINGS - This function requests that the driver save
      // the current volume, clock source/rate, sensitivity, and routing 
      // settings to the system registry.
      // ----------------------------------------------------------------------
   K1212_SAVE_CARD_SETTINGS,

      // ----------------------------------------------------------------------
      // K1212_RETRIVE_CARD_SETTINGS - This function requests that the driver 
      // obtain the settings saved to the registry by the 
      // K1212_SAVE_CARD_SETTINGS command.
      // ----------------------------------------------------------------------
   K1212_RETRIEVE_CARD_SETTINGS,

      // ----------------------------------------------------------------------
      // K1212_SAVE_CARD_WAVE_SETTINGS - This function requests that the driver
      // save the current wave device settings to the system registry.
      // ----------------------------------------------------------------------
   K1212_SAVE_CARD_WAVE_SETTINGS,

      // ----------------------------------------------------------------------
      // K1212_RETRIEVE_CARD_WAVE_SETTINGS - This function requests that the  
      // driver obtain the wave device settings saved to the registry by the 
      // K1212_SAVE_CARD_WAVE_SETTINGS command.
      // ----------------------------------------------------------------------
   K1212_RETRIEVE_CARD_WAVE_SETTINGS,
   
      // ----------------------------------------------------------------------
      // K1212_REGISTER_FOR_WAVE_VOLUPDATES - This function requests that the  
      // passed function pointer be called whenever a wave device volume is
      // updated via the 16 bit interface.
      // ----------------------------------------------------------------------
   K1212_REGISTER_FOR_WAVE_VOLUPDATES,
   
      // ----------------------------------------------------------------------
      // K1212_DEREGISTER_FOR_WAVE_VOLUPDATES - This function requests that the  
      // driver should no longer send updates to the passed function pointer.
      // ----------------------------------------------------------------------
   K1212_DEREGISTER_FOR_WAVE_VOLUPDATES,
   
      // ----------------------------------------------------------------------
      // K1212_GET_ADAT_TIMECODE - This function requests that the driver 
      // return the current ADAT timecode value.  This call is only valid when
      // an external clock is used, and the card is stopped.
      // ----------------------------------------------------------------------
   K1212_GET_ADAT_TIMECODE,

      // ----------------------------------------------------------------------
      // K1212_DISABLE_AUTO_WAVE_SYNC - This function requests that the driver
      // disable auto wave device sync mode.
      // ----------------------------------------------------------------------
   K1212_DISABLE_AUTO_WAVE_SYNC,

      // ----------------------------------------------------------------------
      // K1212_ENABLE_AUTO_WAVE_SYNC - This function requests that the driver
      // enable auto wave device sync mode.
      // ----------------------------------------------------------------------
   K1212_ENABLE_AUTO_WAVE_SYNC,

      // ----------------------------------------------------------------------
      // K1212_GET_AUTO_WAVE_SYNC - This function requests that the driver
      // return the current status of the auto wave device sync mode.
      // ----------------------------------------------------------------------
   K1212_GET_AUTO_WAVE_SYNC,

      // ----------------------------------------------------------------------
      // K1212_GET_CARD_DEBUG_INFO - This function requests that the driver
      // return debug information for the card.
      // ----------------------------------------------------------------------
   K1212_GET_CARD_DEBUG_INFO,
   
      // ----------------------------------------------------------------------
      // K1212_CLEAR_API - This function requests that the driver force 
      // everyone off the card.
      // ----------------------------------------------------------------------
   K1212_CLEAR_API

} k1212FunctionCodes;


// ----------------------------------------------------------------------------
// constants used internally by the API implementation
// ----------------------------------------------------------------------------
#define k1212AllCards  (k1212MaxCards * 2)
#define kNumBuffers    8


// ----------------------------------------------------------------------------
// The following structure is used for notifying K1212Wav.exe of wave device
// volume updates occurring via the wave driver interface.
// ----------------------------------------------------------------------------
typedef struct k1212WavVolUpdate {
   WORD  cardIndex;
   WORD  deviceId;
   WORD  leftVolume;
   WORD  rightVolume;
   PVOID thisPtr;
} k1212WavVolUpdate;

// ----------------------------------------------------------------------------
// The following structures are defined for the input and output buffers used
// in the DeviceIoControl() interface.  Note that these may be shared between
// various commands.  The commands that apply for each are specified with the
// structure.  The first item of the output buffer always contains the result
// code of the call.  The result codes are defined in the K1212CmdRet enum.
// ----------------------------------------------------------------------------

   // ------------------------------------------------------------------------
   // used for setting and returning stereo values, such as ADC input 
   // sensitivity.  GetInputSensitivity and SetInputSensitivity use this.
   // ------------------------------------------------------------------------
typedef struct k1212LeftRight { 
   WORD  leftValue;
   WORD  rightValue;
} k1212LeftRight;

   // ------------------------------------------------------------------------
   // used for setting and returning channel volume levels.  
   // ------------------------------------------------------------------------
typedef struct k1212ChanVolume { 
   WORD  channel;
   short volume;
} k1212ChanVolume;

   // ------------------------------------------------------------------------
   // used for setting and returning wave device volume levels.  
   // ------------------------------------------------------------------------
typedef struct k1212WaveVolume { 
   WORD           deviceId;
   k1212LeftRight volume;
} k1212WaveVolume;

   // ------------------------------------------------------------------------
   // used for setting and returning wave device synchronous start flag status  
   // ------------------------------------------------------------------------
typedef struct k1212WaveDevSync { 
   DWORD deviceId;
   DWORD flagSetting;
   DWORD deviceType;
} k1212WaveDevSync;

   // ------------------------------------------------------------------------
   // used for setting and returning channel routing.  
   // ------------------------------------------------------------------------
typedef struct k1212ChanRoute { 
   WORD  channel;
   WORD  route;
} k1212ChanRoute;

   // ------------------------------------------------------------------------
   // The following struct is used for setting up the fill routine call 
   // mechanism in the SetFillRoutine call
   // ------------------------------------------------------------------------
typedef struct k1212FillRoutineInfo { 
   DWORD  fillParam;
   PVOID  fillFunc;
} k1212FillRoutineInfo;

   // ------------------------------------------------------------------------
   // The following struct is used for writing to the card.
   // ------------------------------------------------------------------------
typedef struct k1212WriteCard { 
   DWORD  mailbox3Val;
   DWORD  mailbox2Val;
   DWORD  mailbox1Val;
   DWORD  mailbox0Val;
   DWORD  doorbellVal;
} k1212WriteCard;

   // ------------------------------------------------------------------------
   // The following struct is used for returning information when an 
   // application registers with the API.
   // ------------------------------------------------------------------------
typedef struct k1212APIInfo { 
   APIHandle  apiHandle;
   DWORD      sharedBufferCount;
} k1212APIInfo;

   // ------------------------------------------------------------------------
   // The following struct is used for passing the ADAT timecode and stop 
   // mode values for the TriggerPlayFromAdat call.
   // ------------------------------------------------------------------------
typedef struct k1212AdatTriggerData {
   DWORD                timecodeVal;   // ADAT timecode value for starting play
   StopModeSelector     stopModeSel;   // selects the stop mode 
} k1212AdatTriggerData;


   // ------------------------------------------------------------------------
   // The following struct is used for reporting card information from the 
   // GetCardInfo call.  An array of these structs is also used to report
   // all cards configured in the system for the QueryAllCards call. 
   // ------------------------------------------------------------------------
typedef struct k1212CardInfo {
   KorgAudioBuffer* playBuf0Address;   // address of the 1st playback buffer
   KorgAudioBuffer* recBuf0Address;    // address of the 1st record buffer
   WORD*            volBufAddress;     // linear address of the card's channel volume table
   WORD*            rteBufAddress;     // linear address of the card's channel routing table
   WORD             irqNum;            // interrupt level for the card
   WORD             busNum;            // PCI bus number on which the card resides
   WORD             deviceNum;         // device number of the card on the PCI bus
   WORD             spare;
   DWORD            devNode;           // device node of the card from the config mgr.
   CardState        state;             // current state of the card
} k1212CardInfo;


   // ------------------------------------------------------------------------
   // The following struct is used for assigning specific fields in the input
   // buffer of the DeviceIoControl call to the driver.
   // ------------------------------------------------------------------------
typedef struct k1212DIOCIn {
   APIHandle    apiHandle;                // which API object is making the call.  This is
                                          //    only used for open card and close driver calls. 
   DWORD        cardIndex;                // index of the card - used for calls specific
                                          //    to a particular card
   CardHandle   cardHandle;               // this must be filled in for calls that require
                                          //    the caller to have exclusive access to the card
   union {
      k1212FillRoutineInfo fillFuncData;  // used by SetFillRoutine
      ClockSourceIndex     clkSrcIdx;     // used by SetClockSourceRate
      k1212LeftRight       lrVals;        // used by SetInputSensitivity
      k1212WaveVolume      waveVol;       // used by SetWaveVolume
      k1212WaveDevSync     waveSync;      // used by Get/SetWaveSyncStart
      k1212AdatTriggerData adatTrigData;  // used by TriggerPlayFromAdat
      MonitorModeSelector  monMode;       // used by SetMonitorMode
      k1212WriteCard       regVals;       // used by write card
      k1212ChanVolume      chanVol;       // used by SetChannelVolume (protected mode i/f)
      k1212ChanRoute       chanRte;       // used by SetChannelRoute (protected mode i/f)
      WORD                 channel;       // used by GetChannelVolume and GetChannelRoute
      WORD                 deviceId;      // used by GetWaveVolume
      WORD                 wordValue;     // general word sized parameter
   };
} k1212DIOCIn;

   // ------------------------------------------------------------------------
   // The following struct is used for obtaining specific fields in the output
   // buffer of the DeviceIoControl call to the driver.
   // ------------------------------------------------------------------------
typedef struct k1212DIOCOut {
   K1212CmdRet returnValue;
   union {
      k1212CardInfo        cardInfo;                  // used by GetCardInfo
      k1212CardDebugInfo   cardDebugInfo;             // used by GetCardDebugInfo
      WORD                 version;                   // used by GetVersion
      k1212APIInfo         apiInfo;                   // used by RegisterApi
      CardHandle           cardHandle;                // used by OpenCard
      WORD                 size;                      // used by GetPacketSize, GetSampleSize
      ClockSourceIndex     curClkSrc;                 // used by GetClockSourceRate
      WORD                 bufferCount;               // used by GetBufferCount,
      WORD                 channelCount;              // used by GetPlayChannelCount,
                                                      //         GetRecordChannelCount 
      k1212LeftRight       lrVals;                    // used by GetInputSensitivity
      DWORD                recPlyLatency;             // used by GetRecordPlayLatency
      char*                bufAddress;                // used by GetChannelVolumeBufferAddress,
                                                      //         GetChannelRoutingBufferAddress,
                                                      //         GetAdatTimecodeAddress,
                                                      //         GetPlayBufferAddress,
                                                      //         GetRecordBufferAddress         
      BOOL                 boolValue;                 // general boolean return value.
      WORD                 wordValue;                 // general WORD return value.
      DWORD                dwordValue;                // general DWORD return value.
      k1212WriteCard       regVals;                   // used by read card
      k1212ChanVolume      chanVol;                   // used by GetChannelVolume (PM i/f)
      k1212ChanRoute       chanRte;                   // used by GetChannelRoute (PM i/f)
   };
} k1212DIOCOut;


#endif // K1212APIP_H
