//*****************************************************************************
//* Name:
//*      1212intf.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains declarations required for sending and receiving
//*      commands between the driver and the card.
//*
//* Modification Log:
//*
//*      1.3   08/08/97 Bill
//*      (v1.0B5) Added STOPCARD_DELAY.  (for use with new command register
//*      in the shared buffer.)
//*
//*      1.2   12/27/96 Bill
//*      Modified to support multiple cards.  
//*
//*      1.1   11/13/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212INTF_H
#define K1212INTF_H

#ifndef K1212API_H
#include "1212api.h"
#endif


// ----------------------------------------------------------------------------
// The following enumeration defines the constants written to the card's
// host-to-card doorbell to initiate a command.
// ----------------------------------------------------------------------------
typedef enum {
   K1212_DB_RequestForData        = 0,    // sent by the card to request a buffer fill.
   K1212_DB_TriggerPlay           = 1,    // starts playback/record on the card.
   K1212_DB_SelectPlayMode        = 2,    // select monitor, playback setup, or stop.
   K1212_DB_ConfigureBufferMemory = 3,    // tells card where the host audio buffers are.
   K1212_DB_RequestAdatTimecode   = 4,    // asks the card for the latest ADAT timecode value.
   K1212_DB_SetClockSourceRate    = 5,    // sets the clock source and rate for the card.
   K1212_DB_ConfigureMiscMemory   = 6,    // tells card where other buffers are.
   K1212_DB_TriggerFromAdat       = 7,    // tells card to trigger from Adat at a specific
                                          //    timecode value.
   K1212_DB_RebootCard            = 0xA0, // instructs the card to reboot.
   K1212_DB_BootFromDSPPage4      = 0xA4, // instructs the card to boot from the DSP microcode
                                          //    on page 4 (local page to card).
   K1212_DB_DSPDownloadDone       = 0xAE, // sent by the card to indicate the download has
                                          //    completed.
   K1212_DB_StartDSPDownload      = 0xAF  // tells the card to download its DSP firmware.
} DoorbellConstant;


// ----------------------------------------------------------------------------
// The following enumeration defines the constants used to select the play
// mode for the card in the SelectPlayMode command.
// ----------------------------------------------------------------------------
typedef enum {
   K1212_MODE_SetupPlay  = 0x00000001,     // provides card with pre-play information
   K1212_MODE_MonitorOn  = 0x00000002,     // tells card to turn on monitor mode
   K1212_MODE_MonitorOff = 0x00000004,     // tells card to turn off monitor mode
   K1212_MODE_StopPlay   = 0x00000008      // stops playback on the card
} PlayModeSelector;


// ----------------------------------------------------------------------------
// miscellaneous card interface constants
// ----------------------------------------------------------------------------
#define DUMMY_PARAMETER 0              // used to specify don't care values


// --------------------------------------------------------------------------
// Endian manipulation function declarations
// --------------------------------------------------------------------------
DWORD EndianSwap   (DWORD swappee);    // performs byte and word swaps on a DWORD
DWORD UpperWordSwap(DWORD swappee);    // swaps bytes in a DWORD's most sig word
DWORD LowerWordSwap(DWORD swappee);    // swaps bytes in a DWORD's least significant word
WORD  ByteSwap     (WORD swappee);     // swaps bytes in a WORD


// --------------------------------------------------------------------------
// WaitRTCTicks
//
//    This function waits the specified number of real time clock ticks.  
//    According to the DDK, each tick is ~0.8 microseconds.
//    The defines following the function declaration can be used for the
//    numTicksToWait parameter.
// --------------------------------------------------------------------------
void  WaitRTCTicks(DWORD numTicksToWait);
#define ONE_RTC_TICK         1
#define SENSCLKPULSE_WIDTH   4
#define LOADSHIFT_DELAY      4
#define INTERCOMMAND_DELAY  40
#define STOPCARD_DELAY      300        // max # RTC ticks for the card to stop once we write
                                       //    the command register.  (could be up to 180 us)
#define COMMAND_ACK_DELAY   13         // number of RTC ticks to wait for an acknowledgement
                                       //    from the card after sending a command.

// ----------------------------------------------------------------------------
// Interface function declarations.
//
//    Send1212Command() - sends a command to the card.  The parameters passed
//                        are written to the card's mailboxes and doorbell.
// ----------------------------------------------------------------------------
K1212CmdRet Send1212Command(DWORD            cardIndex,        // which card to send the command to
                            DoorbellConstant doorbellVal,      // doorbell value
                            DWORD            mailBox0Val,      // value for mailbox 0
                            DWORD            mailBox1Val,      // value for mailbox 1
                            DWORD            mailBox2Val,      // value for mailbox 2
                            DWORD            mailBox3Val       // value for mailbox 3
            );



#endif // K1212INTF_H
