//*****************************************************************************
//* Name:
//*      1212mem.c - Internal memory management for VxD KORG1212
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file implements memory management functions.  It was created
//*      to allow dynamic allocation in places where heap allocs are 
//*      problematic.
//*
//*
//* Modification Log:
//*
//*      1.1   03/31/97 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#include <vtoolsc.h>
#include <vmm.h>
#include <debug.h>
#include <vmmreg.h>

#ifndef  K1212CFG_H
#include "1212cfg.h"
#endif
#ifndef  K1212CARD_H
#include "1212card.h"
#endif
#ifndef  K1212WAVE_H
#include "1212wave.h"
#endif
#ifndef  K1212APPYTIME_H
#include "1212AppyTime.h"
#endif

// ----------------------------------------------------------------------------
// ****************************************************************************
// ----------------------------------------------------------------------------
// The following structures, constants, and arrays are for AppyTime memory 
// management.
// ----------------------------------------------------------------------------
// ****************************************************************************
// ----------------------------------------------------------------------------

K1212MemWaveInRet*  waveInRetHeadPtr;
K1212MemWaveOutRet* waveOutRetHeadPtr;

K1212MemWaveInRet  memWaveInRetBufs [NUM_WAVE_RETURN_ELEMENTS];
K1212MemWaveOutRet memWaveOutRetBufs[NUM_WAVE_RETURN_ELEMENTS];

// ----------------------------------------------------------------------------
// ****************************************************************************
// ----------------------------------------------------------------------------
// The following functions are for AppyTime memory management.
// ----------------------------------------------------------------------------
// ****************************************************************************
// ----------------------------------------------------------------------------
void InitWaveInRetBuffers(void)
{
   DWORD index;
   
   // --------------------------------------------------------------------------
   // first, initialize the head pointer, then loop through all but the last
   // element, setting each one to point to the next.  Finally, make the last
   // one point to null.
   // --------------------------------------------------------------------------
   waveInRetHeadPtr = memWaveInRetBufs;
   for (index = 0; index < (NUM_WAVE_RETURN_ELEMENTS - 1); index++) {
      memWaveInRetBufs[index].next         = &(memWaveInRetBufs[index + 1]);
      memWaveInRetBufs[index].buffer.inUse = FALSE;
   }
   memWaveInRetBufs[NUM_WAVE_RETURN_ELEMENTS - 1].next         = 0;
   memWaveInRetBufs[NUM_WAVE_RETURN_ELEMENTS - 1].buffer.inUse = FALSE;
}


void InitWaveOutRetBuffers(void)
{
   DWORD index;
   
   // --------------------------------------------------------------------------
   // first, initialize the head pointer, then loop through all but the last
   // element, setting each one to point to the next.  Finally, make the last
   // one point to null.
   // --------------------------------------------------------------------------
   waveOutRetHeadPtr = memWaveOutRetBufs;
   for (index = 0; index < (NUM_WAVE_RETURN_ELEMENTS - 1); index++) {
      memWaveOutRetBufs[index].next              = &(memWaveOutRetBufs[index + 1]);
      memWaveOutRetBufs[index].buffer.delayCount = 0;
      memWaveOutRetBufs[index].buffer.inUse      = FALSE;
   }
   memWaveOutRetBufs[NUM_WAVE_RETURN_ELEMENTS - 1].next              = 0;
   memWaveOutRetBufs[NUM_WAVE_RETURN_ELEMENTS - 1].buffer.delayCount = 0;
   memWaveOutRetBufs[NUM_WAVE_RETURN_ELEMENTS - 1].buffer.inUse      = FALSE;
}


WaveInBufReturnInfo*  AllocWaveInRetInfo(void)
{
   WaveInBufReturnInfo* returnVal;
   K1212MemWaveInRet*   tempPtr;

   if (waveInRetHeadPtr == 0) {
      return 0;
   }

   START_CRITICAL
      tempPtr                    = waveInRetHeadPtr;
      waveInRetHeadPtr           = waveInRetHeadPtr->next;
      tempPtr->next              = 0;
      tempPtr->buffer.inUse      = TRUE;
   END_CRITICAL

   returnVal = &(tempPtr->buffer);
   return returnVal;
}


void FreeWaveInRetInfo (WaveInBufReturnInfo* bufPtr)
{
   K1212MemWaveInRet*   tempPtr;

   if (bufPtr != 0) {
      START_CRITICAL
         tempPtr = (K1212MemWaveInRet*)((char*)bufPtr - sizeof(struct K1212MemWaveInRet*));
         tempPtr->buffer.inUse      = FALSE;
         tempPtr->next              = waveInRetHeadPtr;
         waveInRetHeadPtr           = tempPtr;
      END_CRITICAL
   }   
}


WaveOutBufReturnInfo* AllocWaveOutRetInfo(void)
{
   WaveOutBufReturnInfo* returnVal;
   K1212MemWaveOutRet*   tempPtr;

   if (waveOutRetHeadPtr == 0) {
      return 0;
   }

   START_CRITICAL
      tempPtr                    = waveOutRetHeadPtr;
      waveOutRetHeadPtr          = waveOutRetHeadPtr->next;
      tempPtr->buffer.delayCount = 0;
      tempPtr->buffer.inUse      = TRUE;
      tempPtr->next              = 0;
   END_CRITICAL

   returnVal = &(tempPtr->buffer);
   return returnVal;
}


void FreeWaveOutRetInfo (WaveOutBufReturnInfo* bufPtr)
{
   K1212MemWaveOutRet*   tempPtr;

   if (bufPtr != 0) {
      START_CRITICAL
         tempPtr = (K1212MemWaveOutRet*)((char*)bufPtr - sizeof(struct K1212MemWaveOutRet*));  
         tempPtr->buffer.delayCount = 0;
         tempPtr->buffer.inUse      = FALSE;
         tempPtr->next              = waveOutRetHeadPtr;
         waveOutRetHeadPtr          = tempPtr;
      END_CRITICAL
   }   
}

