//*****************************************************************************
//* Name:
//*      1212pci.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains the declaration of PCI specific functions,
//*      structures, and constants.
//*
//* Modification Log:
//*
//*      1.1   11/21/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* Note that contents of this file have been adapted from source
//* files from VtoolsD (Vireo Software, Inc.)
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212PCI_H
#define K1212PCI_H



#define PCI_ENUM_FUNC_GET_DEVICE_INFO   0
#define PCI_ENUM_FUNC_SET_DEVICE_INFO   1


typedef struct _pci_config_header_0_t
{
    USHORT  VendorID;
    USHORT  DeviceID;
    USHORT  Command; 
    USHORT  Status;
    UCHAR   RevisionID;
    UCHAR   ProgIf;    
    UCHAR   SubClass;  
    UCHAR   BaseClass; 
    UCHAR   CacheLineSize;
    UCHAR   LatencyTimer; 
    UCHAR   HeaderType;   
    UCHAR   BIST;          
    ULONG   BaseAddresses[6];
    ULONG   CardBusCISPtr;
    USHORT  SubsystemVendorID;
    USHORT  SubsystemID;
    ULONG   ROMBaseAddress;
    ULONG   Reserved2[2];
    UCHAR   InterruptLine; 
    UCHAR   InterruptPin;  
    UCHAR   MinimumGrant;  
    UCHAR   MaximumLatency;
} PCI_CONFIG_HEADER_0;

#define pciConfigSpaceSize (sizeof(PCI_CONFIG_HEADER_0))


// ----------------------------------------------------------------------------
// function declarations
// ----------------------------------------------------------------------------
CONFIGRET SetPCIConfigData(DEVNODE  Devnode, 
                           DWORD    StartByteOffset, 
                           DWORD*   ConfigDataBuffer, 
                           ULONG    nBytes);

CONFIGRET GetPCIConfigData(DEVNODE  Devnode, 
                           DWORD    StartByteOffset, 
                           DWORD*   ConfigDataBuffer, 
                           ULONG    nBytes
          );

void PrintPCIConfigData(PCI_CONFIG_HEADER_0 ConfigData);

#endif // K1212PCI_H
