//*****************************************************************************
//* Name:
//*      1212sens.h - Header file for ADC sensitivity setting module 
//*                   for VxD KORG1212.
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file declares constants, structures, and functions used for
//*      setting the input sensitivity of the Korg 1212 I/O card's ADC.
//*
//*
//* Modification Log:
//*
//*      1.1   02/04/97 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef  K1212SENS_H
#define  K1212SENS_H

// ------------------------------------------------------------------------
// the following constants are used in setting the 1212 I/O card's input
// sensitivity.
// ------------------------------------------------------------------------
#define SET_SENS_LOCALINIT_BITPOS  15  
#define SET_SENS_DATA_BITPOS       10
#define SET_SENS_CLOCK_BITPOS       8
#define SET_SENS_LOADSHIFT_BITPOS   0   

#define SET_SENS_LEFTCHANID   0x00   
#define SET_SENS_RIGHTCHANID  0x01   

#define K1212SENSUPDATE_DELAY_IN_MS  50  


// ------------------------------------------------------------------------
// the following structure is used for shifting the bits into the volume
// control chip on the 1212 I/O card.  Note that the channel ID and channel
// value locations are declared in reverse order in the structure because
// of Big Endian ordering in the system.
// ------------------------------------------------------------------------
typedef struct sensBits {
   union {
      struct {
         UINT leftChanVal:8;
         UINT leftChanId:8;
      };
      WORD  leftSensBits;
   };
   union {
      struct {
         UINT rightChanVal:8;
         UINT rightChanId:8;
      };
      WORD  rightSensBits;
   };   
} sensBits;



// --------------------------------------------------------------------------
// WriteADCSensitivity
//
//    This function writes the ADC input sensitivities to the card using the
//    custom serial interface described in the K1212 driver API document.
// --------------------------------------------------------------------------
BOOL  WriteADCSensitivity(DWORD cardIndex);


#endif  // K1212SENS_H
