//*****************************************************************************
//* Name:
//*      1212wavestruct.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains private declarations for the implementation of the
//*      Win16 application to Korg1212 VxD interface.
//*
//* Modification Log:
//*
//*      1.6   08/26/97 Bill
//*      (v 1.0B6) Added spdifDevice members to wave devices.
//*
//*      1.5   06/17/97 Bill
//*      (v 1.11) Added numBufsPrefilled in place of preFillBufIndex.  Also added
//*      retBufQueue to both wave in and out devices.
//*
//*      1.4   06/09/97 Bill
//*      (v 1.09) Added lastIsrTime for estimating the card's current position.
//*
//*      1.3   06/09/97 Bill
//*      (v 1.08) Added looping variables to the output wave device structure.
//*
//*      1.3   05/23/97 Bill
//*      (v 1.04) Added preFillBufIndex to the output wave device structure.
//*
//*      1.2   03/14/97 Bill
//*      (v 1.02) Added storage for previous 8 samples to the wave output device
//*               data structure.  These are used for low-pass filtering and are
//*               implemented as a circular buffer.
//*
//*      1.1   03/14/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212WAVESTRUCT_H
#define K1212WAVESTRUCT_H

#define _WIN32_VXD
#include <mmsystem.h>
#include "1212WaveApi.h"

#ifndef K1212APPYTIME_H
#include "1212AppyTime.h"
#endif

#ifndef HIWORD
#define HIWORD(l)    ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#endif
#ifndef LOWORD
#define LOWORD(l)    ((WORD)(l))
#endif

// -------------------------------------------------------------------------------
// constants used for implementing low pass output filters
// -------------------------------------------------------------------------------
#define MAX_NUM_WAVEOUT_FILTER_SAMPLES             8
#define NUM_22TO44_WAVEOUT_FILTER_SAMPLES          MAX_NUM_WAVEOUT_FILTER_SAMPLES
#define NUM_22TO44_WAVEOUT_SAMPLES_STORED          (NUM_22TO44_WAVEOUT_FILTER_SAMPLES - 1)
#define NUM_22TO44_WAVEOUT_SAMPLES_CALCULATED      1
#define NUM_22TO44_WAVEOUT_FILTER_COEF_PER_SAMPLE  NUM_22TO44_WAVEOUT_FILTER_SAMPLES
#define NUM_11TO44_WAVEOUT_FILTER_SAMPLES          MAX_NUM_WAVEOUT_FILTER_SAMPLES
#define NUM_11TO44_WAVEOUT_SAMPLES_STORED          (NUM_11TO44_WAVEOUT_FILTER_SAMPLES - 1)
#define NUM_11TO44_WAVEOUT_SAMPLES_CALCULATED      3
#define NUM_11TO44_WAVEOUT_FILTER_COEF_PER_SAMPLE  NUM_11TO44_WAVEOUT_FILTER_SAMPLES


typedef struct k1212WaveOutDevice {
   WaveOutDeviceState state;                 // current state of the wave output device
   K1212WaveFormat    format;                // wave buffer data format
   LPWAVEHDR          waveBufferQueue;       // head pointer of the wave buffer queue
   K1212MemWaveOutRet* retBufQueue;          // head pointer to wave buffers to be returned
   void*              curWaveSamplePtr;      // points to the next sample in the current 
                                             //    wave buffer
   DWORD              remainingBytesInBuf;   // indicates how many samples are remaining in the
                                             //    current wave buffer
   DWORD              numSamplesPlayed;      // number of samples played back since the first
                                             //    buffer was written to the playback queue
   DWORD              lastEstimatedPosition; // keeps track of the last position, in case we are paused.
   DWORD              stereoPairOffset;      // offset in bytes from the beginning of an audio
                                             //    frame to where this devices samples are
   DWORD              numBufsPrefilled;      // stores the number of buffers that were prefilled
                                             //    when this device started.  (v1.11)
   DWORD              numSamplesPrefilled;   // stores the number of samples that were prefilled
                                             //    when this device started.  (v1.11)
   WORD               leftVolumeLevel;       // left channel playback volume level adjustment
   WORD               rightVolumeLevel;      // right channel playback volume level adjustment
   BOOL               muted;                 // indicates whether the device is muted
   BOOL               volumeControlEnabled;  // indicates whether to use the volume levels
   BOOL               chainLinkSync;         // if true, indicates that this device must be 
                                             //    started at the same time as any others with
                                             //    this flag set
   DWORD              spdifDevice;           // indicates whether the device uses spdif format samples
   DWORD              ring3Callback;         // parameter specifying where to call the wave 
                                             //    driver in ring 3
   DWORD              clientHandle;          // given to us by the wave driver and used to
                                             //    identify the owner of wave buffers
   DWORD              lastIsrTime;           // indicates the last time we serviced the card's interrupt
   VMHANDLE           vmHandle;              // VM handle for the application opening this 
                                             //    device
   void*              translateFunctionPtr;  // pointer to the function to use to
                                             //   translate wave output buffer data 
                                             //   into the card's shared buffer data.
                                             
   // ----------------------------------------------------------------------------------
   // the following members are added for providing output filtering.  The subscript
   // and coefficient arrays are defined in the implementation file (1212xwav.c).
   // ----------------------------------------------------------------------------------
   WORD               curSampleSubscript;    // index into subscript array.
   K1212Sample        prevLeftSample[NUM_11TO44_WAVEOUT_FILTER_SAMPLES]; 
   K1212Sample        prevRightSample[NUM_11TO44_WAVEOUT_FILTER_SAMPLES];

   // ----------------------------------------------------------------------------------
   // the following members are added for looping.
   // ----------------------------------------------------------------------------------
   BOOL               inLoop;                // indicates whether we are currently in a loop
   LPWAVEHDR          loopStartBuffer;       // points to first buffer in a loop - must be 
                                             //    stored, since buffers are not bidirect linked

} k1212WaveOutDevice;


typedef struct k1212WaveInDevice {
   WaveInDeviceState state;                  // current state of the wave input device
   K1212WaveFormat   format;                 // wave buffer data format
   LPWAVEHDR         waveBufferQueue;        // head pointer of the wave buffer queue
   void*             curWaveSamplePtr;       // points to the next sample in the current 
                                             //    wave buffer
   DWORD             bufLength;              // the size of the current wave buffer
   DWORD             numBytesRecordedInBuf;  // current count of bytes written to the current
                                             //    wave buffer
   DWORD             numSamplesRecorded;     // number of samples recorded since the start
                                             //    command was received
   DWORD             lastEstimatedOffset;    // keeps track of the last position, in case we are stopped.
                                             //    this way, we know how many samples we need to record to
                                             //    finish up the stop process.
   DWORD             stereoPairOffset;       // offset in bytes from the beginning of an audio
                                             //    frame to where this devices samples are
   BOOL              chainLinkSync;          // if true, indicates that this device must be 
                                             //    started at the same time as any others with
                                             //    this flag set
   DWORD             spdifDevice;            // indicates whether the device uses spdif format samples
   DWORD             ring3Callback;          // parameter specifying where to call the wave 
                                             //    driver in ring 3
   DWORD             clientHandle;           // given to us by the wave driver and used to
                                             //    identify the owner of wave buffers.  The low
                                             //    word contains the near pointer to pClient.
   DWORD             lastIsrTime;            // indicates the last time we serviced the card's interrupt
   VMHANDLE          vmHandle;               // VM handle for the application opening this 
                                             //    device

   void*             translateFunctionPtr;   // pointer to the function to use to 
                                             //    translate the card's shared buffer
                                             //    format into the wave input buffer's
                                             //    format.
} k1212WaveInDevice;


// ----------------------------------------------------------------------------
// The following typedef is for the buffer translation function pointers.  All
// of these functions return void, and take two WORD arguments.
// ----------------------------------------------------------------------------
typedef void (*BufXlateWaveInFuncPtr)(WORD               cardIndex, 
                                      k1212WaveInDevice* waveDevicePtr,
                                      DWORD              numSamplesToRecord,
                                      DWORD              spdifDevice
              );

typedef void (*BufXlateWaveOutFuncPtr)(WORD cardIndex, 
                                       k1212WaveOutDevice* waveDevicePtr,
                                       DWORD               spdifDevice
              );


// ----------------------------------------------------------------------------
// The following arrays hold the buffer translation function pointers for both
// record and playback.  They are indexed by K1212WaveFormat.
// ----------------------------------------------------------------------------
extern BufXlateWaveInFuncPtr  recordXlateFunctions[];
extern BufXlateWaveOutFuncPtr playXlateFunctions[];



// --------------------------------------------------------------------------------
// utility functions for wave buffer translation and API functions
// --------------------------------------------------------------------------------
void PrepareCardForWavePlay
(
   WORD  cardIndex
);
void ReleaseWaveInBuffer
(
   WORD                 cardIndex,
   k1212WaveInDevice*   waveInDevPtr
);
void ReleaseWaveOutBuffer
(
   WORD                 cardIndex,
   k1212WaveOutDevice*  waveOutDevPtr
);
DWORD FormatToBytesPerSample
(
   K1212WaveFormat format
);
DWORD FormatToSampleRate
(
   K1212WaveFormat format
);
BOOL ResetWaveInDevice
(
   WORD      cardIndex,
   WORD      deviceId
);
BOOL ResetWaveOutDevice
(
   WORD      cardIndex,
   WORD      deviceId
);
void IncrementPrefillBufIndex                   // (v1.04)
(
   k1212WaveOutDevice*  waveOutDevPtr
);

#endif // K1212WAVESTRUCT_H
