//*****************************************************************************
//* Name:
//*      driver.h
//*
//* Project:
//*      1212 I/O Driver
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*
//* Modification Log:
//*
//*      1.6   6/24/97 Bill
//*      Changed DRV_VERSION to v1.0(B2).
//*
//*      1.5   6/09/97 Bill
//*      Changed DRV_VERSION to v1.06(B).
//*
//*      1.4   6/09/97 Bill
//*      Changed DRV_VERSION to v1.05(B).  
//*
//*      1.3   6/06/97 Bill
//*      Changed DRV_VERSION to v1.04(B).  
//*
//*      1.2   6/06/97 Bill
//*      Changed DRV_VERSION to v1.03(B).  
//*
//*      1.1   1/15/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*
//* Note: This file was originally adapted from the Microsoft Windows
//*       95 DDK.  Copyright (c) 1991 - 1995  Microsoft Corporation.
//*****************************************************************************

#ifndef SETUPX_INC
#include <setupx.h>
#endif

#define DRV_VERSION 0x0100

//-----------------------------------------------------------------------------
// indices into the string table
//-----------------------------------------------------------------------------
#define IDS_MENUABOUT      1
#define IDS_VERSION        2


// ----------------------------------------------------------------------------
// BCODE is a macro to define a R/O variable in the code segment
// ----------------------------------------------------------------------------
#define BCODE _based(_segname("_CODE"))


//-----------------------------------------------------------------------------
// constants
//-----------------------------------------------------------------------------
#define DEFAULT_SINGLEMODEDMA           FALSE
#define DEFAULT_ACCEPTCLOSERATES        FALSE
#define DEFAULT_SBEMULATION             TRUE
#define DEFAULT_DO11KHZMCE              FALSE

//-----------------------------------------------------------------------------
// structure definitions
//-----------------------------------------------------------------------------
typedef struct wavealloc_tag
{
    DWORD               dwCallback ;       // client's callback
    DWORD               dwInstance ;       // client's instance data
    HANDLE              hWave ;            // handle for stream
    DWORD               dwFlags ;          // allocation flags
    DWORD               dwDevNode ;        // PNP device node of the card
    DWORD               dwHalfDMABuffers ; // num of DMA buffers completed
    PCMWAVEFORMAT       pcmwf ;            // format of wave data
} WAVEALLOC, NEAR *NPWAVEALLOC, FAR *LPWAVEALLOC ;

typedef struct tagDRVDATA 
{
    LPDEVICE_INFO    lpdi;
    LPCSTR           pszTemplate;
    BOOL             fAcceptCloseRates;
    BOOL             fSingleModeDMA;
    BOOL             fSBEmulation;
    BOOL             fDo11kHzMCE;

} DRVDATA, NEAR* PDRVDATA, FAR* LPDRVDATA;


//-----------------------------------------------------------------------------
// function prototypes
//-----------------------------------------------------------------------------
extern "C" {

   // ----------------------------------------------------------
   // prototypes for driver.c
   // ----------------------------------------------------------
extern DWORD FAR PASCAL _loadds DriverProc(
   DWORD  dwDriverID, 
   HANDLE hDriver, 
   WORD   wMessage, 
   DWORD  dwParam1, 
   DWORD  dwParam2
);
int  DrvInit();
void DrvEnd();


   // ----------------------------------------------------------
   // prototypes for init.c
   // ----------------------------------------------------------
VOID    FAR PASCAL DebugMsg(char __far * stringPtr);
VOID    FAR PASCAL MsgBox  (char __far * stringPtr);

   // ----------------------------------------------------------
   // prototypes for mixer.cpp
   // ----------------------------------------------------------
DWORD FAR  PASCAL _loadds mxdMessage(
   UINT   uDevId,
   WORD   msg,
   DWORD  dwUser,
   DWORD  dwParam1,
   DWORD  dwParam2
);

   // ----------------------------------------------------------
   // prototypes for wid.c
   // ----------------------------------------------------------
DWORD FAR  PASCAL _loadds widMessage(
   UINT   uDevId,
   WORD   msg,
   DWORD  dwUser,
   DWORD  dwParam1,
   DWORD  dwParam2
);

VOID FAR PASCAL widGetDevCaps(
   UINT                uDevId,
   k1212CardRef        cardRefNum,
   MDEVICECAPSEX FAR   *lpCaps
);

VOID FAR PASCAL WidVxDCallback
(
   DWORD       request,
   LPWAVEALLOC lpClient,
   LPVOID      lpRequestParams
);


   // ----------------------------------------------------------
   // prototypes for wod.c
   // ----------------------------------------------------------
DWORD FAR  PASCAL _loadds wodMessage(
   UINT   uDevId,
   WORD   msg,
   DWORD  dwUser,
   DWORD  dwParam1,
   DWORD  dwParam2
);

VOID FAR PASCAL wodGetDevCaps(
   UINT                uDevId,
   k1212CardRef        cardRefNum,
   MDEVICECAPSEX FAR*  lpCaps
);

VOID FAR PASCAL WodVxDCallback
(
   DWORD       request,
   LPWAVEALLOC lpClient,
   LPVOID      lpRequestParams
);


   // ----------------------------------------------------------
   // prototypes for WaveUtil.c
   // ----------------------------------------------------------
BOOL FAR PASCAL verifyDevNode
(
    DWORD                 devNode,
    k1212CardRef __far &  cardRefNum
);

VOID FAR PASCAL waveCallBack
(
    LPWAVEALLOC     lpWave,
    WORD            msg,
    DWORD           dw1
);

}  // extern "C"

// -------------------------------------------------------------------------
// Globals
// -------------------------------------------------------------------------
extern WORD          gwUniqueID;
extern HMODULE       ghModule;            // our module handle
extern CKorg1212Api* pK1212Driver;        // pointer to the VxD API interface object

// -------------------------------------------------------------------------
// Strings
// -------------------------------------------------------------------------

