//*****************************************************************************
//* Name:
//*      PropPage.c
//*
//* Project:
//*      1212 I/O Driver
//*
//* Author:
//*      Bill Jenkins
//*
//* Description: 
//*      Property page creator/handler for our wave devices.
//*
//* Modification Log:
//*
//*      1.1   1/20/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*
//* Note: This file was originally adapted from the Microsoft Windows
//*       95 DDK.  Copyright (c) 1991 - 1995  Microsoft Corporation.
//*****************************************************************************
#include <windows.h>
#include "gsound.h"
#include "12pmapic.h"
#include "driver.h"
#include "config.h"

#include <verinfo.h>
#include <wsshlpid.h>

const static DWORD aHelpIds[] = {  // Context Help IDs
    IDC_DRVPROP_EMULATION_GRP,      IDH_COMM_GROUPBOX,
    IDC_DRVPROP_SINGLEMODEDMA,      IDH_WINDOWS_SNDSYS_DMA,       
    IDC_DRVPROP_ACCEPTCLOSERATES,   IDH_WINDOWS_SNDSYS_SAMPLE,    
    IDC_DRVPROP_ADVANCED_GRP,       IDH_COMM_GROUPBOX,
    IDC_DRVPROP_ENABLESB,           IDH_WINDOWS_SNDSYS_SNDBLASTER,
    0, 0
};

static const char cszHelpFile[] = "MMDRV.HLP";

//static char BCODE gszRegKeyConfig[]           = REGSTR_SUBKEY_CONFIG;
//static char BCODE gszRegValSingleModeDMA[]    = REGSTR_VAL_SINGLEMODEDMA ;
//static char BCODE gszRegValAcceptCloseRates[] = REGSTR_VAL_ACCEPTCLOSERATES ;
//static char BCODE gszRegValSoundBlasterEmulation[] = REGSTR_VAL_SBEMULATION ;
//static char BCODE gszRegValDo11kHzMCE[]       = REGSTR_VAL_DO11KHZMCE ;

extern char gszConfig[] ;

extern "C" {

typedef RETERR (WINAPI *FNDICHANGESTATE)( LPDEVICE_INFO lpdi, DWORD dwStateChange, DWORD dwFlags, LPARAM lParam ) ;

//--------------------------------------------------------------------------
//  
//  VOID DrvLoadUserConfig
//  
//  Description:
//      Reads the user configurable settings from the registry
//  
//  Parameters:
//
//  Return (VOID):
//  
//  
//--------------------------------------------------------------------------

VOID NEAR DrvLoadUserConfig
(
    DEVNODE         dnDevNode,
    LPDRVDATA       pDrvData
)
{
   return;
} // DrvLoadUserConfig()


//--------------------------------------------------------------------------
//  
//  VOID DrvSaveUserConfig
//  
//  Description:
//     Writes the user configurable settings to the registry
//  
//  Parameters:
//  
//  Return (VOID):
//  
//  
//--------------------------------------------------------------------------
VOID NEAR DrvSaveUserConfig
(
    PDRVDATA        pDrvData
)
{
    return;
} // DrvSaveUserConfig()


//--------------------------------------------------------------------------
//  
//  VOID InitDrvPropertiesDlg
//  
//  Description:
//  
//  
//  Parameters:
//      HWND hDlg
//  
//      PDRVDATA pDrvData
//  
//  Return (VOID):
//  
//  
//--------------------------------------------------------------------------

VOID NEAR InitDrvPropertiesDlg
(
    HWND            hDlg,
    PDRVDATA        pDrvData
)
{
   DrvLoadUserConfig( pDrvData -> lpdi -> dnDevnode, pDrvData ) ;
   
   SendDlgItemMessage( hDlg, IDC_DRVPROP_ACCEPTCLOSERATES,
                       BM_SETCHECK, pDrvData -> fAcceptCloseRates, 0L ) ;
   SendDlgItemMessage( hDlg, IDC_DRVPROP_SINGLEMODEDMA,
                       BM_SETCHECK, pDrvData -> fSingleModeDMA, 0L ) ;

   if (pDrvData -> pszTemplate == IDD_PROPDLG_SB)
      SendDlgItemMessage( hDlg, IDC_DRVPROP_ENABLESB,
                          BM_SETCHECK, pDrvData -> fSBEmulation, 0L ) ;

} // InitDrvPropertiesDlg()


//--------------------------------------------------------------------------
//  
//  VOID ApplyDrvPropertiesDlg
//  
//  Description:
//  
//  
//  Parameters:
//      HWND hDlg
//  
//      PDRVDATA pDrvData
//  
//  Return (VOID):
//  
//  
//--------------------------------------------------------------------------
VOID NEAR ApplyDrvPropertiesDlg
(
    HWND            hDlg,
    PDRVDATA        pDrvData
)
{
   BOOL  fChanged, fSetting ;

   fChanged = FALSE ;

   fSetting =
      (BOOL) SendDlgItemMessage( hDlg, IDC_DRVPROP_ACCEPTCLOSERATES,
                                 BM_GETCHECK, 0, 0L );
   if (pDrvData -> fAcceptCloseRates != fSetting)
   {
      fChanged = TRUE ;
      pDrvData -> fAcceptCloseRates = fSetting ;
   }

   fSetting =
      (BOOL) SendDlgItemMessage( hDlg, IDC_DRVPROP_SINGLEMODEDMA,
                                 BM_GETCHECK, 0, 0L ) ;

   if (pDrvData -> fSingleModeDMA != fSetting)
   {
      fChanged = TRUE ;
      pDrvData -> fSingleModeDMA = fSetting ;
   }

   if (pDrvData -> pszTemplate == IDD_PROPDLG_SB)
   {
      fSetting =
         (BOOL) SendDlgItemMessage( hDlg, IDC_DRVPROP_ENABLESB,
                                    BM_GETCHECK, 0, 0L ) ;

      if (pDrvData -> fSBEmulation != fSetting)
      {
         fChanged = TRUE ;
         pDrvData -> fSBEmulation = fSetting ;
      }
   }
} // ApplyDrvPropertiesDlg()


//--------------------------------------------------------------------------
//  
//  BOOL DrvPropertiesDlgProc
//  
//  Description:
//  
//  
//  Parameters:
//      HWND hDlg
//  
//      UINT uMsg
//  
//      WPARAM wParam
//  
//      LPARAM lParam
//  
//  Return (BOOL):
//  
//--------------------------------------------------------------------------
BOOL CALLBACK _loadds DrvPropertiesDlgProc
(
    HWND            hDlg,
    UINT            uMsg,
    WPARAM          wParam,
    LPARAM          lParam
)
{
   PDRVDATA  pDrvData ;

   pDrvData = (PDRVDATA) GetWindowLong( hDlg, DWL_USER ) ;

   switch(uMsg)
   {
      case WM_INITDIALOG:
         pDrvData = (PDRVDATA) (((LPPROPSHEETPAGE) lParam) -> lParam);
         SetWindowLong( hDlg, DWL_USER, MAKELONG( pDrvData, 0 ) );
         InitDrvPropertiesDlg( hDlg, pDrvData );
         break;
         
      case WM_DESTROY:
         LocalFree( (HLOCAL) pDrvData );
         break;

      case WM_COMMAND:
      {
         switch (wParam)
         {
            case IDC_DRVPROP_SETDEFAULTS:
               SendDlgItemMessage( hDlg, IDC_DRVPROP_ACCEPTCLOSERATES,
                                   BM_SETCHECK,
                                   DEFAULT_ACCEPTCLOSERATES, 0L );
               SendDlgItemMessage( hDlg, IDC_DRVPROP_SINGLEMODEDMA,
                                   BM_SETCHECK,
                                   DEFAULT_SINGLEMODEDMA, 0L );
               SendDlgItemMessage( hDlg, IDC_DRVPROP_ENABLESB,
                                   BM_SETCHECK,
                                   DEFAULT_SBEMULATION, 0L ) ;
               break ;
         }
         break ;
      }
      
      case WM_NOTIFY:
         switch (((NMHDR FAR *)lParam)->code)
         {
            case PSN_APPLY:
               ApplyDrvPropertiesDlg( hDlg, pDrvData ) ;
               break ;
         }
         break ;

      case WM_CONTEXTMENU:
         WinHelp( (HWND) wParam, (LPSTR) cszHelpFile, HELP_CONTEXTMENU,
                  (DWORD) (LPSTR) aHelpIds ) ;
         return TRUE ;

      case WM_HELP:
      {
         LPHELPINFO lphi = (LPHELPINFO) lParam;
         WinHelp( lphi -> hItemHandle, (LPSTR)cszHelpFile, HELP_WM_HELP,
                  (DWORD) (LPSTR) aHelpIds ) ;
         return TRUE ;
      }
      
      default:
         return FALSE ;
   }
   return TRUE ;

} // DrvPropertiesDlgProc()


//--------------------------------------------------------------------------
//  
//  BOOL DrvEnumPropPages
//  
//  Description:
//  
//  
//  Parameters:
//      LPDEVICE_INFO lpdi
//  
//      LPFNADDPROPSHEETPAGE pfn
//  
//      LPARAM lParam
//  
//  Return (BOOL):
//
//  
//--------------------------------------------------------------------------

BOOL WINAPI _loadds DrvEnumPropPages
(
    LPDEVICE_INFO           lpdi,
    LPFNADDPROPSHEETPAGE    pfn,
    LPARAM                  lParam
)
{
   PDRVDATA           pDrvData;
   PROPSHEETPAGE      psp;
   HPROPSHEETPAGE     hpage;

   DebugMsg((char __far *)"Uh, prop pages?");

   // -----------------------------------------------------
   //  Allocate a per-instance dialog data structure.
   // -----------------------------------------------------
   if (NULL != (pDrvData = (PDRVDATA) LocalAlloc( LPTR, sizeof( DRVDATA ) ))) {
      psp.dwSize    = sizeof( psp );
      psp.dwFlags   = PSP_DEFAULT;
      psp.hInstance = ghModule;

      psp.pszTemplate = IDD_PROPDLG_NOSB;
      psp.pfnDlgProc  = (DLGPROC) DrvPropertiesDlgProc;
      psp.lParam      = MAKELPARAM( pDrvData, 0 );

      pDrvData -> lpdi        = lpdi;
      pDrvData -> pszTemplate = psp.pszTemplate;

      hpage = CreatePropertySheetPage( &psp );
      if (hpage) {
         if (!pfn(hpage, lParam)) {
            DestroyPropertySheetPage(hpage);
            LocalFree( (HLOCAL) pDrvData ) ;
         }
      }
   }
   return( TRUE ) ;

} // DrvEnumPropPages()

}     // extern "C"



//---------------------------------------------------------------------------
//  End of File: proppage.c
//---------------------------------------------------------------------------

