//*****************************************************************************
//* Name:
//*      WaveUtil.c
//*
//* Project:
//*      1212 I/O Driver
//*
//* Author:
//*      Bill Jenkins
//*
//* Description: 
//*      Wave device utility functions.
//*
//* Modification Log:
//*
//*      1.1   3/07/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*
//* Note: This file was originally adapted from the Microsoft Windows
//*       95 DDK.  Copyright (c) 1991 - 1995  Microsoft Corporation.
//*****************************************************************************

#include <windows.h>
#include <string.h>
#include "gsound.h"
#include "12pmapic.h"
#include "driver.h"


// ---------------------------------
// global variables
// ---------------------------------
WORD  gwUniqueID = 1;


//------------------------------------------------------------------------
// BOOL FAR PASCAL verifyDevNode(DWORD devNode, k1212CardRef& cardRefNum)
//
//  Description:
//     This function verifies that the passed in device node is recognized
//     by the VxD.
//
//  Parameters:
//     DWORD devNode
//        device node to verify
//
//     k1212CardRef& cardrefNum
//        as a side effect, this variable gets filled in by the device
//        node's corresponding card reference number.
//
//  Return Value:
//     TRUE if the device node is valid.  FALSE if any error occurs or
//     the device node is invalid.
//
//
//------------------------------------------------------------------------
BOOL FAR PASCAL verifyDevNode
(
    DWORD                 devNode,
    k1212CardRef __far &  cardRefNum
)
{
   if (pK1212Driver) {
      if (pK1212Driver->DevNodeToCardRef(devNode, 
                                         cardRefNum   // gets assigned here
                        ) == K1212_CMDRET_Success
         ) {
         return TRUE;
      }
      else {
         return FALSE;
      }
   }
   else {   // no VxD interface
      return FALSE;
   }
}


//------------------------------------------------------------------------
//  VOID FAR PASCAL waveCallBack( NPWAVEALLOC pWave, WORD msg, DWORD dw1 )
//
//  Description:
//     This calls DriverCallback for a WAVEHDR.
//
//  Parameters:
//     NPWAVEALLOC pWave
//        pointer to wave device
//
//     WORD msg
//        the message
//
//     DWORD dw1
//        DWORD parameter of DWORD, dw2 is always set to 0.
//
//  Return Value:
//     Nothing.
//
//
//------------------------------------------------------------------------
VOID FAR PASCAL waveCallBack
(
    LPWAVEALLOC     lpWave,
    WORD            msg,
    DWORD           dw1
)
{
   // ----------------------------------------------------------------------
   // Invoke the callback function, if it exists.  dwFlags contains
   // wave driver specific flags in the LOWORD and generic driver
   // flags in the HIWORD.
   // ----------------------------------------------------------------------
   if (!lpWave) {
      gwUniqueID++;
      return;
   }

   if (HIWORD(lpWave->dwFlags))
      DriverCallback(
         lpWave->dwCallback,                    // user's callback DWORD
         HIWORD(lpWave->dwFlags),               // callback flags
         lpWave->hWave,                         // handle to the wave device
         msg,                                   // the message
         lpWave->dwInstance,                    // user's instance data
         dw1,                                   // first DWORD
         0L ) ;                                 // second DWORD

} // end of waveCallBack()

