//*****************************************************************************
//* Name:
//*      driver.h
//*
//* Project:
//*      1212 I/O Driver
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*
//* Modification Log:
//*
//*      1.2   8/04/97 Bill
//*      (v1.0B5) Added MsgBox function.  
//*
//*      1.1   1/15/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*
//* Note: This file was originally adapted from the Microsoft Windows
//*       95 DDK.  Copyright (c) 1991 - 1995  Microsoft Corporation.
//*****************************************************************************

#include <windows.h>
#include "gsound.h"
#include "12pmapic.h"
#include "driver.h"


#ifdef DEBUG
    WORD    wDebugLevel = 3;       // debug level
    char STR_PROLOGUE[] = "SNDSYS: ";
    char STR_CRLF[]     = "\r\n";
    char STR_SPACE[]    = " ";
#endif

extern CKorg1212Api* pK1212Driver;   // VxD interface API object pointer

HMODULE       ghModule;              // our module handle

//--------------------------------------------------------------------------
//  
//  int LibMain
//  
//  Description:
//      Library initialization code
//  
//  Parameters:
//      HMODULE hModule
//         Module handle
//  
//      UINT uDataSeg
//         selector of data segment
//
//      UINT uHeapSize
//         Heap size as specified in .DEF
//  
//      LPSTR lpCmdLine
//         command line passed from kernel
//  
//  Return (int):
//      1 if successful
//  
//  
//--------------------------------------------------------------------------
int FAR PASCAL LibMain
(
    HMODULE         hModule,
    UINT            uDataSeg,
    UINT            uHeapSize,
    LPSTR           lpCmdLine
)
{
    // -------------------------------
    //  save our module handle
    // -------------------------------
    ghModule = hModule;

    // -------------------------------
    //  succeed the load...
    // -------------------------------
    return (1);
}



//------------------------------------------------------------------------
//  VOID DebugMsg
//
//  Description:
//     Shows a message box containing the passed in string.
//
//  Parameters:
//     char* stringPtr.
//
//  Return Value:
//     None.
//
//
//------------------------------------------------------------------------
VOID FAR PASCAL DebugMsg(char __far * stringPtr)
{
   pK1212Driver->PostMsgToFile(0,
                               stringPtr,
                               lstrlen((char __far *)stringPtr)
                 );

//   #ifdef DEBUG
//      MessageBox(NULL,
//                 stringPtr,
//                 "Korg 1212 I/O Wave Device",
//                 (MB_ICONINFORMATION | MB_OK)
//      );
//   #endif
} // end of DrvEnd()


//------------------------------------------------------------------------
//  VOID MsgBox
//
//  Description:
//     Shows a message box containing the passed in string.
//
//  Parameters:
//     char* stringPtr.
//
//  Return Value:
//     None.
//
//
//------------------------------------------------------------------------
VOID FAR PASCAL MsgBox(char __far * stringPtr)
{
   MessageBox(NULL,
              stringPtr,
              "Korg 1212 I/O Driver",
              (MB_ICONINFORMATION | MB_OK)
   );
} // end of DrvEnd()
