/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ServiceLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ContextServiceLoaderPluginResolver;
import org.apache.camel.spi.ContextServicePlugin;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextServiceLoaderPlugin
extends ServiceSupport
implements ContextServiceLoaderPluginResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContextServiceLoaderPlugin.class);
    private CamelContext camelContext;
    private ServiceLoader<ContextServicePlugin> contextServicePlugins;

    protected void doStart() throws Exception {
        this.contextServicePlugins = ServiceLoader.load(ContextServicePlugin.class, this.camelContext.getApplicationContextClassLoader());
        for (ContextServicePlugin plugin : this.contextServicePlugins) {
            try {
                plugin.load(this.camelContext);
            }
            catch (Exception e) {
                LOG.warn("Loading of plugin {} failed, however the exception will be ignored so others plugins can be initialized. Reason: {}", new Object[]{plugin.getClass().getName(), e.getMessage(), e});
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.contextServicePlugins != null) {
            for (ContextServicePlugin plugin : this.contextServicePlugins) {
                try {
                    plugin.unload(this.camelContext);
                }
                catch (Exception e) {
                    LOG.warn("Unloading of plugin {} failed, however the exception will be ignored so shutdown can continue. Reason: {}", new Object[]{plugin.getClass().getName(), e.getMessage(), e});
                }
            }
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

