/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.reader;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.ImplMessages;
import com.sun.jersey.json.impl.reader.CharactersEvent;
import com.sun.jersey.json.impl.reader.EndDocumentEvent;
import com.sun.jersey.json.impl.reader.EndElementEvent;
import com.sun.jersey.json.impl.reader.JsonNamespaceContext;
import com.sun.jersey.json.impl.reader.JsonReaderXmlEvent;
import com.sun.jersey.json.impl.reader.JsonXmlStreamReader;
import com.sun.jersey.json.impl.reader.StartDocumentEvent;
import com.sun.jersey.json.impl.reader.StartElementEvent;
import com.sun.jersey.json.impl.reader.StaxLocation;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class Jackson2StaxReader
implements XMLStreamReader {
    JsonParser parser;
    final Queue<JsonReaderXmlEvent> eventQueue = new LinkedList<JsonReaderXmlEvent>();
    final List<ProcessingInfo> processingStack = new ArrayList<ProcessingInfo>();
    final JsonNamespaceContext namespaceContext = new JsonNamespaceContext();
    private boolean properJAXBVersion = true;
    private final boolean attrsWithPrefix;
    final Collection<String> elemsExpected = new HashSet<String>();
    final Map<String, QName> qNamesOfExpElems = new HashMap<String, QName>();
    final Collection<String> attrsExpected = new HashSet<String>();
    final Map<String, QName> qNamesOfExpAttrs = new HashMap<String, QName>();
    static final Collection<JsonToken> valueTokens = new HashSet<JsonToken>(){
        {
            this.add(JsonToken.VALUE_FALSE);
            this.add(JsonToken.VALUE_TRUE);
            this.add(JsonToken.VALUE_NULL);
            this.add(JsonToken.VALUE_STRING);
            this.add(JsonToken.VALUE_NUMBER_FLOAT);
            this.add(JsonToken.VALUE_NUMBER_INT);
        }
    };

    static <T> T pop(List<T> stack) {
        return stack.remove(stack.size() - 1);
    }

    static <T> T peek(List<T> stack) {
        return stack.size() > 0 ? (T)stack.get(stack.size() - 1) : null;
    }

    static <T> T peek2nd(List<T> stack) {
        return stack.size() > 1 ? (T)stack.get(stack.size() - 2) : null;
    }

    public Jackson2StaxReader(JsonParser parser) throws XMLStreamException {
        this(parser, JSONConfiguration.DEFAULT);
    }

    public Jackson2StaxReader(JsonParser parser, JSONConfiguration config) throws XMLStreamException {
        this.attrsWithPrefix = config.isUsingPrefixesAtNaturalAttributes();
        this.parser = parser;
        try {
            this.readNext();
        }
        catch (IOException ex) {
            Logger.getLogger(Jackson2StaxReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void readNext() throws IOException {
        this.readNext(false);
    }

    private QName getQNameForTagLocName(String localName) {
        return this.getQNameForLocName(localName, this.qNamesOfExpElems);
    }

    private QName getQNameForLocName(String localName, Map<String, QName> qNamesMap) {
        QName result = qNamesMap.get(localName);
        if (result != null) {
            return result;
        }
        return new QName(localName);
    }

    private void readNext(boolean lookingForAttributes) throws IOException {
        if (!lookingForAttributes) {
            this.eventQueue.poll();
        }
        if (this.eventQueue.isEmpty() || lookingForAttributes) {
            while (true) {
                this.parser.nextToken();
                JsonToken jtok = this.parser.getCurrentToken();
                ProcessingInfo pi = Jackson2StaxReader.peek(this.processingStack);
                switch (jtok) {
                    case FIELD_NAME: {
                        boolean currentIsAttribute;
                        String currentName = this.parser.getCurrentName();
                        if (this.attrsWithPrefix && currentName.startsWith("@")) {
                            currentName = currentName.substring(1);
                        }
                        boolean bl = !"$".equals(currentName) && this.properJAXBVersion ? this.attrsExpected.contains(currentName) : (currentIsAttribute = !this.elemsExpected.contains(currentName));
                        if (lookingForAttributes && currentIsAttribute) {
                            this.parser.nextToken();
                            if (valueTokens.contains((Object)this.parser.getCurrentToken())) {
                                this.eventQueue.peek().addAttribute(this.getQNameForLocName(currentName, this.qNamesOfExpAttrs), this.parser.getText());
                                break;
                            }
                            System.out.println(String.format("CurrentName=%s", currentName));
                            throw new IOException("Not an attribute, expected primitive value!");
                        }
                        lookingForAttributes = false;
                        if (!"$".equals(currentName)) {
                            QName currentQName = this.getQNameForTagLocName(currentName);
                            this.eventQueue.add(new StartElementEvent(currentQName, new StaxLocation(this.parser.getCurrentLocation())));
                            this.processingStack.add(new ProcessingInfo(currentQName, false, true));
                            return;
                        }
                        this.parser.nextToken();
                        if (valueTokens.contains((Object)this.parser.getCurrentToken())) {
                            this.eventQueue.add(new CharactersEvent(this.parser.getText(), new StaxLocation(this.parser.getCurrentLocation())));
                            return;
                        }
                        throw new IOException("Not a xml value, expected primitive value!");
                    }
                    case START_OBJECT: {
                        if (pi == null) {
                            this.eventQueue.add(new StartDocumentEvent(new StaxLocation(0, 0, 0)));
                            return;
                        }
                        if (pi.isArray && !pi.isFirstElement) {
                            this.eventQueue.add(new StartElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                            return;
                        }
                        pi.isFirstElement = false;
                        break;
                    }
                    case END_OBJECT: {
                        lookingForAttributes = false;
                        this.eventQueue.add(new EndElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                        if (!pi.isArray) {
                            Jackson2StaxReader.pop(this.processingStack);
                        }
                        if (this.processingStack.isEmpty()) {
                            this.eventQueue.add(new EndDocumentEvent(new StaxLocation(this.parser.getCurrentLocation())));
                        }
                        return;
                    }
                    case VALUE_FALSE: 
                    case VALUE_NULL: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_TRUE: 
                    case VALUE_STRING: {
                        if (!pi.isFirstElement) {
                            this.eventQueue.add(new StartElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                        } else {
                            pi.isFirstElement = false;
                        }
                        if (jtok != JsonToken.VALUE_NULL) {
                            this.eventQueue.add(new CharactersEvent(this.parser.getText(), new StaxLocation(this.parser.getCurrentLocation())));
                        }
                        this.eventQueue.add(new EndElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                        if (!pi.isArray) {
                            Jackson2StaxReader.pop(this.processingStack);
                        }
                        if (this.processingStack.isEmpty()) {
                            this.eventQueue.add(new EndDocumentEvent(new StaxLocation(this.parser.getCurrentLocation())));
                        }
                        lookingForAttributes = false;
                        return;
                    }
                    case START_ARRAY: {
                        Jackson2StaxReader.peek(this.processingStack).isArray = true;
                        break;
                    }
                    case END_ARRAY: {
                        Jackson2StaxReader.pop(this.processingStack);
                        lookingForAttributes = false;
                    }
                }
            }
        }
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            this.readNext();
            return this.eventQueue.peek().getEventType();
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNamespaceURI(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isStartElement() {
        return this.eventQueue.peek().isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.eventQueue.peek().isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.eventQueue.peek().isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.eventQueue.peek().getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        block12: {
            try {
                if (this.eventQueue.peek().attributesChecked) break block12;
                this.elemsExpected.clear();
                this.qNamesOfExpElems.clear();
                this.attrsExpected.clear();
                this.qNamesOfExpAttrs.clear();
                UnmarshallingContext uctx = UnmarshallingContext.getInstance();
                if (uctx != null) {
                    try {
                        Collection<QName> currExpElems = uctx.getCurrentExpectedElements();
                        for (QName n : currExpElems) {
                            String nu = n.getNamespaceURI();
                            if (nu != null && nu.equals("\u0000")) {
                                this.elemsExpected.add("$");
                                this.qNamesOfExpElems.put("$", null);
                                continue;
                            }
                            this.elemsExpected.add(n.getLocalPart());
                            this.qNamesOfExpElems.put(n.getLocalPart(), n);
                        }
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    if (this.properJAXBVersion) {
                        try {
                            Collection<QName> currExpAttrs = uctx.getCurrentExpectedAttributes();
                            for (QName n : currExpAttrs) {
                                this.attrsExpected.add(n.getLocalPart());
                                this.qNamesOfExpAttrs.put(n.getLocalPart(), n);
                            }
                        }
                        catch (NullPointerException npe) {
                        }
                        catch (NoSuchMethodError nsme) {
                            this.properJAXBVersion = false;
                            Logger.getLogger(Jackson2StaxReader.class.getName()).log(Level.SEVERE, ImplMessages.ERROR_JAXB_RI_2_1_12_MISSING(), nsme);
                        }
                    }
                }
                this.readNext(true);
                this.eventQueue.peek().attributesChecked = true;
            }
            catch (IOException ex) {
                Logger.getLogger(Jackson2StaxReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.eventQueue.peek().getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.eventQueue.peek().getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.eventQueue.peek().getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.eventQueue.peek().getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.eventQueue.peek().getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.eventQueue.peek().getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.eventQueue.peek().getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.eventQueue.peek().isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.namespaceContext.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int idx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNamespaceURI(int idx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public int getEventType() {
        return this.eventQueue.peek().getEventType();
    }

    @Override
    public String getText() {
        return this.eventQueue.peek().getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.eventQueue.peek().getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.eventQueue.peek().getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.eventQueue.peek().getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.eventQueue.peek().getTextLength();
    }

    @Override
    public String getEncoding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Location getLocation() {
        return this.eventQueue.peek().getLocation();
    }

    @Override
    public QName getName() {
        return this.eventQueue.peek().getName();
    }

    @Override
    public String getLocalName() {
        return this.eventQueue.peek().getLocalName();
    }

    @Override
    public boolean hasName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNamespaceURI() {
        return this.eventQueue.peek().getName().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.eventQueue.peek().getPrefix();
    }

    @Override
    public String getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isStandalone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean standaloneSet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getCharacterEncodingScheme() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class ProcessingInfo {
        QName name;
        boolean isArray;
        boolean isFirstElement;

        ProcessingInfo(QName name, boolean isArray, boolean isFirstElement) {
            this.name = name;
            this.isArray = isArray;
            this.isFirstElement = isFirstElement;
        }
    }
}

