/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.LogAggregationWebUtils;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class LogAggregationHtmlBlock
extends HtmlBlock {
    @Inject
    public LogAggregationHtmlBlock(View.ViewContext ctx) {
        super(ctx);
    }

    protected BlockParameters verifyAndParseParameters(HtmlBlock.Block html) {
        BlockParameters params = new BlockParameters();
        ContainerId containerId = LogAggregationWebUtils.verifyAndGetContainerId(html, this.$("container.id"));
        params.setContainerId(containerId);
        NodeId nodeId = LogAggregationWebUtils.verifyAndGetNodeId(html, this.$("nm.id"));
        params.setNodeId(nodeId);
        String appOwner = LogAggregationWebUtils.verifyAndGetAppOwner(html, this.$("app.owner"));
        params.setAppOwner(appOwner);
        boolean isValid = true;
        long start = -4096L;
        try {
            start = LogAggregationWebUtils.getLogStartIndex(html, this.$("start"));
        }
        catch (NumberFormatException ne) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log start value: " + this.$("start")}))).__();
            isValid = false;
        }
        params.setStartIndex(start);
        long end = Long.MAX_VALUE;
        try {
            end = LogAggregationWebUtils.getLogEndIndex(html, this.$("end"));
        }
        catch (NumberFormatException ne) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log end value: " + this.$("end")}))).__();
            isValid = false;
        }
        params.setEndIndex(end);
        long startTime = 0L;
        try {
            startTime = LogAggregationWebUtils.getLogStartTime(this.$("start.time"));
        }
        catch (NumberFormatException ne) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log start time value: " + this.$("start.time")}))).__();
            isValid = false;
        }
        params.setStartTime(startTime);
        long endTime = Long.MAX_VALUE;
        try {
            endTime = LogAggregationWebUtils.getLogEndTime(this.$("end.time"));
            if (endTime < startTime) {
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log end time value: " + this.$("end.time") + ". It should be larger than start time value:" + startTime}))).__();
                isValid = false;
            }
        }
        catch (NumberFormatException ne) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log end time value: " + this.$("end.time")}))).__();
            isValid = false;
        }
        params.setEndTime(endTime);
        if (containerId == null || nodeId == null || appOwner == null || appOwner.isEmpty() || !isValid) {
            return null;
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        params.setAppId(appId);
        String logEntity = this.$("entity.string");
        if (logEntity == null || logEntity.isEmpty()) {
            logEntity = containerId.toString();
        }
        params.setLogEntity(logEntity);
        return params;
    }

    protected boolean checkAcls(Configuration conf, ApplicationId appId, String owner, Map<ApplicationAccessType, String> appAcls, String remoteUser) {
        ApplicationACLsManager aclsManager = new ApplicationACLsManager(conf);
        aclsManager.addApplication(appId, appAcls);
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser(remoteUser);
        }
        return callerUGI == null || aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, owner, appId);
    }

    protected long[] checkParseRange(HtmlBlock.Block html, long startIndex, long endIndex, long startTime, long endTime, long logLength, String logType) {
        long start = startIndex < 0L ? logLength + startIndex : startIndex;
        start = start < 0L ? 0L : start;
        start = start > logLength ? logLength : start;
        long end = endIndex < 0L ? logLength + endIndex : endIndex;
        end = end < 0L ? 0L : end;
        end = end > logLength ? logLength : end;
        long toRead = (end = end < start ? start : end) - start;
        if (toRead < logLength) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)((Hamlet.P)((Hamlet.P)html.p()).__(new Object[]{"Showing " + toRead + " bytes of " + logLength + " total. Click "})).a(this.url("logs", this.$("nm.id"), this.$("container.id"), this.$("entity.string"), this.$("app.owner"), logType, "?start=0&start.time=" + startTime + "&end.time=" + endTime), "here")).__(new Object[]{" for the full log."}))).__();
        }
        return new long[]{start, end};
    }

    protected void processContainerLog(HtmlBlock.Block html, long[] range, InputStream in, int bufferSize, byte[] cbuf) throws IOException {
        long ret;
        long start = range[0];
        long toRead = range[1] - range[0];
        for (long totalSkipped = 0L; totalSkipped < start; totalSkipped += ret) {
            ret = in.skip(start - totalSkipped);
            if (ret != 0L) continue;
            int nextByte = in.read();
            if (nextByte == -1) {
                throw new IOException("Premature EOF from container log");
            }
            ret = 1L;
        }
        int len = 0;
        int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
        HamletSpec.PRE pre = html.pre();
        while (toRead > 0L && (len = in.read(cbuf, 0, currentToRead)) > 0) {
            ((Hamlet.PRE)pre).__(new Object[]{new String(cbuf, 0, len, Charset.forName("UTF-8"))});
            currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
        }
        ((HamletImpl.EImp)((Object)pre)).__();
    }

    protected static class BlockParameters {
        private ApplicationId appId;
        private ContainerId containerId;
        private NodeId nodeId;
        private String appOwner;
        private long start;
        private long end;
        private String logEntity;
        private long startTime;
        private long endTime;

        protected BlockParameters() {
        }

        public ApplicationId getAppId() {
            return this.appId;
        }

        public void setAppId(ApplicationId appId) {
            this.appId = appId;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public void setContainerId(ContainerId containerId) {
            this.containerId = containerId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
        }

        public String getAppOwner() {
            return this.appOwner;
        }

        public void setAppOwner(String appOwner) {
            this.appOwner = appOwner;
        }

        public long getStartIndex() {
            return this.start;
        }

        public void setStartIndex(long startIndex) {
            this.start = startIndex;
        }

        public long getEndIndex() {
            return this.end;
        }

        public void setEndIndex(long endIndex) {
            this.end = endIndex;
        }

        public String getLogEntity() {
            return this.logEntity;
        }

        public void setLogEntity(String logEntity) {
            this.logEntity = logEntity;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }
    }
}

