/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private final Ed25519 ed25519 = new Ed25519(){

        protected Digest createDigest() {
            return Register.createDigest(FipsSHS.Algorithm.SHA512);
        }
    };
    private final byte[] data = new byte[32];

    public Ed25519PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        this.ed25519.generatePrivateKey(secureRandom, this.data);
    }

    public Ed25519PrivateKeyParameters(byte[] byArray, int n) {
        super(true);
        System.arraycopy(byArray, n, this.data, 0, 32);
    }

    public Ed25519PrivateKeyParameters(InputStream inputStream) throws IOException {
        super(true);
        if (32 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 private key");
        }
    }

    public void encode(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed25519PublicKeyParameters generatePublicKey() {
        byte[] byArray = new byte[32];
        this.ed25519.generatePublicKey(this.data, 0, byArray, 0);
        return new Ed25519PublicKeyParameters(byArray, 0);
    }

    public void sign(int n, Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        byte[] byArray4 = new byte[32];
        if (null == ed25519PublicKeyParameters) {
            this.ed25519.generatePublicKey(this.data, 0, byArray4, 0);
        } else {
            ed25519PublicKeyParameters.encode(byArray4, 0);
        }
        switch (n) {
            case 0: {
                if (null != byArray) {
                    throw new IllegalArgumentException("ctx");
                }
                this.ed25519.sign(this.data, 0, byArray4, 0, byArray2, n2, n3, byArray3, n4);
                break;
            }
            case 1: {
                this.ed25519.sign(this.data, 0, byArray4, 0, byArray, byArray2, n2, n3, byArray3, n4);
                break;
            }
            case 2: {
                if (64 != n3) {
                    throw new IllegalArgumentException("msgLen");
                }
                this.ed25519.signPrehash(this.data, 0, byArray4, 0, byArray, byArray2, n2, byArray3, n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

