/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.internal.StandardComponentId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class ComponentId {
    private ComponentId() {
    }

    public abstract String getTypeName();

    public abstract String getComponentName();

    public static ComponentId generateLazy(String componentType) {
        return new Lazy(componentType);
    }

    public static StandardComponentId generateLazy(StandardComponentId.ExporterType exporterType) {
        return new StandardComponentId(exporterType);
    }

    static class Lazy
    extends ComponentId {
        private static final Map<String, AtomicInteger> nextIdCounters = new ConcurrentHashMap<String, AtomicInteger>();
        private final String componentType;
        @Nullable
        private volatile String componentName = null;

        Lazy(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public String getTypeName() {
            return this.componentType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getComponentName() {
            if (this.componentName == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    if (this.componentName == null) {
                        int id = nextIdCounters.computeIfAbsent(this.componentType, k -> new AtomicInteger(0)).getAndIncrement();
                        this.componentName = this.componentType + "/" + id;
                    }
                }
            }
            return this.componentName;
        }
    }
}

