/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

final class Util {
    static final long ENTRY_OFF_LRU_NEXT = 0L;
    static final long ENTRY_OFF_LRU_PREV = 8L;
    static final long ENTRY_OFF_NEXT = 16L;
    static final long ENTRY_OFF_REFCOUNT = 24L;
    static final long ENTRY_OFF_SENTINEL = 28L;
    static final long ENTRY_OFF_HASH = 32L;
    static final long ENTRY_OFF_VALUE_LENGTH = 40L;
    static final long ENTRY_OFF_KEY_LENGTH = 48L;
    static final long ENTRY_OFF_DATA = 56L;
    static final long BUCKET_ENTRY_LEN = 8L;
    static final int HEADER_COMPRESSED = 1330135875;
    static final int HEADER_COMPRESSED_WRONG = 1128482895;
    static final int HEADER_ENTRIES = 1330135877;
    static final int HEADER_ENTRIES_WRONG = 1162037327;
    static final int HEADER_KEYS = 1330135883;
    static final int HEADER_KEYS_WRONG = 1262700623;
    static final int SENTINEL_NOT_PRESENT = 0;
    static final int SENTINEL_LOADING = 1;
    static final int SENTINEL_SUCCESS = 2;
    static final int SENTINEL_TEMPORARY_FAILURE = 3;
    static final int SENTINEL_PERMANENT_FAILURE = 4;

    Util() {
    }

    static long roundUpTo8(long val) {
        long rem = val & 7L;
        if (rem != 0L) {
            val += 8L - rem;
        }
        return val;
    }

    static long allocLen(long keyLen, long valueLen) {
        return 56L + Util.roundUpTo8(keyLen) + valueLen;
    }

    static void writeFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            channel.write(buffer);
        }
    }

    static boolean readFully(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            int rd = channel.read(buffer);
            if (rd != -1) continue;
            return false;
        }
        return true;
    }

    static int bitNum(long val) {
        int bit = 0;
        while (val != 0L) {
            val >>>= 1;
            ++bit;
        }
        return bit;
    }

    static long roundUpToPowerOf2(long number, long max) {
        return number >= max ? max : (number > 1L ? Long.highestOneBit(number - 1L << 1) : 1L);
    }
}

