/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstone {
    private final Slice slice;
    private final DeletionTime deletion;

    public RangeTombstone(Slice slice, DeletionTime deletion) {
        this.slice = slice;
        this.deletion = deletion;
    }

    public Slice deletedSlice() {
        return this.slice;
    }

    public DeletionTime deletionTime() {
        return this.deletion;
    }

    public String toString(ClusteringComparator comparator) {
        return this.slice.toString(comparator) + '@' + this.deletion;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstone)) {
            return false;
        }
        RangeTombstone that = (RangeTombstone)other;
        return this.deletedSlice().equals(that.deletedSlice()) && this.deletionTime().equals(that.deletionTime());
    }

    public int hashCode() {
        return Objects.hash(this.deletedSlice(), this.deletionTime());
    }

    public static class Bound
    extends Slice.Bound {
        public static final Serializer serializer = new Serializer();
        public static final Bound BOTTOM = new Bound(ClusteringPrefix.Kind.INCL_START_BOUND, EMPTY_VALUES_ARRAY);
        public static final Bound TOP = new Bound(ClusteringPrefix.Kind.INCL_END_BOUND, EMPTY_VALUES_ARRAY);

        public Bound(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
            super(kind, values);
            assert (values.length > 0 || !kind.isBoundary());
        }

        public boolean isBoundary() {
            return this.kind.isBoundary();
        }

        public boolean isOpen(boolean reversed) {
            return this.kind.isOpen(reversed);
        }

        public boolean isClose(boolean reversed) {
            return this.kind.isClose(reversed);
        }

        public static Bound inclusiveOpen(boolean reversed, ByteBuffer[] boundValues) {
            return new Bound(reversed ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.INCL_START_BOUND, boundValues);
        }

        public static Bound exclusiveOpen(boolean reversed, ByteBuffer[] boundValues) {
            return new Bound(reversed ? ClusteringPrefix.Kind.EXCL_END_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND, boundValues);
        }

        public static Bound inclusiveClose(boolean reversed, ByteBuffer[] boundValues) {
            return new Bound(reversed ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.INCL_END_BOUND, boundValues);
        }

        public static Bound exclusiveClose(boolean reversed, ByteBuffer[] boundValues) {
            return new Bound(reversed ? ClusteringPrefix.Kind.EXCL_START_BOUND : ClusteringPrefix.Kind.EXCL_END_BOUND, boundValues);
        }

        public static Bound inclusiveCloseExclusiveOpen(boolean reversed, ByteBuffer[] boundValues) {
            return new Bound(reversed ? ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY : ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY, boundValues);
        }

        public static Bound exclusiveCloseInclusiveOpen(boolean reversed, ByteBuffer[] boundValues) {
            return new Bound(reversed ? ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY : ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY, boundValues);
        }

        public static Bound fromSliceBound(Slice.Bound sliceBound) {
            return new Bound(sliceBound.kind(), sliceBound.getRawValues());
        }

        public Bound copy(AbstractAllocator allocator) {
            ByteBuffer[] newValues = new ByteBuffer[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                newValues[i] = allocator.clone(this.get(i));
            }
            return new Bound(this.kind(), newValues);
        }

        @Override
        public ClusteringPrefix minimize() {
            if (!ByteBufferUtil.canMinimize(this.values)) {
                return this;
            }
            return new Bound(this.kind, ByteBufferUtil.minimizeBuffers(this.values));
        }

        @Override
        public Bound withNewKind(ClusteringPrefix.Kind kind) {
            return new Bound(kind, this.values);
        }

        public static class Serializer {
            public void serialize(Bound bound, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
                out.writeByte(bound.kind().ordinal());
                out.writeShort(bound.size());
                ClusteringPrefix.serializer.serializeValuesWithoutSize(bound, out, version, types);
            }

            public long serializedSize(Bound bound, int version, List<AbstractType<?>> types) {
                return (long)(1 + TypeSizes.sizeof((short)bound.size())) + ClusteringPrefix.serializer.valuesWithoutSizeSerializedSize(bound, version, types);
            }

            public Bound deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
                ClusteringPrefix.Kind kind = ClusteringPrefix.Kind.values()[in.readByte()];
                return this.deserializeValues(in, kind, version, types);
            }

            public Bound deserializeValues(DataInputPlus in, ClusteringPrefix.Kind kind, int version, List<AbstractType<?>> types) throws IOException {
                int size = in.readUnsignedShort();
                if (size == 0) {
                    return kind.isStart() ? BOTTOM : TOP;
                }
                ByteBuffer[] values = ClusteringPrefix.serializer.deserializeValuesWithoutSize(in, size, version, types);
                return new Bound(kind, values);
            }
        }
    }
}

