/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.RatioGauge;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Meter hits;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Double> oneMinuteHitRate;
    public final Gauge<Double> fiveMinuteHitRate;
    public final Gauge<Double> fifteenMinuteHitRate;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;

    public CacheMetrics(String type, final ICache cache) {
        DefaultNameFactory factory = new DefaultNameFactory("Cache", type);
        this.capacity = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Capacity"), new Gauge<Long>(){

            public Long getValue() {
                return cache.capacity();
            }
        });
        this.hits = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Hits"));
        this.requests = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Requests"));
        this.hitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(factory.createMetricName("HitRate"), new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)CacheMetrics.this.hits.getCount(), (double)CacheMetrics.this.requests.getCount());
            }
        });
        this.oneMinuteHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(factory.createMetricName("OneMinuteHitRate"), new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)CacheMetrics.this.hits.getOneMinuteRate(), (double)CacheMetrics.this.requests.getOneMinuteRate());
            }
        });
        this.fiveMinuteHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(factory.createMetricName("FiveMinuteHitRate"), new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)CacheMetrics.this.hits.getFiveMinuteRate(), (double)CacheMetrics.this.requests.getFiveMinuteRate());
            }
        });
        this.fifteenMinuteHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(factory.createMetricName("FifteenMinuteHitRate"), new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)CacheMetrics.this.hits.getFifteenMinuteRate(), (double)CacheMetrics.this.requests.getFifteenMinuteRate());
            }
        });
        this.size = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Size"), new Gauge<Long>(){

            public Long getValue() {
                return cache.weightedSize();
            }
        });
        this.entries = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Entries"), new Gauge<Integer>(){

            public Integer getValue() {
                return cache.size();
            }
        });
    }
}

