/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.UUID;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class ReceivedMessage
extends StreamMessage {
    public static StreamMessage.Serializer<ReceivedMessage> serializer = new StreamMessage.Serializer<ReceivedMessage>(){

        @Override
        public ReceivedMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputPlus.DataInputStreamPlus input = new DataInputPlus.DataInputStreamPlus(Channels.newInputStream(in));
            return new ReceivedMessage(UUIDSerializer.serializer.deserialize(input, MessagingService.current_version), input.readInt());
        }

        @Override
        public void serialize(ReceivedMessage message, DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
            UUIDSerializer.serializer.serialize(message.cfId, (DataOutputPlus)out, MessagingService.current_version);
            out.writeInt(message.sequenceNumber);
        }
    };
    public final UUID cfId;
    public final int sequenceNumber;

    public ReceivedMessage(UUID cfId, int sequenceNumber) {
        super(StreamMessage.Type.RECEIVED);
        this.cfId = cfId;
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Received (");
        sb.append(this.cfId).append(", #").append(this.sequenceNumber).append(')');
        return sb.toString();
    }
}

