/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.ConnectionStyle;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class CqlOperation<V>
extends PredefinedOperation {
    public static final ByteBuffer[][] EMPTY_BYTE_BUFFERS = new ByteBuffer[0][];
    public static final byte[][] EMPTY_BYTE_ARRAYS = new byte[0][];

    protected abstract List<Object> getQueryParameters(byte[] var1);

    protected abstract String buildQuery();

    protected abstract CqlRunOp<V> buildRunOp(QueryExecutor<?> var1, List<Object> var2, ByteBuffer var3);

    public CqlOperation(Command type, Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(type, timer, generator, seedManager, settings);
        if (settings.columns.variableColumnCount) {
            throw new IllegalStateException("Variable column counts are not implemented for CQL");
        }
    }

    protected CqlRunOp<V> run(QueryExecutor<?> queryExecutor, List<Object> queryParams, ByteBuffer key) throws IOException {
        CqlRunOp<V> op = this.buildRunOp(queryExecutor, queryParams, key);
        this.timeWithRetry(op);
        return op;
    }

    protected void run(QueryExecutor<?> queryExecutor) throws IOException {
        byte[] key = this.getKey().array();
        List<Object> queryParams = this.getQueryParameters(key);
        this.run(queryExecutor, queryParams, ByteBuffer.wrap(key));
    }

    @Override
    public void run(SimpleClient client) throws IOException {
        this.run(new SimpleClientQueryExecutor(client, this.buildQuery()));
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.run(new JavaDriverQueryExecutor(client, this.buildQuery()));
    }

    private static String getUnQuotedCqlBlob(ByteBuffer term) {
        return "0x" + ByteBufferUtil.bytesToHex((ByteBuffer)term);
    }

    private static List<ByteBuffer> toByteBufferParams(List<Object> params) {
        ArrayList<ByteBuffer> r = new ArrayList<ByteBuffer>();
        for (Object param : params) {
            if (param instanceof ByteBuffer) {
                r.add((ByteBuffer)param);
                continue;
            }
            if (param instanceof Long) {
                r.add(ByteBufferUtil.bytes((long)((Long)param)));
                continue;
            }
            throw new AssertionError();
        }
        return r;
    }

    protected String wrapInQuotes(String string) {
        return "\"" + string + "\"";
    }

    protected static final class KeysHandler
    implements ResultHandler<byte[][]> {
        static final KeysHandler INSTANCE = new KeysHandler();

        protected KeysHandler() {
        }

        @Override
        public Function<ResultSet, byte[][]> javaDriverHandler() {
            return new Function<ResultSet, byte[][]>(){

                public byte[][] apply(ResultSet result) {
                    if (result == null) {
                        return EMPTY_BYTE_ARRAYS;
                    }
                    List rows = result.all();
                    byte[][] r = new byte[rows.size()][];
                    for (int i = 0; i < r.length; ++i) {
                        r[i] = ((Row)rows.get(i)).getBytes(0).array();
                    }
                    return r;
                }
            };
        }

        @Override
        public Function<ResultMessage, byte[][]> simpleClientHandler() {
            return new Function<ResultMessage, byte[][]>(){

                public byte[][] apply(ResultMessage result) {
                    if (result instanceof ResultMessage.Rows) {
                        ResultMessage.Rows rows = (ResultMessage.Rows)result;
                        byte[][] r = new byte[rows.result.size()][];
                        for (int i = 0; i < r.length; ++i) {
                            r[i] = ((ByteBuffer)((List)rows.result.rows.get(i)).get(0)).array();
                        }
                        return r;
                    }
                    return null;
                }
            };
        }
    }

    protected static final class RowsHandler
    implements ResultHandler<ByteBuffer[][]> {
        static final RowsHandler INSTANCE = new RowsHandler();

        protected RowsHandler() {
        }

        @Override
        public Function<ResultSet, ByteBuffer[][]> javaDriverHandler() {
            return new Function<ResultSet, ByteBuffer[][]>(){

                public ByteBuffer[][] apply(ResultSet result) {
                    if (result == null) {
                        return EMPTY_BYTE_BUFFERS;
                    }
                    List rows = result.all();
                    ByteBuffer[][] r = new ByteBuffer[rows.size()][];
                    for (int i = 0; i < r.length; ++i) {
                        Row row = (Row)rows.get(i);
                        r[i] = new ByteBuffer[row.getColumnDefinitions().size()];
                        for (int j = 0; j < row.getColumnDefinitions().size(); ++j) {
                            r[i][j] = row.getBytes(j);
                        }
                    }
                    return r;
                }
            };
        }

        @Override
        public Function<ResultMessage, ByteBuffer[][]> simpleClientHandler() {
            return new Function<ResultMessage, ByteBuffer[][]>(){

                public ByteBuffer[][] apply(ResultMessage result) {
                    if (!(result instanceof ResultMessage.Rows)) {
                        return EMPTY_BYTE_BUFFERS;
                    }
                    ResultMessage.Rows rows = (ResultMessage.Rows)result;
                    ByteBuffer[][] r = new ByteBuffer[rows.result.size()][];
                    for (int i = 0; i < r.length; ++i) {
                        List row = (List)rows.result.rows.get(i);
                        r[i] = new ByteBuffer[row.size()];
                        for (int j = 0; j < row.size(); ++j) {
                            r[i][j] = (ByteBuffer)row.get(j);
                        }
                    }
                    return r;
                }
            };
        }
    }

    protected static class RowCountHandler
    implements ResultHandler<Integer> {
        static final RowCountHandler INSTANCE = new RowCountHandler();

        protected RowCountHandler() {
        }

        @Override
        public Function<ResultSet, Integer> javaDriverHandler() {
            return new Function<ResultSet, Integer>(){

                public Integer apply(ResultSet rows) {
                    if (rows == null) {
                        return 0;
                    }
                    return rows.all().size();
                }
            };
        }

        @Override
        public Function<ResultMessage, Integer> simpleClientHandler() {
            return new Function<ResultMessage, Integer>(){

                public Integer apply(ResultMessage result) {
                    return result instanceof ResultMessage.Rows ? ((ResultMessage.Rows)result).result.size() : 0;
                }
            };
        }
    }

    protected static interface ResultHandler<V> {
        public Function<ResultSet, V> javaDriverHandler();

        public Function<ResultMessage, V> simpleClientHandler();
    }

    private final class SimpleClientQueryExecutor
    extends QueryExecutor<ResultMessage.Prepared> {
        final SimpleClient client;

        private SimpleClientQueryExecutor(SimpleClient client, String query) {
            super(query);
            this.client = client;
        }

        @Override
        public <V> V execute(String formattedQuery, ByteBuffer key, ResultHandler<V> handler) {
            return (V)handler.simpleClientHandler().apply((Object)this.client.execute(formattedQuery, CqlOperation.this.settings.command.consistencyLevel));
        }

        @Override
        public <V> V execute(ResultMessage.Prepared preparedStatement, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            return (V)handler.simpleClientHandler().apply((Object)this.client.executePrepared(preparedStatement, CqlOperation.toByteBufferParams(queryParams), CqlOperation.this.settings.command.consistencyLevel));
        }

        @Override
        public ResultMessage.Prepared createPreparedStatement(String cqlQuery) {
            return this.client.prepare(cqlQuery);
        }
    }

    private final class JavaDriverQueryExecutor
    extends QueryExecutor<PreparedStatement> {
        final JavaDriverClient client;

        private JavaDriverQueryExecutor(JavaDriverClient client, String query) {
            super(query);
            this.client = client;
        }

        @Override
        protected <V> V execute(String formattedQuery, ByteBuffer key, ResultHandler<V> handler) {
            return (V)handler.javaDriverHandler().apply((Object)this.client.execute(formattedQuery, CqlOperation.this.settings.command.consistencyLevel));
        }

        @Override
        protected <V> V execute(PreparedStatement preparedStatement, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            return (V)handler.javaDriverHandler().apply((Object)this.client.executePrepared(preparedStatement, queryParams, CqlOperation.this.settings.command.consistencyLevel));
        }

        @Override
        public PreparedStatement createPreparedStatement(String cqlQuery) {
            return this.client.prepare(cqlQuery);
        }
    }

    protected abstract class QueryExecutor<PS> {
        private final String query;
        private PS preparedStatement;

        public QueryExecutor(String query) {
            this.query = query;
        }

        private boolean isPrepared() {
            return CqlOperation.this.settings.mode.style == ConnectionStyle.CQL_PREPARED;
        }

        protected abstract PS createPreparedStatement(String var1);

        private PS getPreparedStatement() {
            if (this.preparedStatement == null) {
                this.preparedStatement = this.createPreparedStatement(this.query);
            }
            return this.preparedStatement;
        }

        private String formatCqlQuery(String query, List<Object> parms) {
            int position = 0;
            StringBuilder result = new StringBuilder();
            int marker = query.indexOf(63);
            if (-1 == marker || parms.size() == 0) {
                return query;
            }
            for (Object parm : parms) {
                result.append(query.substring(position, marker));
                if (parm instanceof ByteBuffer) {
                    result.append(CqlOperation.getUnQuotedCqlBlob((ByteBuffer)parm));
                } else if (parm instanceof Long) {
                    result.append(parm);
                } else {
                    throw new AssertionError();
                }
                if (-1 != (marker = query.indexOf(63, (position = marker + 1) + 1))) continue;
                break;
            }
            if (position < query.length()) {
                result.append(query.substring(position));
            }
            return result.toString();
        }

        <V> V execute(ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            return this.isPrepared() ? this.execute(this.getPreparedStatement(), key, queryParams, handler) : this.execute(this.formatCqlQuery(this.query, queryParams), key, handler);
        }

        abstract <V> V execute(PS var1, ByteBuffer var2, List<Object> var3, ResultHandler<V> var4);

        abstract <V> V execute(String var1, ByteBuffer var2, ResultHandler<V> var3);
    }

    protected abstract class CqlRunOp<V>
    implements Operation.RunOp {
        final QueryExecutor<?> queryExecutor;
        final List<Object> params;
        final ByteBuffer key;
        final ResultHandler<V> handler;
        V result;

        private CqlRunOp(QueryExecutor<?> queryExecutor, ResultHandler<V> handler, List<Object> params, ByteBuffer key) {
            this.queryExecutor = queryExecutor;
            this.handler = handler;
            this.params = params;
            this.key = key;
        }

        @Override
        public boolean run() throws Exception {
            this.result = this.queryExecutor.execute(this.key, this.params, this.handler);
            return this.validate(this.result);
        }

        public abstract boolean validate(V var1);
    }

    protected final class CqlRunOpMatchResults
    extends CqlRunOp<ByteBuffer[][]> {
        final List<List<ByteBuffer>> expect;

        protected CqlRunOpMatchResults(QueryExecutor<?> queryExecutor, List<Object> params, ByteBuffer key, List<List<ByteBuffer>> expect) {
            super(queryExecutor, RowsHandler.INSTANCE, params, key);
            this.expect = expect;
        }

        @Override
        public int partitionCount() {
            return this.result == null ? 0 : ((ByteBuffer[][])this.result).length;
        }

        @Override
        public int rowCount() {
            return this.result == null ? 0 : ((ByteBuffer[][])this.result).length;
        }

        @Override
        public boolean validate(ByteBuffer[][] result) {
            if (!CqlOperation.this.settings.errors.skipReadValidation) {
                if (result.length != this.expect.size()) {
                    return false;
                }
                for (int i = 0; i < result.length; ++i) {
                    if (this.expect.get(i) == null || this.expect.get(i).equals(Arrays.asList(result[i]))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    protected final class CqlRunOpTestNonEmpty
    extends CqlRunOp<Integer> {
        protected CqlRunOpTestNonEmpty(QueryExecutor<?> queryExecutor, List<Object> params, ByteBuffer key) {
            super(queryExecutor, RowCountHandler.INSTANCE, params, key);
        }

        @Override
        public boolean validate(Integer result) {
            return result > 0;
        }

        @Override
        public int partitionCount() {
            return (Integer)this.result;
        }

        @Override
        public int rowCount() {
            return (Integer)this.result;
        }
    }

    protected final class CqlRunOpAlwaysSucceed
    extends CqlRunOp<Integer> {
        final int keyCount;

        protected CqlRunOpAlwaysSucceed(QueryExecutor<?> queryExecutor, List<Object> params, ByteBuffer key, int keyCount) {
            super(queryExecutor, RowCountHandler.INSTANCE, params, key);
            this.keyCount = keyCount;
        }

        @Override
        public boolean validate(Integer result) {
            return true;
        }

        @Override
        public int partitionCount() {
            return this.keyCount;
        }

        @Override
        public int rowCount() {
            return this.keyCount;
        }
    }
}

